/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionModelingTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.VeriniceElementTransfer;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.ITargetObject;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bp.rcp.Messages;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.iso27k.rcp.action.DropPerformer;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.InfoDialogWithShowToggle;
import sernet.verinice.service.bp.exceptions.BpReferencingException;
import sernet.verinice.service.commands.bp.CheckReferencingCommand;
import sernet.verinice.service.commands.bp.ReferencingCommand;

public class BpReferencingDropPerformer
implements DropPerformer,
RightEnabledUserInteraction {
    private static final Logger log = Logger.getLogger(BpReferencingDropPerformer.class);
    private boolean isActive = false;

    @Override
    public boolean performDrop(Object data, Object target, Viewer viewer) {
        try {
            List<CnATreeElement> draggedModules;
            if (BaseProtectionModelingTransfer.isDraggedDataValid(data) && this.isValid(draggedModules = this.getDraggedElements(data))) {
                CnATreeElement targetElement = (CnATreeElement)target;
                Set<String> existingModules = this.getExistingModules(draggedModules, targetElement);
                boolean execute = true;
                if (!existingModules.isEmpty()) {
                    execute = this.confirmReferencing(existingModules, targetElement);
                }
                if (execute) {
                    this.startReferencingByProgressService(draggedModules, targetElement);
                    this.showConfirmationDialog();
                }
            }
            return true;
        }
        catch (InvocationTargetException | CommandException e) {
            log.error((Object)e);
            this.showError((Exception)e);
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)"InterruptedException occurred while model module and element", (Throwable)e);
            this.showError(e);
            return false;
        }
    }

    private void startReferencingByProgressService(final List<CnATreeElement> draggedModules, final CnATreeElement target) throws InvocationTargetException, InterruptedException {
        this.closeEditors();
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(BpReferencingDropPerformer.this.getTaskMessage(draggedModules, target), -1);
                    BpReferencingDropPerformer.this.addModuleReferences(draggedModules, target);
                    monitor.done();
                }
                catch (CommandException e) {
                    BpReferencingDropPerformer.this.showError((Exception)((Object)e));
                }
            }
        });
    }

    private boolean isValid(List<CnATreeElement> draggedModules) {
        if (draggedModules == null || draggedModules.isEmpty()) {
            log.warn((Object)"List of dragged modules is empty. Cannot create references.");
            return false;
        }
        return true;
    }

    private void showConfirmationDialog() {
        InfoDialogWithShowToggle.openInformation(Messages.BpReferencingDropPerformerConfirmationTitle, Messages.BpReferencingDropPerformerConfirmation, Messages.BpReferencingDropPerformerConfirmationToggleMessage, "info_bp_referencing_confirmation");
    }

    private void closeEditors() {
        IEditorReference[] editorReferences;
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference er = iEditorReferenceArray[n2];
            try {
                if (!er.isPinned() && !er.isDirty() && er.getEditorInput() instanceof BSIElementEditorInput) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(er.getEditor(true), true);
                }
            }
            catch (PartInitException e) {
                ExceptionUtil.log(e, Messages.BpReferencingDropPerformer_errorClosingEditors);
            }
            ++n2;
        }
    }

    private List<CnATreeElement> getDraggedElements(Object data) {
        List<CnATreeElement> elementList = null;
        if (data instanceof Object[]) {
            elementList = new ArrayList<CnATreeElement>(((Object[])data).length);
            Object[] objectArray = (Object[])data;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof CnATreeElement) {
                    elementList.add((CnATreeElement)o);
                }
                ++n2;
            }
        } else {
            elementList = Collections.emptyList();
        }
        return elementList;
    }

    protected String getTaskMessage(List<CnATreeElement> draggedModules, CnATreeElement targetElement) {
        int number = draggedModules.size();
        if (number == 1) {
            return this.getMessageForOneModule(draggedModules.get(0), targetElement);
        }
        return this.getMessageForMoreThanOneModule(draggedModules, targetElement);
    }

    private String getMessageForMoreThanOneModule(List<CnATreeElement> draggedModules, CnATreeElement targetElement) {
        String firstModuleTitle = draggedModules.get(0).getTitle();
        String targetTitle = targetElement.getTitle();
        int numberMinusOne = draggedModules.size() - 1;
        if (numberMinusOne == 1) {
            return NLS.bind((String)Messages.BpReferencingDropPerformer_TwoModules, (Object[])new Object[]{firstModuleTitle, targetTitle});
        }
        return NLS.bind((String)Messages.BpReferencingDropPerformer_MultipleModules, (Object[])new Object[]{firstModuleTitle, numberMinusOne, targetTitle});
    }

    private String getMessageForOneModule(CnATreeElement module, CnATreeElement target) {
        return NLS.bind((String)Messages.BpReferencingDropPerformer_OneModule, (Object)module.getTitle(), (Object)target.getTitle());
    }

    @Override
    public boolean validateDrop(Object rawTarget, int operation, TransferData transferData) {
        if (BaseProtectionModelingTransfer.getInstance().isSupportedType(transferData)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Elements dragged from base protection catalog view return false");
            }
            this.isActive = false;
            return this.isActive;
        }
        if (!this.checkRights()) {
            log.debug((Object)"ChechRights() failed, return false");
            this.isActive = false;
        } else if (!this.getTransfer().isSupportedType(transferData)) {
            log.debug((Object)"Unsupported type of TransferData");
        } else {
            this.isActive = rawTarget instanceof ITargetObject;
        }
        return this.isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean checkRights() {
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "baseprotectionmodeling";
    }

    private boolean confirmReferencing(Set<String> existingModules, CnATreeElement targetElement) {
        String mouleList = existingModules.stream().map(title -> " \u2022 " + title).collect(Collectors.joining("\n"));
        String message = NLS.bind((String)Messages.BpReferencingDropPerformer_ReferencingWarning, (Object[])new Object[]{mouleList});
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.BpReferencingDropPerformer_ReferencingWarningTitle, (String)message);
    }

    private void showError(Exception e) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        if (rootCause instanceof BpReferencingException) {
            this.showReferencingError(rootCause.getMessage());
        } else {
            ExceptionUtil.log(e, Messages.BpReferencingDropPerformer_ReferencingAborted);
        }
    }

    private void showReferencingError(String causeMessage) {
        String message = String.join((CharSequence)"", causeMessage, " ", Messages.BpReferencingDropPerformer_ReferencingAborted, causeMessage);
        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.BpReferencingDropPerformer_ReferencingError, (String)message));
    }

    protected VeriniceElementTransfer getTransfer() {
        return BaseProtectionElementTransfer.getInstance();
    }

    private void addModuleReferences(List<CnATreeElement> draggedModules, CnATreeElement dropTarget) throws CommandException {
        ReferencingCommand referencingCommand = new ReferencingCommand((Collection)draggedModules.stream().map(CnATreeElement::getDbId).collect(Collectors.toSet()), dropTarget.getDbId());
        ICommandService commandService = (ICommandService)VeriniceContext.get((String)"commandService");
        commandService.executeCommand((ICommand)referencingCommand);
        CnAElementFactory.getInstance().reloadBpModelFromDatabase();
    }

    private Set<String> getExistingModules(List<CnATreeElement> draggedModules, CnATreeElement dropTarget) throws CommandException {
        CheckReferencingCommand checkReferencingCommand = new CheckReferencingCommand((Collection)draggedModules.stream().map(CnATreeElement::getDbId).collect(Collectors.toSet()), dropTarget.getDbId());
        ICommandService commandService = (ICommandService)VeriniceContext.get((String)"commandService");
        checkReferencingCommand = (CheckReferencingCommand)commandService.executeCommand((ICommand)checkReferencingCommand);
        return checkReferencingCommand.getExistingModules();
    }
}

