/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionModelingTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.VeriniceElementTransfer;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bp.rcp.Messages;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.iso27k.rcp.action.DropPerformer;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.InfoDialogWithShowToggle;
import sernet.verinice.rcp.Preferences;
import sernet.verinice.service.bp.exceptions.BpModelingException;
import sernet.verinice.service.commands.bp.ModelCommand;

public class BbModelingDropPerformer
implements DropPerformer,
RightEnabledUserInteraction {
    private static final Logger log = Logger.getLogger(BbModelingDropPerformer.class);
    private static final List<String> supportedDropTypeIds = new ArrayList<String>(9);
    private ModelCommand modelCommand;
    private ICommandService commandService;
    private boolean isActive = false;
    private CnATreeElement targetElement = null;

    static {
        supportedDropTypeIds.add("bp_itnetwork");
        supportedDropTypeIds.add("bp_application");
        supportedDropTypeIds.add("bp_businessprocess");
        supportedDropTypeIds.add("bp_device");
        supportedDropTypeIds.add("bp_icssystem");
        supportedDropTypeIds.add("bp_itsystem");
        supportedDropTypeIds.add("bp_network");
        supportedDropTypeIds.add("bp_room");
    }

    @Override
    public boolean performDrop(Object data, Object target, Viewer viewer) {
        try {
            List<CnATreeElement> draggedModules = this.getDraggedElements(data);
            if (log.isDebugEnabled()) {
                this.logParameter(draggedModules, this.targetElement);
            }
            if (this.isValid(draggedModules)) {
                this.startModelingByProgressService(draggedModules);
                this.showConfirmationDialog();
            }
            return true;
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
            this.showError(e);
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)"InterruptedException occurred while model module and element", (Throwable)e);
            this.showError(e);
            return false;
        }
    }

    private void startModelingByProgressService(final List<CnATreeElement> draggedModules) throws InvocationTargetException, InterruptedException {
        this.closeEditors();
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(BbModelingDropPerformer.this.getTaskMessage(draggedModules, BbModelingDropPerformer.this.targetElement), -1);
                    BbModelingDropPerformer.this.modelModulesAndElement(draggedModules, BbModelingDropPerformer.this.targetElement);
                    monitor.done();
                }
                catch (CommandException e) {
                    BbModelingDropPerformer.this.showError((Exception)((Object)e));
                }
            }
        });
    }

    private void modelModulesAndElement(List<CnATreeElement> draggedModules, CnATreeElement element) throws CommandException {
        HashSet<String> compendiumUuids = new HashSet<String>(draggedModules.size());
        for (CnATreeElement module : draggedModules) {
            compendiumUuids.add(module.getUuid());
        }
        this.executeModelCommand(compendiumUuids, Collections.singletonList(element.getUuid()));
        CnAElementFactory.getInstance().reloadBpModelFromDatabase();
    }

    private void executeModelCommand(Set<String> compendiumUuids, List<String> targetUuids) throws CommandException {
        this.modelCommand = new ModelCommand(compendiumUuids, targetUuids);
        this.modelCommand.setHandleSafeguards(Preferences.isModelSafeguardsActive());
        this.modelCommand.setHandleDummySafeguards(Preferences.isModelDummySafeguardsActive());
        this.modelCommand = (ModelCommand)this.getCommandService().executeCommand((ICommand)this.modelCommand);
    }

    private boolean isValid(List<CnATreeElement> draggedModules) {
        if (draggedModules == null || draggedModules.isEmpty()) {
            log.warn((Object)"List of dragged modules is empty. Can not model element.");
            return false;
        }
        return true;
    }

    private void showConfirmationDialog() {
        InfoDialogWithShowToggle.openInformation(Messages.BbModelingDropPerformerConfirmationTitle, this.getConfirmationDialogMessage(), Messages.BbModelingDropPerformerConfirmationToggleMessage, "info_bp_modeling_confirmation");
    }

    private String getConfirmationDialogMessage() {
        String message = Messages.BbModelingDropPerformerConfirmationNoProceeding;
        String proceedingLabel = null;
        if (this.modelCommand != null) {
            proceedingLabel = this.modelCommand.getProceedingLabel();
        }
        if (proceedingLabel != null && !proceedingLabel.isEmpty()) {
            message = NLS.bind((String)Messages.BbModelingDropPerformerConfirmation, (Object)proceedingLabel);
        }
        return message;
    }

    private void closeEditors() {
        IEditorReference[] editorReferences;
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference er = iEditorReferenceArray[n2];
            try {
                if (!er.isPinned() && !er.isDirty() && er.getEditorInput() instanceof BSIElementEditorInput) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(er.getEditor(true), true);
                }
            }
            catch (PartInitException e) {
                ExceptionUtil.log(e, Messages.BbModelingDropPerformer_errorClosingEditors);
            }
            ++n2;
        }
    }

    private List<CnATreeElement> getDraggedElements(Object data) {
        List<CnATreeElement> elementList = null;
        if (data instanceof Object[]) {
            elementList = new ArrayList<CnATreeElement>(((Object[])data).length);
            Object[] objectArray = (Object[])data;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof CnATreeElement) {
                    elementList.add((CnATreeElement)o);
                }
                ++n2;
            }
        } else {
            elementList = Collections.emptyList();
        }
        return elementList;
    }

    protected String getTaskMessage(List<CnATreeElement> draggedModules, CnATreeElement targetElement) {
        if (draggedModules == null || draggedModules.isEmpty()) {
            return Messages.BbModelingDropPerformer_NoModules;
        }
        int number = draggedModules.size();
        if (number == 1) {
            return this.getMessageForOneModule(draggedModules.get(0), targetElement);
        }
        return this.getMessageForMoreThanOneModule(draggedModules, targetElement);
    }

    private String getMessageForMoreThanOneModule(List<CnATreeElement> draggedModules, CnATreeElement targetElement) {
        String firstModuleTitle = draggedModules.get(0).getTitle();
        String targetTitle = targetElement.getTitle();
        int numberMinusOne = draggedModules.size() - 1;
        if (numberMinusOne == 1) {
            return NLS.bind((String)Messages.BbModelingDropPerformer_TwoModules, (Object[])new Object[]{targetTitle, firstModuleTitle});
        }
        return NLS.bind((String)Messages.BbModelingDropPerformer_MultipleModules, (Object[])new Object[]{targetTitle, firstModuleTitle, numberMinusOne});
    }

    private String getMessageForOneModule(CnATreeElement module, CnATreeElement target) {
        return NLS.bind((String)Messages.BbModelingDropPerformer_OneModule, (Object)target.getTitle(), (Object)module.getTitle());
    }

    @Override
    public boolean validateDrop(Object rawTarget, int operation, TransferData transferData) {
        if (!this.checkRights()) {
            log.debug((Object)"ChechRights() failed, return false");
            this.isActive = false;
        } else {
            if (!this.getTransfer().isSupportedType(transferData)) {
                log.debug((Object)"Unsupported type of TransferData");
                this.targetElement = null;
            } else {
                this.targetElement = this.getTargetElement(rawTarget);
            }
            this.isActive = this.isTargetElement() && CnAElementHome.getInstance().isWriteAllowed(this.targetElement);
        }
        return this.isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean checkRights() {
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "baseprotectionmodeling";
    }

    private CnATreeElement getTargetElement(Object target) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Target: " + target));
        }
        CnATreeElement element = null;
        if (target instanceof CnATreeElement && !supportedDropTypeIds.contains((element = (CnATreeElement)target).getTypeId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported type of target element: " + element.getTypeId()));
            }
            element = null;
        }
        return element;
    }

    protected boolean isTargetElement() {
        return this.targetElement != null;
    }

    private void showError(Exception e) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        if (rootCause instanceof BpModelingException) {
            this.showModelingError(rootCause.getMessage());
        } else {
            ExceptionUtil.log(e, Messages.BbModelingDropPerformer_ModelingAborted);
        }
    }

    private void showModelingError(String causeMessage) {
        String message = String.join((CharSequence)"", causeMessage, " ", Messages.BbModelingDropPerformer_ModelingAborted, causeMessage);
        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.BbModelingDropPerformerModelingError, (String)message));
    }

    protected VeriniceElementTransfer getTransfer() {
        return BaseProtectionModelingTransfer.getInstance();
    }

    private void logParameter(List<CnATreeElement> draggedElements, CnATreeElement targetElementParam) {
        log.debug((Object)"Module(s):");
        for (CnATreeElement module : draggedElements) {
            log.debug((Object)module);
        }
        log.debug((Object)("is/are modeled with: " + targetElementParam + "..."));
    }

    private ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandService();
        }
        return this.commandService;
    }

    private ICommandService createCommandService() {
        return (ICommandService)VeriniceContext.get((String)"commandService");
    }
}

