/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp;

import java.util.Collection;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.DrillDownAdapter;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.ShowAccessControlEditAction;
import sernet.gs.ui.rcp.main.actions.ShowBulkEditAccountsAction;
import sernet.gs.ui.rcp.main.actions.ShowBulkEditAction;
import sernet.gs.ui.rcp.main.bsi.actions.NaturalizeAction;
import sernet.gs.ui.rcp.main.bsi.dnd.BSIModelViewDragListener;
import sernet.gs.ui.rcp.main.bsi.dnd.BSIModelViewDropListener;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionModelingTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IGSModelElementTransfer;
import sernet.gs.ui.rcp.main.bsi.editors.AttachmentEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.verinice.bp.rcp.BaseProtectionTreeComparator;
import sernet.verinice.bp.rcp.BbModelingDropPerformer;
import sernet.verinice.bp.rcp.BpReferencingDropPerformer;
import sernet.verinice.bp.rcp.GsCatalogModelingDropPerformer;
import sernet.verinice.bp.rcp.Messages;
import sernet.verinice.bp.rcp.consolidator.ConsolidatorAction;
import sernet.verinice.bp.rcp.filter.BaseProtectionFilterAction;
import sernet.verinice.bp.rcp.filter.BaseProtectionFilterBuilder;
import sernet.verinice.bp.rcp.filter.BaseProtectionFilterParameters;
import sernet.verinice.iso27k.rcp.ILinkedWithEditorView;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.LinkWithEditorPartListener;
import sernet.verinice.iso27k.rcp.action.AddGroup;
import sernet.verinice.iso27k.rcp.action.CollapseAction;
import sernet.verinice.iso27k.rcp.action.ExpandAction;
import sernet.verinice.iso27k.rcp.action.MetaDropAdapter;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.bp.IBpModelListener;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.IAttachedToPerspective;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.rcp.tree.BpTreeLabelProvider;
import sernet.verinice.rcp.tree.TreeContentProvider;
import sernet.verinice.rcp.tree.TreeUpdateListener;
import sernet.verinice.service.commands.CnATypeMapper;
import sernet.verinice.service.tree.ElementManager;

public class BaseProtectionView
extends RightsEnabledView
implements IAttachedToPerspective,
ILinkedWithEditorView {
    private static final Logger LOG = Logger.getLogger(BaseProtectionView.class);
    public static final String ID = "sernet.verinice.bp.rcp.BaseProtectionView";
    private static int operations = 3;
    public static final @NonNull BaseProtectionFilterParameters defaultFilterParams = BaseProtectionFilterParameters.builder().build();
    private Object mutex = new Object();
    protected TreeViewer viewer;
    private TreeContentProvider contentProvider;
    private ElementManager elementManager;
    private DrillDownAdapter drillDownAdapter;
    private IModelLoadListener modelLoadListener;
    private IBpModelListener modelUpdateListener;
    private IPartListener2 linkWithEditorPartListener = new LinkWithEditorPartListener(this);
    private IPropertyChangeListener proceedingFilterDisabledToggleListener;
    private Action linkWithEditorAction;
    private ShowBulkEditAction bulkEditAction;
    private ShowBulkEditAccountsAction bulkEditAccountsAction;
    private ExpandAction expandAction;
    private Action expandAllAction;
    private CollapseAction collapseAction;
    private ConsolidatorAction consolidatorAction;
    private Action collapseAllAction;
    private BaseProtectionFilterAction filterAction;
    private ShowAccessControlEditAction accessControlEditAction;
    private NaturalizeAction naturalizeAction;
    private MetaDropAdapter metaDropAdapter;
    private boolean linkingActive = false;

    public BaseProtectionView() {
        this.elementManager = new ElementManager();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        try {
            this.initView(parent);
            this.startInitDataJob();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating organization view", (Throwable)e);
            ExceptionUtil.log(e, Messages.BaseProtectionView_ErrorCreating);
        }
    }

    protected void initView(Composite parent) {
        IWorkbench workbench = this.getSite().getWorkbenchWindow().getWorkbench();
        if (CnAElementFactory.isBpModelLoaded()) {
            CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
        }
        this.contentProvider = new TreeContentProvider(this.elementManager);
        this.viewer = new TreeViewer(parent, 2818);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new BpTreeLabelProvider(), (ILabelDecorator)workbench.getDecoratorManager()));
        this.viewer.setComparator((ViewerComparator)new BaseProtectionTreeComparator());
        Collection<ViewerFilter> filters = BaseProtectionFilterBuilder.makeFilters(defaultFilterParams);
        this.viewer.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
        this.toggleLinking(Activator.getDefault().getPreferenceStore().getBoolean("link_to_editor"));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu();
        this.makeActions();
        this.addActions();
        this.fillToolBar();
        this.hookDndListeners();
        this.getSite().getPage().addPartListener(this.linkWithEditorPartListener);
        this.viewer.refresh(true);
        this.proceedingFilterDisabledToggleListener = event -> {
            if ("filter_information_networks_by_proceeding".equals(event.getProperty())) {
                this.viewer.refresh();
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.proceedingFilterDisabledToggleListener);
    }

    protected void startInitDataJob() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MotITBPview: startInitDataJob");
        }
        WorkspaceJob initDataJob = new WorkspaceJob(Messages.BaseProtectionView_Loading_1){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask(Messages.BaseProtectionView_Loading_2, -1);
                        BaseProtectionView.this.initData();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while loading data.", (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", "Error while loading data", (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleInitJob(initDataJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initData() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"BaseProtectionView: initData");
        }
        Object object = this.mutex;
        synchronized (object) {
            if (CnAElementFactory.isBpModelLoaded()) {
                if (this.modelUpdateListener == null) {
                    if (LOG.isDebugEnabled()) {
                        Logger.getLogger(this.getClass()).debug((Object)"Creating modelUpdateListener for BaseProtectionView.");
                    }
                    this.modelUpdateListener = new TreeUpdateListener(this.viewer, this.elementManager);
                    CnAElementFactory.getInstance().getBpModel().addModITBOModelListener(this.modelUpdateListener);
                    Display.getDefault().syncExec(() -> {
                        this.setInput(CnAElementFactory.getInstance().getBpModel());
                        this.viewer.refresh();
                    });
                }
            } else if (this.modelLoadListener == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"ISMView No model loaded, adding model load listener.");
                }
                this.modelLoadListener = new DefaultModelLoadListener(){

                    @Override
                    public void loaded(BpModel model) {
                        BaseProtectionView.this.startInitDataJob();
                    }
                };
                CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener);
            }
        }
    }

    public void setInput(BpModel model) {
        this.viewer.setInput((Object)model);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillContextMenu);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDndListeners() {
        Transfer[] dragTypes = new Transfer[]{BaseProtectionElementTransfer.getInstance()};
        Transfer[] dropTypes = new Transfer[]{IGSModelElementTransfer.getInstance(), BaseProtectionElementTransfer.getInstance(), BaseProtectionModelingTransfer.getInstance()};
        this.viewer.addDragSupport(operations, dragTypes, (DragSourceListener)new BSIModelViewDragListener(this.viewer));
        this.viewer.addDropSupport(operations, dropTypes, (DropTargetListener)this.metaDropAdapter);
    }

    protected void fillContextMenu(IMenuManager manager) {
        Object sel;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (sel = ((IStructuredSelection)selection).getFirstElement()) instanceof ItNetwork) {
            ItNetwork element = (ItNetwork)sel;
            if (CnAElementHome.getInstance().isNewChildAllowed((CnATreeElement)element)) {
                MenuManager submenuNew = new MenuManager(Messages.NewObjectMenu, "content/new");
                for (String groupTypeId : CnATypeMapper.BP_ELEMENT_TYPES) {
                    String elementTypeId = CnATypeMapper.getElementTypeIdFromGroupTypeId((String)groupTypeId);
                    submenuNew.add((IAction)new AddGroup((CnATreeElement)element, groupTypeId, elementTypeId));
                }
                manager.add((IContributionItem)submenuNew);
            }
        }
        manager.add((IContributionItem)new GroupMarker("content"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("special"));
        manager.add((IAction)this.bulkEditAction);
        manager.add((IAction)this.bulkEditAccountsAction);
        manager.add((IAction)this.accessControlEditAction);
        manager.add((IAction)this.naturalizeAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAction);
        manager.add((IAction)this.collapseAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.consolidatorAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.makeExpandAndCollapseActions();
        this.bulkEditAction = new ShowBulkEditAction(this.getViewSite(), Messages.BaseProtectionView_BulkEdit);
        this.bulkEditAccountsAction = new ShowBulkEditAccountsAction(this.getViewSite(), sernet.gs.ui.rcp.main.Messages.ContextMenuAccountBulkEditor);
        this.metaDropAdapter = new MetaDropAdapter((Viewer)this.viewer);
        BSIModelViewDropListener bsiDropAdapter = new BSIModelViewDropListener(this.viewer);
        BbModelingDropPerformer modelingDropPerformer = new BbModelingDropPerformer();
        GsCatalogModelingDropPerformer gsCatalogModelingDropPerformer = new GsCatalogModelingDropPerformer();
        this.metaDropAdapter.addAdapter(modelingDropPerformer);
        this.metaDropAdapter.addAdapter(new BpReferencingDropPerformer());
        this.metaDropAdapter.addAdapter(bsiDropAdapter);
        this.metaDropAdapter.addAdapter(gsCatalogModelingDropPerformer);
        this.linkWithEditorAction = new Action(Messages.BaseProtectionView_LinkWithEditor, 2){

            public void run() {
                BaseProtectionView.this.toggleLinking(this.isChecked());
            }
        };
        this.linkWithEditorAction.setChecked(this.isLinkingActive());
        this.linkWithEditorAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("linked.gif"));
        this.naturalizeAction = new NaturalizeAction(this.getViewSite());
        this.accessControlEditAction = new ShowAccessControlEditAction(this.getViewSite(), Messages.BaseProtectionView_AccessControl);
        this.makeFilterAction();
        this.consolidatorAction = new ConsolidatorAction(this.getViewSite());
    }

    private void makeFilterAction() {
        this.filterAction = new BaseProtectionFilterAction((StructuredViewer)this.viewer, defaultFilterParams);
    }

    protected void makeExpandAndCollapseActions() {
        this.expandAction = new ExpandAction(this.viewer, this.contentProvider);
        this.expandAction.setText(Messages.BaseProtectionView_ExpandChildren);
        this.expandAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("expandall.gif"));
        this.collapseAction = new CollapseAction(this.viewer);
        this.collapseAction.setText(Messages.BaseProtectionView_CollapseChildren);
        this.collapseAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("collapseall.gif"));
        this.expandAllAction = new Action(){

            public void run() {
                BaseProtectionView.this.expandAll();
            }
        };
        this.expandAllAction.setText(Messages.BaseProtectionView_ExpandAll);
        this.expandAllAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("expandall.gif"));
        this.collapseAllAction = new Action(){

            public void run() {
                BaseProtectionView.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setText(Messages.BaseProtectionView_CollapseAll);
        this.collapseAllAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("collapseall.gif"));
    }

    protected void expandAll() {
        this.viewer.expandAll();
    }

    protected void toggleLinking(boolean checked) {
        this.linkingActive = checked;
        if (checked) {
            Optional.ofNullable(this.getSite().getPage().getActiveEditor()).ifPresent(this::editorActivated);
        }
    }

    protected boolean isLinkingActive() {
        return this.linkingActive;
    }

    private void addActions() {
        this.viewer.addDoubleClickListener(event -> {
            ISelection selection = event.getViewer().getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                Object sel = ((IStructuredSelection)selection).getFirstElement();
                EditorFactory.getInstance().updateAndOpenObject(sel);
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.expandAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.collapseAction);
    }

    protected void fillToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IAction)this.filterAction);
        manager.add((IAction)this.linkWithEditorAction);
    }

    @Override
    public void editorActivated(IEditorPart editor) {
        if (!this.isLinkingActive() || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        CnATreeElement element = BSIElementEditorInput.extractElement(editor);
        if (element == null && editor.getEditorInput() instanceof AttachmentEditorInput) {
            element = this.getElementFromAttachment(editor);
        }
        if (element instanceof IBpElement) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Element in editor: " + element.getUuid()));
                LOG.debug((Object)"Expanding tree now to show element...");
            }
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
            LOG.debug((Object)"Tree is expanded.");
        }
    }

    private CnATreeElement getElementFromAttachment(IEditorPart editor) {
        return AttachmentEditorInput.extractCnaTreeElement(editor);
    }

    @Override
    public String getPerspectiveId() {
        return "sernet.verinice.rcp.bp.BaseProtectionPerspective";
    }

    public void dispose() {
        this.elementManager.clearCache();
        CnAElementFactory.getInstance().ifBpModelLoaded(model -> model.removeBpModelListener(this.modelUpdateListener));
        CnAElementFactory.getInstance().removeLoadListener(this.modelLoadListener);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.proceedingFilterDisabledToggleListener);
        super.dispose();
    }

    @Override
    public String getRightID() {
        return "baseprotectionview";
    }

    @Override
    public String getViewId() {
        return ID;
    }
}

