/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp;

import java.text.Collator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.Viewer;
import sernet.gs.service.NumericStringCollator;
import sernet.gs.ui.rcp.main.bsi.views.ImportGroupFirstComparator;
import sernet.hui.common.connect.IIdentifiableElement;
import sernet.hui.common.connect.ITitledElement;
import sernet.verinice.model.bp.SecurityLevel;
import sernet.verinice.model.bp.elements.BpRequirement;
import sernet.verinice.model.bp.elements.Safeguard;
import sernet.verinice.model.bp.groups.BpRequirementGroup;
import sernet.verinice.model.bp.groups.SafeguardGroup;
import sernet.verinice.model.common.CnATreeElement;

public class BaseProtectionTreeComparator
extends ImportGroupFirstComparator {
    private static Map<String, Integer> typeSortCategoryMap = new HashMap<String, Integer>();
    private static final List<String> SORT_ORDER_REQUIREMENT_AND_SAFEGUARD_GROUPS = Arrays.asList("ISMS", "ORP", "CON", "OPS", "DER", "APP", "SYS", "IND", "NET", "INF");
    static final Collator numericStringCollator;

    static {
        typeSortCategoryMap.put("bp_businessprocess_group", 10);
        typeSortCategoryMap.put("bp_businessprocess", 10);
        typeSortCategoryMap.put("bp_application_group", 20);
        typeSortCategoryMap.put("bp_application", 20);
        typeSortCategoryMap.put("bp_itsystem_group", 30);
        typeSortCategoryMap.put("bp_itsystem", 30);
        typeSortCategoryMap.put("bp_icssystem_group", 40);
        typeSortCategoryMap.put("bp_icssystem", 40);
        typeSortCategoryMap.put("bp_device_group", 50);
        typeSortCategoryMap.put("bp_device", 50);
        typeSortCategoryMap.put("bp_network_group", 60);
        typeSortCategoryMap.put("bp_network", 60);
        typeSortCategoryMap.put("bp_room_group", 70);
        typeSortCategoryMap.put("bp_room", 70);
        typeSortCategoryMap.put("bp_person_group", 80);
        typeSortCategoryMap.put("bp_person", 80);
        typeSortCategoryMap.put("bp_requirement_group", 90);
        typeSortCategoryMap.put("bp_requirement", 90);
        typeSortCategoryMap.put("bp_threat_group", 100);
        typeSortCategoryMap.put("bp_threat", 100);
        typeSortCategoryMap.put("bp_safeguard_group", 110);
        typeSortCategoryMap.put("bp_safeguard", 110);
        typeSortCategoryMap.put("bp_document_group", 120);
        typeSortCategoryMap.put("bp_document", 120);
        typeSortCategoryMap.put("bp_incident_group", 130);
        typeSortCategoryMap.put("bp_incident", 130);
        typeSortCategoryMap.put("bp_record_group", 140);
        typeSortCategoryMap.put("bp_record", 140);
        numericStringCollator = new NumericStringCollator();
    }

    public BaseProtectionTreeComparator() {
        super(numericStringCollator);
    }

    public int category(Object element) {
        Integer mapValue;
        int category = 0;
        if (element instanceof CnATreeElement && (mapValue = typeSortCategoryMap.get(((CnATreeElement)element).getTypeId())) != null) {
            category = mapValue;
        }
        return category;
    }

    @Override
    public int compare(Viewer viewer, Object o1, Object o2) {
        int result = 0;
        if (o1 instanceof SafeguardGroup && o2 instanceof SafeguardGroup) {
            result = BaseProtectionTreeComparator.compareModulesOrImplementationHints((SafeguardGroup)o1, (SafeguardGroup)o2);
        } else if (o1 instanceof BpRequirementGroup && o2 instanceof BpRequirementGroup) {
            result = BaseProtectionTreeComparator.compareModulesOrImplementationHints((BpRequirementGroup)o1, (BpRequirementGroup)o2);
        } else if (o1 instanceof Safeguard && o2 instanceof Safeguard) {
            SecurityLevel sl1 = ((Safeguard)o1).getSecurityLevel();
            SecurityLevel sl2 = ((Safeguard)o2).getSecurityLevel();
            result = SecurityLevel.compare((SecurityLevel)sl1, (SecurityLevel)sl2);
        } else if (o1 instanceof BpRequirement && o2 instanceof BpRequirement) {
            SecurityLevel sl1 = ((BpRequirement)o1).getSecurityLevel();
            SecurityLevel sl2 = ((BpRequirement)o2).getSecurityLevel();
            result = SecurityLevel.compare((SecurityLevel)sl1, (SecurityLevel)sl2);
        }
        if (result == 0) {
            result = super.compare(viewer, o1, o2);
        }
        return result;
    }

    private static <T extends ITitledElement & IIdentifiableElement> int compareModulesOrImplementationHints(@NonNull T o1, @NonNull T o2) {
        int o1Value = -1;
        int o2Value = -1;
        String o1Identifier = ((IIdentifiableElement)o1).getIdentifier();
        String o2Identifier = ((IIdentifiableElement)o2).getIdentifier();
        String o1Title = o1.getTitle();
        String o2Title = o2.getTitle();
        if (StringUtils.isNotEmpty((String)o1Identifier) && StringUtils.isNotEmpty((String)o2Identifier)) {
            o1Value = BaseProtectionTreeComparator.getValueForSorting(o1Identifier);
            o2Value = BaseProtectionTreeComparator.getValueForSorting(o2Identifier);
        } else if (StringUtils.isNotEmpty((String)o1Title) && StringUtils.isNotEmpty((String)o2Title)) {
            o1Value = BaseProtectionTreeComparator.getValueForSorting(o1Title);
            o2Value = BaseProtectionTreeComparator.getValueForSorting(o2Title);
        }
        if (o1Value != -1 && o2Value == -1) {
            return -1;
        }
        if (o1Value == -1 && o2Value != -1) {
            return 1;
        }
        return Integer.compare(o1Value, o2Value);
    }

    private static int getValueForSorting(String name) {
        int indexOfPeriod = name.indexOf(46);
        if (indexOfPeriod != -1) {
            String section = name.substring(0, indexOfPeriod);
            return SORT_ORDER_REQUIREMENT_AND_SAFEGUARD_GROUPS.indexOf(section);
        }
        return SORT_ORDER_REQUIREMENT_AND_SAFEGUARD_GROUPS.indexOf(name);
    }
}

