/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.splashHandlers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.splash.AbstractSplashHandler;

public class ExtensibleSplashHandler
extends AbstractSplashHandler {
    private ArrayList fImageList = new ArrayList();
    private ArrayList fTooltipList = new ArrayList();
    private static final String F_SPLASH_EXTENSION_ID = "sernet.gs.ui.rcp.main.splashExtension";
    private static final String F_ELEMENT_ICON = "icon";
    private static final String F_ELEMENT_TOOLTIP = "tooltip";
    private static final String F_DEFAULT_TOOLTIP = "Image";
    private static final int F_IMAGE_WIDTH = 50;
    private static final int F_IMAGE_HEIGHT = 50;
    private static final int F_SPLASH_SCREEN_BEVEL = 5;
    private Composite fIconPanel = null;

    public void init(Shell splash) {
        super.init(splash);
        this.configureUISplash();
        this.loadSplashExtensions();
        if (!this.hasSplashExtensions()) {
            return;
        }
        this.createUI();
        this.configureUICompositeIconPanelBounds();
        this.doEventLoop();
    }

    private boolean hasSplashExtensions() {
        return !this.fImageList.isEmpty();
    }

    private void createUI() {
        this.createUICompositeIconPanel();
        this.createUIImages();
    }

    private void createUIImages() {
        Iterator imageIterator = this.fImageList.iterator();
        Iterator tooltipIterator = this.fTooltipList.iterator();
        int i = 1;
        int columnCount = ((GridLayout)this.fIconPanel.getLayout()).numColumns;
        while (imageIterator.hasNext() && i <= columnCount) {
            Image image = (Image)imageIterator.next();
            String tooltip = (String)tooltipIterator.next();
            this.createUILabel(image, tooltip);
            ++i;
        }
    }

    private void createUILabel(Image image, String tooltip) {
        Label label = new Label(this.fIconPanel, 0);
        label.setImage(image);
        label.setToolTipText(tooltip);
    }

    private void createUICompositeIconPanel() {
        Shell splash = this.getSplash();
        this.fIconPanel = new Composite((Composite)splash, 0);
        int maxColumnCount = this.getUsableSplashScreenWidth() / 50;
        int actualColumnCount = Math.min(this.fImageList.size(), maxColumnCount);
        GridLayout layout = new GridLayout(actualColumnCount, true);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fIconPanel.setLayout((Layout)layout);
    }

    private void configureUICompositeIconPanelBounds() {
        Point panelSize = this.fIconPanel.computeSize(-1, -1, true);
        int x_coord = this.getSplash().getSize().x - 5 - panelSize.x;
        int y_coord = this.getSplash().getSize().y - 5 - panelSize.y;
        int x_width = panelSize.x;
        int y_width = panelSize.y;
        this.fIconPanel.setBounds(x_coord, y_coord, x_width, y_width);
    }

    private int getUsableSplashScreenWidth() {
        return this.getSplash().getSize().x - 10;
    }

    private void loadSplashExtensions() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(F_SPLASH_EXTENSION_ID).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.processSplashExtension(extensions[i]);
            ++i;
        }
    }

    private void processSplashExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int j = 0;
        while (j < elements.length) {
            this.processSplashElements(elements[j]);
            ++j;
        }
    }

    private void processSplashElements(IConfigurationElement configurationElement) {
        this.processSplashElementIcon(configurationElement);
        this.processSplashElementTooltip(configurationElement);
    }

    private void processSplashElementTooltip(IConfigurationElement configurationElement) {
        String tooltip = configurationElement.getAttribute(F_ELEMENT_TOOLTIP);
        if (tooltip == null || tooltip.length() == 0) {
            this.fTooltipList.add(F_DEFAULT_TOOLTIP);
        } else {
            this.fTooltipList.add(tooltip);
        }
    }

    private void processSplashElementIcon(IConfigurationElement configurationElement) {
        String iconImageFilePath = configurationElement.getAttribute(F_ELEMENT_ICON);
        if (iconImageFilePath == null || iconImageFilePath.length() == 0) {
            return;
        }
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)configurationElement.getNamespaceIdentifier(), (String)iconImageFilePath);
        if (descriptor == null) {
            return;
        }
        Image image = descriptor.createImage();
        if (image == null) {
            return;
        }
        if (image.getBounds().width != 50 || image.getBounds().height != 50) {
            image.dispose();
            return;
        }
        this.fImageList.add(image);
    }

    private void configureUISplash() {
        GridLayout layout = new GridLayout(1, true);
        this.getSplash().setLayout((Layout)layout);
        this.getSplash().setBackgroundMode(1);
    }

    private void doEventLoop() {
        Shell splash = this.getSplash();
        if (!splash.getDisplay().readAndDispatch()) {
            splash.getDisplay().sleep();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fImageList == null || this.fImageList.isEmpty()) {
            return;
        }
        for (Image image : this.fImageList) {
            image.dispose();
        }
    }
}

