/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.service;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.Preferences;
import sernet.verinice.service.commands.task.GetChangesSince;

public class TransactionLogWatcher {
    private final Logger log = Logger.getLogger(TransactionLogWatcher.class);
    private Date lastChecked = null;
    private ICommandService commandService;

    public void checkLog() {
        Activator.inheritVeriniceContextState();
        if (!CnAElementFactory.isModelLoaded() && !CnAElementFactory.isIsoModelLoaded()) {
            return;
        }
        if (Preferences.isStandalone()) {
            return;
        }
        try {
            GetChangesSince command = new GetChangesSince(this.lastChecked, ChangeLogEntry.STATION_ID);
            command = (GetChangesSince)this.commandService.executeCommand((ICommand)command);
            this.lastChecked = command.getLastChecked();
            List entries = command.getEntries();
            if (entries == null || entries.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"No changes");
                }
            } else {
                Collections.sort(entries);
                for (ChangeLogEntry changeLogEntry : entries) {
                    Integer elementId = changeLogEntry.getElementId();
                    CnATreeElement changedElement = (CnATreeElement)command.getChangedElements().get(elementId);
                    this.process(changeLogEntry, changedElement);
                }
            }
        }
        catch (CommandException e) {
            this.log.error((Object)"Fehler bei Abfrage des Transaktionslogfiles.", (Throwable)e);
        }
    }

    private void process(ChangeLogEntry changeLogEntry, CnATreeElement changedElement) {
        int changetype = changeLogEntry.getChange();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Processing change event type " + changeLogEntry.getChangeDescription() + " from user " + changeLogEntry.getUsername() + " for element " + changeLogEntry.getElementClass() + " / " + changeLogEntry.getElementId()));
        }
        switch (changetype) {
            case 0: {
                CnAElementFactory.getModel(changedElement).databaseChildChanged(changedElement);
                break;
            }
            case 1: {
                if (changedElement == null) break;
                CnAElementFactory.getModel(changedElement).databaseChildAdded(changedElement);
                CnAElementFactory.getModel(changedElement).childAdded(changedElement.getParent(), changedElement);
                break;
            }
            case 2: {
                if (changedElement == null) {
                    CnAElementFactory.databaseChildRemoved(changeLogEntry);
                    break;
                }
                CnAElementFactory.getModel(changedElement).databaseChildRemoved(changedElement);
                break;
            }
            case 3: {
                CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
                break;
            }
            default: {
                Logger.getLogger(this.getClass()).debug((Object)("Unrecognized change type received from server. Ignored, type ID was: " + changetype));
            }
        }
    }

    public void setCommandService(ICommandService commandService) {
        this.commandService = commandService;
    }

    public ICommandService getCommandService() {
        return this.commandService;
    }
}

