/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.service;

import java.util.List;
import org.apache.log4j.Logger;
import sernet.gs.model.Baustein;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.dnd.Messages;
import sernet.gs.ui.rcp.main.common.model.BuildInput;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.verinice.iso27k.service.IProgressObserver;
import sernet.verinice.model.common.CnATreeElement;

public class CopyBausteineService {
    private final Logger log = Logger.getLogger(CopyBausteineService.class);
    private IProgressObserver progressObserver;
    private List<CnATreeElement> selectedTargetList;
    private int numberOfElements;
    private int numberProcessed;
    private List<Baustein> elements;

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public CopyBausteineService(IProgressObserver progressObserver, List<CnATreeElement> targets, List<Baustein> elementList) {
        this.progressObserver = progressObserver;
        this.selectedTargetList = targets;
        this.elements = elementList;
    }

    public void run() {
        try {
            try {
                Activator.inheritVeriniceContextState();
                this.numberOfElements = this.selectedTargetList.size() * this.elements.size();
                StringBuilder sb = new StringBuilder();
                sb.append("Copying ").append(this.numberOfElements).append(" elements.");
                this.progressObserver.beginTask(sb.toString(), this.numberOfElements);
                this.numberProcessed = 0;
                CnATreeElement saveNew = null;
                for (CnATreeElement target : this.selectedTargetList) {
                    saveNew = this.pasteBausteine(this.elements, target);
                }
                CnAElementFactory.getLoadedModel().databaseChildAdded(saveNew);
            }
            catch (Exception e) {
                this.log.error((Object)"Error while copying element", (Throwable)e);
                throw new RuntimeException("Error while copying element", e);
            }
        }
        finally {
            this.progressObserver.done();
        }
    }

    private CnATreeElement pasteBausteine(List<Baustein> elements, CnATreeElement target) {
        CnATreeElement saveNew = null;
        for (Baustein baustein : elements) {
            if (target.canContain((Object)baustein)) {
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Copy ").append(baustein.getTitel());
                    sb.append(" (").append(this.numberProcessed).append("/").append(this.numberOfElements).append(")");
                    this.progressObserver.setTaskName(sb.toString());
                    saveNew = CnAElementFactory.getInstance().saveNew(target, "bstumsetzung", new BuildInput<Baustein>(baustein), false, false);
                }
                catch (Exception e) {
                    this.log.error((Object)Messages.getString("PasteBsiModelViewAction.5"), (Throwable)e);
                }
            }
            this.progressObserver.processed(1);
            ++this.numberProcessed;
        }
        return saveNew;
    }
}

