/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.reports;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import sernet.gs.ui.rcp.main.reports.IReportSupplier;
import sernet.gs.ui.rcp.main.reports.LocalReportTemplateService;
import sernet.gs.ui.rcp.main.reports.ReportDepositCache;
import sernet.verinice.interfaces.ReportTemplateServiceException;
import sernet.verinice.interfaces.report.IReportService;
import sernet.verinice.model.report.ReportTemplateMetaData;

public class ReportSupplierImpl
implements IReportSupplier {
    private final String ERROR_MESSAGE = "reading report templates failed %s";
    private final Logger LOG = Logger.getLogger(ReportSupplierImpl.class);

    @Override
    public List<ReportTemplateMetaData> getReportTemplates(Locale locale) {
        try {
            return Arrays.asList(this.getReportMetaData(locale));
        }
        catch (ReportTemplateServiceException e) {
            this.LOG.error((Object)String.format("reading report templates failed %s", e.getLocalizedMessage()), (Throwable)e);
            return new ArrayList<ReportTemplateMetaData>(0);
        }
    }

    private ReportTemplateMetaData[] getReportMetaData(Locale locale) throws ReportTemplateServiceException {
        LocalReportTemplateService localReportTemplateUtil = new LocalReportTemplateService();
        ReportDepositCache serverReportTemplateUtil = new ReportDepositCache();
        HashSet metadata = new HashSet();
        int size = 0;
        metadata.addAll(localReportTemplateUtil.getReportTemplates(locale));
        size = metadata.size();
        metadata.addAll(serverReportTemplateUtil.getReportTemplates(locale));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)(String.valueOf(size) + " Report templates loaded from workspacefolder:\t" + IReportService.VERINICE_REPORTS_LOCAL));
            this.LOG.debug((Object)(String.valueOf(metadata.size() - size) + " Report templates loaded from workspacefolder:\t" + "report_templates_remote"));
        }
        return metadata.toArray(new ReportTemplateMetaData[metadata.size()]);
    }
}

