/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.preferences.GeneralSettingsPage;
import sernet.gs.ui.rcp.main.preferences.Messages;

public class SearchPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String SEMICOLON = ";";
    public static final String COMMA = ",";
    private static final String[][] SEPERATOR_COMBO_VALUES = new String[][]{{Messages.getString("SearchPreferencePage.2"), ";"}, {Messages.getString("SearchPreferencePage.5"), ","}};
    private RadioGroupFieldEditor sortColumns;
    private ComboFieldEditor seperatorFieldEditor;
    private ComboFieldEditor encodingFieldEditor;
    private BooleanFieldEditor disableField;
    private BooleanFieldEditor startField;
    private Group commonSettings;
    private boolean standalone;

    public void init(IWorkbench arg0) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("SearchPreferencePage.0"));
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 6);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        this.standalone = this.getPreferenceStore().getString("gs_cna_operationmode").equals("gs_cna_operationmode_standalone");
        if (this.standalone) {
            this.commonSettings = new Group(top, 2052);
            this.commonSettings.setLayout((Layout)new FillLayout());
            this.commonSettings.setLayoutData((Object)new GridData(4, 4, true, false));
            this.commonSettings.setText(Messages.getString("SearchPreferencePage.13"));
            this.disableField = new BooleanFieldEditor("search_disable", Messages.getString("SearchPreferencePage.16"), (Composite)this.commonSettings);
            this.disableField.setPreferenceStore(this.getPreferenceStore());
            this.disableField.load();
            this.disableField.setPropertyChangeListener((IPropertyChangeListener)new DisableFieldListener(this.commonSettings));
            this.startField = new BooleanFieldEditor("search_index_on_startup", Messages.getString("SearchPreferencePage.14"), (Composite)this.commonSettings);
            this.startField.setPreferenceStore(this.getPreferenceStore());
            this.startField.load();
            this.startField.setEnabled(this.disableIndexOnStartUp(), (Composite)this.commonSettings);
        }
        Group sortingComposite = new Group(top, 2052);
        sortingComposite.setLayout((Layout)new GridLayout());
        sortingComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        sortingComposite.setText(Messages.getString("SearchPreferencePage.15"));
        String[][] labelAndValues = new String[2][2];
        labelAndValues[0] = new String[]{Messages.getString("SearchPreferencePage.10"), "snca"};
        labelAndValues[1] = new String[]{Messages.getString("SearchPreferencePage.11"), "lexicography"};
        this.sortColumns = new RadioGroupFieldEditor("sort_column_prefs", Messages.getString("SearchPreferencePage.1"), 2, labelAndValues, (Composite)sortingComposite);
        this.sortColumns.setPreferenceStore(this.getPreferenceStore());
        this.sortColumns.load();
        Group csvExportSettingsGrid = new Group(top, 2052);
        csvExportSettingsGrid.setLayout((Layout)new GridLayout());
        csvExportSettingsGrid.setLayoutData((Object)new GridData(4, 4, true, false));
        csvExportSettingsGrid.setText(Messages.getString("SearchPreferencePage.12"));
        this.seperatorFieldEditor = new ComboFieldEditor("search_csv_export_seperator", Messages.getString("SearchPreferencePage.8"), SEPERATOR_COMBO_VALUES, (Composite)csvExportSettingsGrid);
        this.seperatorFieldEditor.setPreferenceStore(this.getPreferenceStore());
        this.seperatorFieldEditor.load();
        this.seperatorFieldEditor.fillIntoGrid((Composite)csvExportSettingsGrid, 2);
        this.encodingFieldEditor = new ComboFieldEditor("search_csv_export_encoding", Messages.getString("SearchPreferencePage.9"), GeneralSettingsPage.ENCODING_COMBO_VALUES, (Composite)csvExportSettingsGrid);
        this.encodingFieldEditor.setPreferenceStore(this.getPreferenceStore());
        this.encodingFieldEditor.load();
        this.encodingFieldEditor.fillIntoGrid((Composite)csvExportSettingsGrid, 2);
        return top;
    }

    private boolean disableIndexOnStartUp() {
        return !this.disableField.getBooleanValue();
    }

    protected void performDefaults() {
        this.sortColumns.loadDefault();
        this.seperatorFieldEditor.loadDefault();
        this.encodingFieldEditor.loadDefault();
        if (this.standalone) {
            this.startField.loadDefault();
            this.startField.setEnabled(true, (Composite)this.commonSettings);
            this.disableField.loadDefault();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        this.sortColumns.store();
        this.seperatorFieldEditor.store();
        this.encodingFieldEditor.store();
        if (this.standalone) {
            this.startField.store();
            this.disableField.store();
        }
        return super.performOk();
    }

    protected void createFieldEditors() {
    }

    private final class DisableFieldListener
    implements IPropertyChangeListener {
        private final Group commonSettings;

        private DisableFieldListener(Group commonSettings) {
            this.commonSettings = commonSettings;
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            if (!SearchPreferencePage.this.disableField.getBooleanValue()) {
                SearchPreferencePage.this.startField.setEnabled(true, (Composite)this.commonSettings);
            } else {
                SearchPreferencePage.this.startField.setEnabled(false, (Composite)this.commonSettings);
            }
        }
    }
}

