/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.preferences;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.preferences.Messages;
import sernet.verinice.interfaces.IInternalServer;
import sernet.verinice.rcp.Preferences;

public class ItbpPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger LOG = Logger.getLogger(ItbpPreferencePage.class);
    private FileFieldEditor catalogZipfilePath;
    private BooleanFieldEditor modelSafeguards;
    private BooleanFieldEditor modelDummySafeguards;
    private Composite fieldEditorParent;

    public ItbpPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        boolean isStandalone = Preferences.isStandalone();
        if (!isStandalone) {
            GridLayoutFactory.fillDefaults().applyTo(parent);
            Label servermode = new Label(parent, 0);
            servermode.setText(Messages.getString("ItbpPreferencePage.22"));
            this.fieldEditorParent = new Composite(parent, 0);
        } else {
            Link generalTextLink = new Link(parent, 0);
            this.fieldEditorParent = new Composite(parent, 0);
            GridLayoutFactory.swtDefaults().numColumns(1).margins(5, 0).generateLayout(this.fieldEditorParent);
            this.fieldEditorParent.setFont(parent.getFont());
            generalTextLink.setText(Messages.getString("ItbpPreferencePage.0"));
            generalTextLink.addListener(13, (Listener)new KatalogPreferenceLinkListener());
            this.createFieldEditors();
        }
        this.createModelingGroup();
        this.initialize();
        this.checkState();
        return this.fieldEditorParent;
    }

    protected Composite getFieldEditorParent() {
        return this.fieldEditorParent;
    }

    public void createFieldEditors() {
        Group catalogComposite = this.createGroup(Messages.getString("ItbpPreferencePage.24"));
        Link calatogLink = new Link((Composite)catalogComposite, 0);
        calatogLink.setText(Messages.getString("ItbpPreferencePage.11"));
        calatogLink.addListener(13, (Listener)new KatalogPreferenceLinkListener());
        Composite catalogEditorParent = new Composite((Composite)catalogComposite, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)catalogEditorParent);
        this.catalogZipfilePath = new FileFieldEditor("cna_bsizipfile", Messages.getString("ItbpPreferencePage.8"), catalogEditorParent);
        this.catalogZipfilePath.setFileExtensions(new String[]{"*.zip;*.ZIP", "*.*"});
        this.addField((FieldEditor)this.catalogZipfilePath);
    }

    private void createModelingGroup() {
        this.createModelSafeguardsField(this.getFieldEditorParent());
        this.createModelDummySafeguardsField(this.getFieldEditorParent());
    }

    private void createModelSafeguardsField(Composite parent) {
        this.modelSafeguards = new BooleanFieldEditor("bp_model_safeguards", Messages.getString("ItbpPreferencePage.model_safeguards"), parent);
        this.addField((FieldEditor)this.modelSafeguards);
    }

    private void createModelDummySafeguardsField(Composite parent) {
        this.modelDummySafeguards = new BooleanFieldEditor("bp_model_dummy_safeguards", Messages.getString("ItbpPreferencePage.dummy-safeguards"), parent);
        this.addField((FieldEditor)this.modelDummySafeguards);
    }

    private Group createGroup(String title) {
        Group catalogComposite = new Group(this.getFieldEditorParent(), 4);
        catalogComposite.setText(title);
        GridLayoutFactory.fillDefaults().margins(5, 10).numColumns(1).generateLayout((Composite)catalogComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)catalogComposite);
        return catalogComposite;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            this.checkState();
            if (event.getSource() == this.catalogZipfilePath && Preferences.isBpCatalogLoadedFromZipFile()) {
                try {
                    IInternalServer internalServer = Activator.getDefault().getInternalServer();
                    internalServer.setGSCatalogURL(new File(this.catalogZipfilePath.getStringValue()).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOG.warn((Object)"ITBP catalog zip file path is an invalid URL.");
                }
            }
            if (event.getSource() == this.modelSafeguards) {
                this.modelDummySafeguards.setEnabled(this.modelSafeguards.getBooleanValue(), this.getFieldEditorParent());
            }
        }
    }

    protected void checkState() {
        super.checkState();
        if (!this.isValid()) {
            return;
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean isValid() {
        return true;
    }

    private class KatalogPreferenceLinkListener
    implements Listener {
        private KatalogPreferenceLinkListener() {
        }

        public void handleEvent(Event event) {
            Program.launch((String)event.text);
        }
    }
}

