/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.preferences;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.preferences.Messages;

public class GSImportPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger LOG = Logger.getLogger(GSImportPreferencePage.class);
    public static final String ID = "sernet.gs.ui.rcp.main.page5";
    private StringFieldEditor url;
    private StringFieldEditor user;
    private StringFieldEditor pass;
    private static final String TEST_QUERY = "select top 1 * from N_Zielobjekt";

    public GSImportPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("GSImportPreferencePage_9"));
    }

    protected Control createContents(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(Messages.getString("GSImportPreferencePage_10"));
        link.addListener(13, event -> {
            boolean bl = Program.launch((String)event.text);
        });
        return super.createContents(parent);
    }

    public void createFieldEditors() {
        this.url = new StringFieldEditor("gs_cna_dburl", Messages.getString("GSImportPreferencePage.17"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.url);
        this.user = new StringFieldEditor("gs_cna_dbuser", Messages.getString("GSImportPreferencePage.18"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.user);
        this.pass = new StringFieldEditor("gs_cna_dbpass", Messages.getString("GSImportPreferencePage.19"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.pass);
        this.createTestButton();
    }

    private void createTestButton() {
        Button button = new Button((Composite)this.getControl(), 8);
        button.setText(Messages.getString("GSImportPreferencePage_0"));
        button.setLayoutData((Object)new GridData(3, 1, true, true));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String urlString = GSImportPreferencePage.this.url.getStringValue();
                final String userString = GSImportPreferencePage.this.user.getStringValue();
                final String passString = GSImportPreferencePage.this.pass.getStringValue();
                WorkspaceJob job = new WorkspaceJob(Messages.getString("GSImportPreferencePage_2")){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString("GSImportPreferencePage_1"), -1);
                        monitor.setTaskName(Messages.getString("GSImportPreferencePage_1"));
                        try {
                            LOG.debug((Object)"Loading MSSQL JDBC driver.");
                            Class.forName("net.sourceforge.jtds.jdbc.Driver");
                            LOG.debug((Object)"Establishing database connection");
                            Throwable throwable = null;
                            Object var3_5 = null;
                            try {
                                Connection con = DriverManager.getConnection(urlString, userString, passString);
                                try {
                                    try (Statement stmt = con.createStatement();){
                                        LOG.debug((Object)"Running test query.");
                                        stmt.executeQuery(GSImportPreferencePage.TEST_QUERY);
                                        LOG.debug((Object)"Finished MSSQL connection test.");
                                        Display.getDefault().syncExec(() -> MessageDialog.openInformation((Shell)GSImportPreferencePage.this.getShell(), (String)Messages.getString("GSImportPreferencePage_5"), (String)Messages.getString("GSImportPreferencePage_6")));
                                    }
                                    if (con == null) return Status.OK_STATUS;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (con == null) throw throwable;
                                    con.close();
                                    throw throwable;
                                }
                                con.close();
                                return Status.OK_STATUS;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                    throw throwable;
                                } else {
                                    if (throwable == throwable3) throw throwable;
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e1) {
                            if (e1.getMessage().indexOf("N_Zielobj") > -1) {
                                Display.getDefault().syncExec(() -> MessageDialog.openInformation((Shell)GSImportPreferencePage.this.getShell(), (String)Messages.getString("GSImportPreferencePage_15"), (String)Messages.getString("GSImportPreferencePage_16")));
                                return Status.CANCEL_STATUS;
                            } else {
                                ExceptionUtil.log(e1, String.valueOf(Messages.getString("GSImportPreferencePage_7")) + " " + urlString);
                            }
                            return Status.CANCEL_STATUS;
                        }
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            this.checkState();
        }
    }

    public void init(IWorkbench workbench) {
    }
}

