/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.preferences;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.preferences.Messages;
import sernet.hui.common.connect.HitroUtil;

public class EditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer viewer;

    public EditorPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("EditorPreferencePage.0"));
    }

    protected void createFieldEditors() {
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor("hui_tags_strict", Messages.getString("EditorPreferencePage.1"), this.getFieldEditorParent());
        this.addField((FieldEditor)booleanFieldEditor);
        this.createTagList();
    }

    private void createTagList() {
        int checkboxColumnWidth = 35;
        int tagColumnWidth = 200;
        this.viewer = CheckboxTableViewer.newCheckList((Composite)this.getFieldEditorParent(), (int)2560);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableColumn checkboxColumn = new TableColumn(table, 16384);
        checkboxColumn.setText("");
        checkboxColumn.setWidth(35);
        TableColumn tagColumn = new TableColumn(table, 16384);
        tagColumn.setText(Messages.getString("EditorPreferencePage.2"));
        tagColumn.setWidth(200);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 1) {
                    return (String)element;
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    public boolean performOk() {
        List<Object> tagList = Arrays.asList(this.viewer.getCheckedElements());
        String tagString = this.join(tagList);
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        prefs.setValue("hui_tags", tagString);
        return super.performOk();
    }

    private String join(List tags) {
        Iterator iter;
        if (tags == null || !(iter = tags.iterator()).hasNext()) {
            return "";
        }
        StringBuilder oBuilder = new StringBuilder(String.valueOf(iter.next()));
        while (iter.hasNext()) {
            oBuilder.append(",").append(iter.next());
        }
        return oBuilder.toString();
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        Object[] prefTagsArr;
        super.initialize();
        Activator.inheritVeriniceContextState();
        Set allTags = HitroUtil.getInstance().getTypeFactory().getAllTags();
        Object[] allTagsArray = null;
        if (allTags != null) {
            allTagsArray = allTags.toArray();
            Arrays.sort(allTagsArray);
            this.viewer.setInput((Object)allTagsArray);
        }
        if ((prefTagsArr = sernet.verinice.rcp.Preferences.getEditorTags()) != null) {
            this.viewer.setCheckedElements(prefTagsArr);
        }
    }
}

