/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.preferences;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.CnAWorkspace;
import sernet.gs.ui.rcp.main.preferences.Messages;

public class DatenbankPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private RadioGroupFieldEditor dbDriver;
    private StringFieldEditor dialect;
    private StringFieldEditor url;
    private StringFieldEditor user;
    private StringFieldEditor pass;
    private boolean modified = false;

    public DatenbankPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("DatenbankPreferencePage.0"));
    }

    protected Control createContents(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(Messages.getString("DatenbankPreferencePage.1"));
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)event.text);
            }
        });
        return super.createContents(parent);
    }

    public void createFieldEditors() {
        this.createRadioGroup();
        this.dialect = new StringFieldEditor("cna_dbdialect", Messages.getString("DatenbankPreferencePage.7"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.dialect);
        this.url = new StringFieldEditor("cna_dburl", Messages.getString("DatenbankPreferencePage.8"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.url);
        this.user = new StringFieldEditor("cna_dbuser", Messages.getString("DatenbankPreferencePage.9"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.user);
        this.pass = new StringFieldEditor("cna_dbpass", Messages.getString("DatenbankPreferencePage.10"), this.getFieldEditorParent());
        this.pass.getTextControl(this.getFieldEditorParent()).setEchoChar('*');
        this.addField((FieldEditor)this.pass);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            boolean standalone = this.getPreferenceStore().getString("gs_cna_operationmode").equals("gs_cna_operationmode_standalone");
            this.setEnabledFields(standalone);
        }
    }

    private void setEnabledFields(boolean enable) {
        Composite parent = this.getFieldEditorParent();
        this.dbDriver.setEnabled(enable, parent);
        this.dialect.setEnabled(false, parent);
        this.url.setEnabled(enable, parent);
        this.user.setEnabled(enable, parent);
        this.pass.setEnabled(enable, parent);
        Control[] radioButtons = this.dbDriver.getRadioBoxControl(parent).getChildren();
        radioButtons[radioButtons.length - 1].setEnabled(false);
        if (Activator.getDefault().isStandalone()) {
            radioButtons[radioButtons.length - 2].setEnabled(false);
        }
        if (enable) {
            this.setMessage(null);
        } else {
            this.setMessage(Messages.getString("DatenbankPreferencePage.ConfigurationDisabled"));
        }
    }

    private void createRadioGroup() {
        this.dbDriver = new RadioGroupFieldEditor("cna_driver", Messages.getString("DatenbankPreferencePage.11"), 1, (String[][])new String[][]{{Messages.getString("DatenbankPreferencePage.12"), "org.apache.derby.iapi.jdbc.AutoloadedDriver"}, {Messages.getString("DatenbankPreferencePage.13"), "org.postgresql.Driver"}, {Messages.getString("DatenbankPreferencePage.15"), "oracle.jdbc.OracleDriver"}}, this.getFieldEditorParent());
        this.addField((FieldEditor)this.dbDriver);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            if (event.getSource() == this.dbDriver) {
                this.setDefaults((String)event.getNewValue());
            }
            this.checkState();
        }
        this.modified = true;
    }

    private void setDefaults(String newValue) {
        if (newValue.equals("org.apache.derby.iapi.jdbc.AutoloadedDriver")) {
            this.dialect.setStringValue("sernet.verinice.hibernate.ByteArrayDerbyDialect");
            String derbyUrl = "jdbc:derby:%s/verinicedb;create=true".replace("%s", CnAWorkspace.getInstance().getWorkdir().getAbsolutePath().replaceAll("\\\\", "/"));
            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)("Derby url is " + derbyUrl));
            this.url.setStringValue(derbyUrl);
            this.user.setStringValue("");
            this.pass.setStringValue("");
        } else if (newValue.equals("org.postgresql.Driver")) {
            this.dialect.setStringValue("org.hibernate.dialect.PostgreSQLDialect");
            this.url.setStringValue("jdbc:postgresql://127.0.0.1:5432/verinicedb");
            this.user.setStringValue("");
            this.pass.setStringValue("");
        }
    }

    protected void checkState() {
        super.checkState();
        if (!this.isValid()) {
            return;
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.modified) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("DatenbankPreferencePage.RestartRequired"), (String)Messages.getString("DatenbankPreferencePage.RestartRequiredText"));
        }
        return super.performOk();
    }
}

