/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.preferences;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.Workbench;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.preferences.Messages;

public class ClientServerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private RadioGroupFieldEditor operationMode;
    private StringFieldEditor serverURI;
    private String oldServerMode;
    private String newServerMode;
    private String oldUrl;
    private String newUrl;
    private static final Logger LOG = Logger.getLogger(ClientServerPreferencePage.class);

    public ClientServerPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("ClientServerPreferencePage.0"));
    }

    public void createFieldEditors() {
        this.createRadioGroup();
        this.serverURI = new StringFieldEditor("gs_cna_vnserver_uri", Messages.getString("ClientServerPreferencePage.1"), this.getFieldEditorParent());
        final Text textControl = this.serverURI.getTextControl(this.getFieldEditorParent());
        textControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = ClientServerPreferencePage.this.serverURI.getStringValue();
                if (value.contains(" ")) {
                    Point cursorPosition = textControl.getSelection();
                    int numWhiteSpacesBeforeCursor = StringUtils.countMatches((String)value.substring(0, cursorPosition.x), (String)" ");
                    cursorPosition.x -= numWhiteSpacesBeforeCursor;
                    cursorPosition.y -= numWhiteSpacesBeforeCursor;
                    ClientServerPreferencePage.this.serverURI.setStringValue(value.replaceAll("\\s", ""));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"text trimmed");
                    }
                    textControl.setSelection(cursorPosition);
                }
            }
        });
        this.addField((FieldEditor)this.serverURI);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            boolean standalone = this.getPreferenceStore().getString("gs_cna_operationmode").equals("gs_cna_operationmode_standalone");
            this.serverURI.setEnabled(!standalone, this.getFieldEditorParent());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value") && event.getSource() == this.operationMode) {
            this.newServerMode = (String)event.getNewValue();
            boolean servermode = this.newServerMode.equals("gs_cna_operationmode_withserver");
            this.serverURI.setEnabled(servermode, this.getFieldEditorParent());
        }
        if (event.getProperty().equals("field_editor_value") && event.getSource() == this.serverURI) {
            this.newUrl = (String)event.getNewValue();
        }
    }

    private boolean propertyChanged() {
        return this.newServerMode != null && !this.newServerMode.equals(this.oldServerMode) || this.newUrl != null && !this.newUrl.equals(this.oldUrl);
    }

    private void createRadioGroup() {
        String name = "gs_cna_operationmode";
        String labelText = Messages.getString("ClientServerPreferencePage.4");
        String[][] labelAndValues = new String[][]{{Messages.getString("ClientServerPreferencePage.5"), "gs_cna_operationmode_standalone"}, {Messages.getString("ClientServerPreferencePage.6"), "gs_cna_operationmode_withserver"}};
        this.operationMode = new RadioGroupFieldEditor(name, labelText, 1, labelAndValues, this.getFieldEditorParent());
        this.addField((FieldEditor)this.operationMode);
    }

    public void init(IWorkbench workbench) {
        this.oldServerMode = this.getPreferenceStore().getString("gs_cna_operationmode");
        this.oldUrl = this.getPreferenceStore().getString("gs_cna_vnserver_uri");
    }

    public boolean performOk() {
        MessageDialog mDialog;
        int result;
        boolean returnValue = super.performOk();
        if (this.propertyChanged() && (result = (mDialog = new MessageDialog(Display.getDefault().getActiveShell(), Messages.getString("ClientServerPreferencePage.2"), null, Messages.getString("ClientServerPreferencePage.3"), 3, new String[]{Messages.getString("ClientServerPreferencePage.7"), Messages.getString("ClientServerPreferencePage.8")}, 1)).open()) == 1) {
            Workbench.getInstance().restart();
        }
        return returnValue;
    }
}

