/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import sernet.gs.ui.rcp.main.logging.LogDirectoryProvider;
import sernet.gs.ui.rcp.main.logging.UnixLogDirectory;
import sernet.gs.ui.rcp.main.logging.WindowsLogDirectory;
import sernet.verinice.interfaces.ILogPathService;

public class LoggerInitializer
implements ILogPathService {
    private LogDirectoryProvider logDirectoryProvider;
    protected String currentLogFilePath = null;

    protected LoggerInitializer() {
        this.tryReadingCustomLog4jFile();
        this.tryConfiguringLoggingPath();
        this.logDirectoryProvider = this.getLogDirectoryProvider();
    }

    private LogDirectoryProvider getLogDirectoryProvider() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new WindowsLogDirectory(this.currentLogFilePath);
        }
        return new UnixLogDirectory(this.currentLogFilePath);
    }

    private void tryReadingCustomLog4jFile() {
        if (this.existsCustomLog4jConfigurationFile()) {
            this.configureWithCustomLog4jFile();
        }
    }

    private void tryConfiguringLoggingPath() {
        this.getLogFilePath();
        this.validatePath();
        this.configureAllFileAppender();
    }

    private boolean existsCustomLog4jConfigurationFile() {
        return System.getProperty("log4j.configuration") != null;
    }

    private void configureWithCustomLog4jFile() {
        Logger.getRootLogger().getLoggerRepository().resetConfiguration();
        String config = System.getProperty("log4j.configuration");
        String extension = FilenameUtils.getExtension((String)config);
        if ("xml".equals(extension)) {
            DOMConfigurator.configure((String)config);
        } else if ("properties".equals(extension)) {
            PropertyConfigurator.configure((String)config);
        }
    }

    private void validatePath() {
        if (this.validatePath(this.currentLogFilePath)) {
            return;
        }
        this.currentLogFilePath = FilenameUtils.concat((String)FilenameUtils.concat((String)System.getProperty("user.home"), (String)"verinice"), (String)"verinice-client.log");
        if (this.validatePath(this.currentLogFilePath)) {
            System.out.println(String.format("use fallback path %s", this.currentLogFilePath));
            return;
        }
        this.currentLogFilePath = FilenameUtils.concat((String)FilenameUtils.concat((String)System.getProperty("java.io.tmpdir"), (String)"verinice"), (String)"verinice-client.log");
        if (this.validatePath(this.currentLogFilePath)) {
            System.out.println(String.format("use fallback path %s", this.currentLogFilePath));
            return;
        }
        System.err.println("no logging path is configured for file appender");
    }

    private boolean validatePath(String path) {
        FileOutputStream out = null;
        try {
            File file = new File(path);
            if (file.isDirectory()) {
                throw new FileNotFoundException("path is a directory");
            }
            this.createParentDirectories(file);
            out = new FileOutputStream(file, true);
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception ex) {
            System.err.println(String.format("logging path is invalid %s", ex.getLocalizedMessage()));
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    System.err.println(String.format("closing of log file stream failed %s", e.getLocalizedMessage()));
                }
            }
            return false;
        }
    }

    private void createParentDirectories(File file) throws IOException {
        new File(FilenameUtils.getFullPath((String)file.getCanonicalPath())).mkdirs();
    }

    private void configureAllFileAppender() {
        Logger log = Logger.getRootLogger();
        Enumeration appenders = log.getAllAppenders();
        while (appenders.hasMoreElements()) {
            FileAppender fileAppender;
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof FileAppender) || this.isFilePathConfigured(fileAppender = (FileAppender)appender) && !this.isConfiguredInVeriniceIniFile()) continue;
            fileAppender.setFile(this.currentLogFilePath);
            fileAppender.activateOptions();
        }
    }

    private boolean isConfiguredInVeriniceIniFile() {
        return System.getProperty("logging.file") != null;
    }

    private boolean isFilePathConfigured(FileAppender fileAppender) {
        return fileAppender.getFile() != null;
    }

    private String getLogFilePath() {
        String filePath = null;
        filePath = this.isConfiguredInVeriniceIniFile() ? this.readFromVeriniceIniFile() : String.valueOf(this.getStandardDirectory()) + "verinice-client.log";
        this.currentLogFilePath = this.removeInvalidPrefix(filePath);
        return this.currentLogFilePath;
    }

    private String removeInvalidPrefix(String directory) {
        if (directory.startsWith("file:")) {
            return directory.substring(5);
        }
        return directory;
    }

    private String getStandardDirectory() {
        return FilenameUtils.concat((String)System.getProperty("osgi.instance.area"), (String)LogDirectoryProvider.LOG_FOLDER);
    }

    private String readFromVeriniceIniFile() {
        return System.getProperty("logging.file");
    }

    public String getLogDirectory() {
        return this.logDirectoryProvider.getLogDirectory();
    }

    public void setLogDirectoryProvider(LogDirectoryProvider logDirectoryProvider) {
        this.logDirectoryProvider = logDirectoryProvider;
    }

    public static LoggerInitializer setupLogFilePath() {
        return new LoggerInitializer();
    }
}

