/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.common.model;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Domain;
import sernet.verinice.service.commands.CnATypeMapper;
import sernet.verinice.service.commands.CreateLink;

public final class LinkUtil {
    private static final Logger LOGGER = Logger.getLogger(LinkUtil.class);
    private static final ICommandService commandService = CnAElementHome.getInstance().getCommandService();

    private LinkUtil() {
    }

    public static CnALink createLink(CnATreeElement source, CnATreeElement target, String relationId) {
        CreateLink command = new CreateLink(source, target, relationId, false);
        try {
            command = (CreateLink)commandService.executeCommand((ICommand)command);
            CnALink link = command.getLink();
            Domain dependantDomain = CnATypeMapper.getDomainFromTypeId((String)link.getDependant().getTypeId());
            Domain dependencyDomain = CnATypeMapper.getDomainFromTypeId((String)link.getDependency().getTypeId());
            EnumSet<Domain> relevantDomains = EnumSet.of(dependantDomain, dependencyDomain);
            if (relevantDomains.contains(Domain.BASE_PROTECTION_OLD) && CnAElementFactory.isModelLoaded()) {
                CnAElementFactory.getLoadedModel().linkAdded(link);
            }
            if (relevantDomains.contains(Domain.ISM) && CnAElementFactory.isIsoModelLoaded()) {
                CnAElementFactory.getInstance().getISO27kModel().linkAdded(link);
            }
            if (relevantDomains.contains(Domain.BASE_PROTECTION) && CnAElementFactory.isBpModelLoaded()) {
                CnAElementFactory.getInstance().getBpModel().linkAdded(link);
            }
            return link;
        }
        catch (CommandException e) {
            LOGGER.error((Object)"Link creation failed", (Throwable)e);
            return null;
        }
    }

    public static void createLinks(Set<CnATreeElement> sources, CnATreeElement target, String relationId) {
        for (CnATreeElement source : sources) {
            Optional.ofNullable(LinkUtil.createLink(source, target, relationId)).ifPresent(arg_0 -> ((CnATreeElement)target).addLinkUp(arg_0));
        }
    }

    public static void createLinks(CnATreeElement source, Set<CnATreeElement> targets, String relationId) {
        for (CnATreeElement target : targets) {
            Optional.ofNullable(LinkUtil.createLink(source, target, relationId)).ifPresent(arg_0 -> ((CnATreeElement)source).addLinkDown(arg_0));
        }
    }
}

