/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.common.model;

import java.util.stream.Stream;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.verinice.model.bp.groups.ImportBpGroup;
import sernet.verinice.model.bsi.ImportBsiGroup;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Domain;
import sernet.verinice.model.iso27k.ImportIsoGroup;
import sernet.verinice.service.commands.CnATypeMapper;

public final class CnATreeElementScopeUtils {
    private static final CnAElementFactory cnAElementFactory = CnAElementFactory.getInstance();

    public static CnATreeElement getScope(CnATreeElement element) {
        Integer scopeElementId = element.getScopeId();
        if (element.getDbId() == scopeElementId) {
            return element;
        }
        Domain elementDomain = CnATypeMapper.getDomainFromTypeId((String)element.getTypeId());
        Class<?> importGroupClass = CnATreeElementScopeUtils.getImportGroupClassForDomain(elementDomain);
        CnATreeElement modelForDomain = CnATreeElementScopeUtils.getModelForDomain(elementDomain);
        Stream potentialScopes = modelForDomain.getChildren().stream().flatMap(child -> {
            if (importGroupClass.isInstance(child)) {
                return child.getChildren().stream();
            }
            return Stream.of(child);
        });
        potentialScopes = Stream.concat(potentialScopes, cnAElementFactory.getCatalogModel().getChildren().stream());
        return potentialScopes.filter(scope -> scope.getDbId().equals(scopeElementId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find scope for " + element));
    }

    private static Class<?> getImportGroupClassForDomain(Domain domain) {
        switch (domain) {
            case BASE_PROTECTION: {
                return ImportBpGroup.class;
            }
            case BASE_PROTECTION_OLD: {
                return ImportBsiGroup.class;
            }
            case ISM: {
                return ImportIsoGroup.class;
            }
        }
        throw new IllegalArgumentException("Unsupported domain " + domain);
    }

    private static CnATreeElement getModelForDomain(Domain domain) {
        switch (domain) {
            case BASE_PROTECTION: {
                return cnAElementFactory.getBpModel();
            }
            case BASE_PROTECTION_OLD: {
                return CnAElementFactory.getLoadedModel();
            }
            case ISM: {
                return cnAElementFactory.getISO27kModel();
            }
        }
        throw new IllegalArgumentException("Unsupported domain " + domain);
    }

    private CnATreeElementScopeUtils() {
    }
}

