/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.common.model;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.StaleObjectStateException;
import sernet.gs.model.Baustein;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dnd.DNDItems;
import sernet.gs.ui.rcp.main.bsi.views.BSIKatalogInvisibleRoot;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.Messages;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.HuiRelation;
import sernet.hui.common.connect.ITypedElement;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IProgress;
import sernet.verinice.interfaces.validation.IValidationService;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.bsi.IBSIStrukturKategorie;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.Person;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Permission;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.model.iso27k.IISO27kElement;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.iso27k.ImportIsoGroup;
import sernet.verinice.model.iso27k.IncidentScenario;
import sernet.verinice.model.iso27k.Threat;
import sernet.verinice.model.iso27k.Vulnerability;
import sernet.verinice.service.commands.CreateElement;
import sernet.verinice.service.commands.CreateLink;
import sernet.verinice.service.commands.LoadCurrentUserConfiguration;
import sernet.verinice.service.commands.LoadElementsByUuid;
import sernet.verinice.service.commands.RemoveElement;
import sernet.verinice.service.commands.RemoveLink;
import sernet.verinice.service.commands.SaveElement;
import sernet.verinice.service.commands.UpdateElement;
import sernet.verinice.service.commands.UpdateElementEntity;
import sernet.verinice.service.commands.crud.CreateBaustein;
import sernet.verinice.service.commands.crud.LoadBSIModelForTreeView;
import sernet.verinice.service.commands.crud.LoadCnAElementById;
import sernet.verinice.service.commands.crud.LoadCnAElementByType;
import sernet.verinice.service.commands.crud.RefreshElement;
import sernet.verinice.service.commands.crud.UpdateMultipleElements;
import sernet.verinice.service.commands.task.CreateScenario;
import sernet.verinice.service.commands.task.FindAllTags;

public final class CnAElementHome {
    private final Logger log = Logger.getLogger(CnAElementHome.class);
    private Set<String> roles = null;
    private static CnAElementHome instance;
    protected static final String LINK_NO_COMMENT = "";
    private ICommandService commandService;
    private IValidationService validationService;

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            try {
                this.open();
            }
            catch (Exception e) {
                this.log.error((Object)"Error while opening command service", (Throwable)e);
            }
        }
        return this.commandService;
    }

    private CnAElementHome() {
    }

    public static CnAElementHome getInstance() {
        if (instance == null) {
            instance = new CnAElementHome();
        }
        return instance;
    }

    public boolean isOpen() {
        return this.commandService != null;
    }

    public void open(IProgress monitor) throws MalformedURLException {
        monitor.beginTask(Messages.getString("CnAElementHome.0"), -1);
        ServiceFactory.openCommandService();
        this.commandService = ServiceFactory.lookupCommandService();
    }

    public void open() throws MalformedURLException {
        ServiceFactory.openCommandService();
        this.commandService = this.createCommandService();
    }

    private ICommandService createCommandService() {
        this.commandService = ServiceFactory.lookupCommandService();
        return this.commandService;
    }

    public void close() {
        ServiceFactory.closeCommandService();
        this.commandService = null;
    }

    public <T extends CnATreeElement> T save(T element) throws CommandException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving new element, uuid " + element.getUuid()));
        }
        SaveElement saveCommand = new SaveElement(element);
        saveCommand = (SaveElement)this.getCommandService().executeCommand((ICommand)saveCommand);
        if (Activator.getDefault().getPluginPreferences().getBoolean("use_automatic_validation")) {
            this.validateElement((CnATreeElement)saveCommand.getElement());
        }
        return (T)((CnATreeElement)saveCommand.getElement());
    }

    public <T extends CnATreeElement> T save(CnATreeElement container, Class<T> clazz) throws CommandException {
        return this.save(container, clazz, null);
    }

    public <T extends CnATreeElement> T save(CnATreeElement container, Class<T> clazz, String typeId) throws CommandException {
        String title = null;
        if (typeId != null) {
            title = HitroUtil.getInstance().getTypeFactory().getMessage(typeId);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating new instance of " + clazz.getName() + " in " + container + " with title: " + title));
        }
        CreateElement saveCommand = new CreateElement(container, clazz, title);
        saveCommand.setInheritAuditPermissions(true);
        saveCommand = (CreateElement)this.getCommandService().executeCommand((ICommand)saveCommand);
        if (Activator.getDefault().getPluginPreferences().getBoolean("use_automatic_validation")) {
            this.validateElement(saveCommand.getNewElement());
        }
        return (T)saveCommand.getNewElement();
    }

    public BausteinUmsetzung save(CnATreeElement container, Baustein baustein) throws CommandException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating new element, parent uuid: " + container.getUuid()));
        }
        CreateBaustein saveCommand = new CreateBaustein(container, baustein, BSIKatalogInvisibleRoot.getInstance().getLanguage());
        saveCommand = (CreateBaustein)this.getCommandService().executeCommand((ICommand)saveCommand);
        if (Activator.getDefault().getPluginPreferences().getBoolean("use_automatic_validation")) {
            this.validateElement((CnATreeElement)saveCommand.getNewElement());
        }
        return saveCommand.getNewElement();
    }

    public CnALink createLink(CnATreeElement dropTarget, CnATreeElement dragged) throws CommandException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving new link from " + dropTarget.getUuid() + " to " + dragged.getUuid()));
        }
        CreateLink command = new CreateLink(dropTarget, dragged, false);
        command = (CreateLink)this.getCommandService().executeCommand((ICommand)command);
        return command.getLink();
    }

    public CnALink createLink(CnATreeElement dropTarget, CnATreeElement dragged, String typeId, String comment) throws CommandException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving new link from " + dropTarget.getUuid() + " to " + dragged.getUuid() + " of type " + typeId));
        }
        CreateLink command = new CreateLink(dropTarget, dragged, typeId, comment, false);
        command = (CreateLink)this.getCommandService().executeCommand((ICommand)command);
        return command.getLink();
    }

    public void remove(Collection<CnATreeElement> elements) throws CommandException {
        if (this.log.isDebugEnabled()) {
            elements.forEach(element -> this.log.debug((Object)("Deleting element, uuid: " + element.getUuid())));
        }
        RemoveElement command = new RemoveElement(elements);
        for (CnATreeElement element2 : elements) {
            this.deleteValidations(element2);
        }
        this.getCommandService().executeCommand((ICommand)command);
    }

    public void remove(CnALink element) throws CommandException {
        RemoveLink command = new RemoveLink(element);
        this.getCommandService().executeCommand((ICommand)command);
    }

    public CnATreeElement update(CnATreeElement element) throws CommandException {
        UpdateElement command = new UpdateElement((ITypedElement)element, true, ChangeLogEntry.STATION_ID);
        command = (UpdateElement)this.getCommandService().executeCommand((ICommand)command);
        return (CnATreeElement)command.getElement();
    }

    public CnATreeElement updateEntity(CnATreeElement element) throws CommandException {
        UpdateElementEntity command = this.createCommand(element);
        command = (UpdateElementEntity)this.getCommandService().executeCommand(command);
        if (Activator.getDefault().getPluginPreferences().getBoolean("use_automatic_validation")) {
            this.validateElement(command.getMergedElement());
        }
        return command.getMergedElement();
    }

    public void update(List<? extends CnATreeElement> elements) throws StaleObjectStateException, CommandException {
        UpdateMultipleElements command = new UpdateMultipleElements(elements, ChangeLogEntry.STATION_ID);
        command = (UpdateMultipleElements)this.getCommandService().executeCommand((ICommand)command);
        if (Activator.getDefault().getPluginPreferences().getBoolean("use_automatic_validation")) {
            for (Object o : command.getChangedElements()) {
                if (!(o instanceof CnATreeElement)) continue;
                this.validateElement((CnATreeElement)o);
            }
        }
    }

    public CnATreeElement loadById(String typeId, int id) throws CommandException {
        LoadCnAElementById command = new LoadCnAElementById(typeId, id);
        command = (LoadCnAElementById)this.getCommandService().executeCommand((ICommand)command);
        return command.getFound();
    }

    @Deprecated
    public Set<CnATreeElement> loadElementsByUUID(Collection<String> elementUUIDs, RetrieveInfo retrieveInfo) throws CommandException {
        LoadElementsByUuid elementLoader = new LoadElementsByUuid(elementUUIDs.stream().collect(Collectors.toList()), retrieveInfo);
        elementLoader = (LoadElementsByUuid)this.getCommandService().executeCommand((ICommand)elementLoader);
        return elementLoader.getElements();
    }

    public BSIModel loadModel(IProgress nullMonitor) throws CommandException {
        this.log.debug((Object)"Loading model instance");
        nullMonitor.setTaskName(Messages.getString("CnAElementHome.1"));
        LoadBSIModelForTreeView command = new LoadBSIModelForTreeView();
        command = (LoadBSIModelForTreeView)this.getCommandService().executeCommand((ICommand)command);
        return command.getModel();
    }

    public void refresh(CnATreeElement cnAElement) throws CommandException {
        RefreshElement command = new RefreshElement(cnAElement);
        command = (RefreshElement)this.getCommandService().executeCommand((ICommand)command);
        CnATreeElement refreshedElement = command.getElement();
        cnAElement.setEntity(refreshedElement.getEntity());
    }

    public List<Person> getPersonen() throws CommandException {
        LoadCnAElementByType command = new LoadCnAElementByType(Person.class);
        command = (LoadCnAElementByType)this.getCommandService().executeCommand((ICommand)command);
        return command.getElements();
    }

    public List<String> getTags() throws CommandException {
        FindAllTags command = new FindAllTags();
        command = (FindAllTags)this.getCommandService().executeCommand((ICommand)command);
        return command.getTags();
    }

    public boolean isDeleteAllowed(CnATreeElement cte) {
        if (cte instanceof ImportIsoGroup) {
            return true;
        }
        if (cte instanceof IBSIStrukturKategorie) {
            return false;
        }
        if (cte.isScope()) {
            return this.isWriteAllowed(cte);
        }
        return this.isWriteAllowed(cte) && this.isWriteAllowed(cte.getParent());
    }

    public boolean isDeleteAllowed(CnALink cl) {
        return this.isWriteAllowed(cl.getDependant());
    }

    public boolean isNewChildAllowed(CnATreeElement cte) {
        return cte instanceof BSIModel || cte instanceof ISO27KModel || cte instanceof BpModel || cte instanceof CatalogModel || this.isWriteAllowed(cte);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWriteAllowed(CnATreeElement cte) {
        try {
            Permission p;
            CnATreeElement elemntWithPermissions;
            if (this.isCatalogElement(cte)) {
                return false;
            }
            ServiceFactory.lookupAuthService();
            if (!ServiceFactory.isPermissionHandlingNeeded()) {
                return true;
            }
            if (this.getAuthService().currentUserHasRole(new String[]{"ROLE_ADMIN"})) {
                return true;
            }
            if (this.roles == null) {
                LoadCurrentUserConfiguration lcuc = new LoadCurrentUserConfiguration();
                lcuc = (LoadCurrentUserConfiguration)this.getCommandService().executeCommand((ICommand)lcuc);
                Configuration c = lcuc.getConfiguration();
                if (c == null) {
                    return false;
                }
                this.roles = c.getRoles();
            }
            if ((elemntWithPermissions = Retriever.checkRetrievePermissions((CnATreeElement)cte)) == null) {
                if (!this.log.isInfoEnabled()) return false;
                this.log.info((Object)("Element " + cte + " not found when checking write permissions"));
                return false;
            }
            Iterator iterator = elemntWithPermissions.getPermissions().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(p = (Permission)iterator.next()).isWriteAllowed() || !this.roles.contains(p.getRole()));
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"Error while checking write permission.", (Throwable)e);
        }
        return false;
    }

    public boolean isCatalogElement(CnATreeElement element) {
        if (element.getScopeId() == null) {
            return false;
        }
        CatalogModel catalogModel = CnAElementFactory.getInstance().getCatalogModel();
        return catalogModel.getChildren().stream().map(CnATreeElement::getDbId).anyMatch(element.getScopeId()::equals);
    }

    public void createLinksAccordingToBusinessLogic(CnATreeElement dropTarget, List<CnATreeElement> toDrop) {
        this.createLinksAccordingToBusinessLogicAsync(dropTarget, toDrop, null);
    }

    public void createLinksAccordingToBusinessLogicAsync(CnATreeElement dropTarget, List<CnATreeElement> toDrop, String linkId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"createLink...");
        }
        Display.getDefault().asyncExec(() -> {
            Activator.inheritVeriniceContextState();
            this.createLinksAccordingToBusinessLogic(dropTarget, toDrop, linkId);
        });
    }

    protected void createLinksAccordingToBusinessLogic(CnATreeElement dropTarget, List<CnATreeElement> droppedElements, String linkId) {
        ArrayList<CnALink> newLinks = new ArrayList<CnALink>();
        for (CnATreeElement droppedElement : droppedElements) {
            try {
                if (this.linksAreConfiguredInSnca(dropTarget, droppedElement)) {
                    boolean linkCreated;
                    this.specialISO27kDndHandling(dropTarget, droppedElement);
                    String linkIdParam = linkId;
                    if (linkIdParam == null) {
                        linkIdParam = this.getFirstLinkdId(droppedElement, dropTarget);
                    }
                    if (linkIdParam != null && (linkCreated = this.createTypedLink(newLinks, dropTarget, droppedElement, linkIdParam, LINK_NO_COMMENT))) continue;
                    if (linkIdParam == null) {
                        linkIdParam = this.getFirstLinkdId(dropTarget, droppedElement);
                    }
                    if (linkIdParam != null && (linkCreated = this.createTypedLink(newLinks, droppedElement, dropTarget, linkIdParam, LINK_NO_COMMENT))) continue;
                }
                boolean bsiHandlingNeeded = dropTarget instanceof IBSIStrukturElement || droppedElement instanceof IBSIStrukturElement || dropTarget instanceof BausteinUmsetzung;
                bsiHandlingNeeded = bsiHandlingNeeded || droppedElement instanceof BausteinUmsetzung || dropTarget instanceof MassnahmenUmsetzung;
                boolean bl = bsiHandlingNeeded = bsiHandlingNeeded || droppedElement instanceof MassnahmenUmsetzung;
                if (!bsiHandlingNeeded) continue;
                this.bsiElementLinkHandling(dropTarget, linkId, newLinks, droppedElement);
            }
            catch (Exception e) {
                this.log.debug((Object)"Saving link failed.", (Throwable)e);
            }
        }
        for (CnALink link : newLinks) {
            if (!(link.getDependant() instanceof ITVerbund)) continue;
            CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
            return;
        }
        if (newLinks != null && !newLinks.isEmpty()) {
            CnALink link;
            link = (CnALink)newLinks.get(newLinks.size() - 1);
            if (link.getDependant() instanceof IBSIStrukturElement || link.getDependant() instanceof MassnahmenUmsetzung || link.getDependency() instanceof IBSIStrukturElement || link.getDependency() instanceof MassnahmenUmsetzung) {
                CnAElementFactory.getLoadedModel().linkAdded(link);
            }
            if (link.getDependant() instanceof IISO27kElement || link.getDependency() instanceof IISO27kElement) {
                CnAElementFactory.getInstance().getISO27kModel().linkAdded(link);
            }
            if (link.getDependant() instanceof IBpElement || link.getDependency() instanceof IBpElement) {
                CnAElementFactory.getInstance().getBpModel().linkAdded(link);
            }
        }
        DNDItems.clear();
    }

    protected boolean linksAreConfiguredInSnca(CnATreeElement dropTarget, CnATreeElement dragged) {
        return !(!(dropTarget instanceof IISO27kElement) && !(dropTarget instanceof IBpElement) || !(dragged instanceof IISO27kElement) && !(dragged instanceof IBpElement));
    }

    private void bsiElementLinkHandling(CnATreeElement dropTarget, String linkId, List<CnALink> newLinks, CnATreeElement dragged) throws CommandException {
        CnATreeElement from = dropTarget;
        CnATreeElement to = dragged;
        String linkIdParam = linkId;
        if (linkIdParam == null) {
            linkIdParam = this.getFirstLinkdId(to, from);
        }
        if (linkIdParam == null) {
            from = dragged;
            to = dropTarget;
            linkIdParam = this.getFirstLinkdId(to, from);
        }
        if (linkIdParam == null) {
            CnALink link = CnAElementHome.getInstance().createLink(dropTarget, dragged);
            newLinks.add(link);
        } else {
            this.createTypedLink(newLinks, from, to, linkIdParam, LINK_NO_COMMENT);
        }
    }

    private String getFirstLinkdId(CnATreeElement dropTarget, CnATreeElement dragged) {
        String linkIdParam = null;
        Set possibleRelations = HitroUtil.getInstance().getTypeFactory().getPossibleRelations(dragged.getEntityType().getId(), dropTarget.getEntityType().getId());
        if (!possibleRelations.isEmpty()) {
            linkIdParam = ((HuiRelation)possibleRelations.iterator().next()).getId();
        }
        return linkIdParam;
    }

    private void specialISO27kDndHandling(CnATreeElement dropTarget, CnATreeElement dragged) {
        if (dropTarget instanceof Threat && dragged instanceof Vulnerability) {
            Threat threat = (Threat)dropTarget;
            Vulnerability vuln = (Vulnerability)dragged;
            this.createScenario(threat, vuln);
        } else if (dropTarget instanceof Vulnerability && dragged instanceof Threat) {
            Vulnerability vuln = (Vulnerability)dropTarget;
            Threat threat = (Threat)dragged;
            this.createScenario(threat, vuln);
        }
    }

    protected void createScenario(Threat threat, Vulnerability vuln) {
        boolean confirm = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("CnAElementHome.5"), (String)(String.valueOf(Messages.getString("CnAElementHome.6")) + Messages.getString("CnAElementHome.7")));
        if (!confirm) {
            return;
        }
        try {
            CreateScenario command = new CreateScenario(threat, vuln);
            command = (CreateScenario)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            IncidentScenario newElement = command.getNewElement();
            CnAElementFactory.getInstance().getISO27kModel().childAdded(newElement.getParent(), (CnATreeElement)newElement);
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, "Error while creating the new scenario.");
        }
    }

    protected boolean createTypedLink(List<CnALink> newLinks, CnATreeElement from, CnATreeElement to, String relationTypeid, String comment) throws CommandException {
        CnALink link = CnAElementHome.getInstance().createLink(from, to, relationTypeid, comment);
        if (link == null) {
            return false;
        }
        newLinks.add(link);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Link created");
        }
        return true;
    }

    private UpdateElementEntity<? extends CnATreeElement> createCommand(CnATreeElement element) {
        return new UpdateElementEntity(element, ChangeLogEntry.STATION_ID);
    }

    private void validateElement(CnATreeElement elmt) {
        this.getValidationService().createValidationForSingleElement(elmt);
        CnAElementFactory.getModel(elmt).validationAdded(elmt.getScopeId());
    }

    private IValidationService getValidationService() {
        if (this.validationService == null) {
            this.validationService = ServiceFactory.lookupValidationService();
        }
        return this.validationService;
    }

    private void deleteValidations(CnATreeElement element) throws CommandException {
        if (element.getScopeId() != null && element.getDbId() != null) {
            this.getValidationService().deleteValidationsOfSubtree(element);
            CnAElementFactory.getModel(element).validationRemoved(element.getScopeId());
        } else {
            this.log.error((Object)"Can't delete validations of element, scopeId or elementId not set");
        }
    }

    private IAuthService getAuthService() {
        return ServiceFactory.lookupAuthService();
    }
}

