/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.common.model;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import sernet.gs.model.Baustein;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.BuildInput;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.Messages;
import sernet.gs.ui.rcp.main.common.model.NullMonitor;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.ITypedElement;
import sernet.verinice.interfaces.CnATreeElementBuildException;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IProgress;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.bsi.Anwendung;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.model.bsi.SubtypenZielobjekte;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.ds.StellungnahmeDSB;
import sernet.verinice.model.iso27k.IISO27kElement;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.service.bp.LoadBpModel;
import sernet.verinice.service.commands.CnATypeMapper;
import sernet.verinice.service.commands.CreateAnwendung;
import sernet.verinice.service.commands.CreateElement;
import sernet.verinice.service.commands.CreateITNetwork;
import sernet.verinice.service.commands.CreateITVerbund;
import sernet.verinice.service.commands.UpdateElement;
import sernet.verinice.service.commands.crud.CreateBpModel;
import sernet.verinice.service.commands.crud.CreateCatalogModel;
import sernet.verinice.service.commands.crud.CreateIsoModel;
import sernet.verinice.service.commands.crud.UpdateMultipleElements;
import sernet.verinice.service.model.LoadModel;

public final class CnAElementFactory {
    private static final Logger logger = Logger.getLogger(CnAElementFactory.class);
    private static volatile CnAElementFactory instance;
    private Object mutex = new Object();
    private List<IModelLoadListener> listeners = new CopyOnWriteArrayList<IModelLoadListener>();
    private Map<String, IElementBuilder> elementbuilders = new HashMap<String, IElementBuilder>();
    private CnAElementHome dbHome = CnAElementHome.getInstance();
    private BSIModel loadedModel;
    private ISO27KModel isoModel;
    private BpModel boModel;
    private CatalogModel catalogModel;
    private ICommandService commandService;
    private static final String WARNING_UNCHECKED = "unchecked";
    private static final String WARNING_RAWTYPES = "rawtypes";

    public void addLoadListener(IModelLoadListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Adding model load listener.");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        if (this.loadedModel != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Firing safety event: bsi model loaded.");
            }
            listener.loaded(this.loadedModel);
        }
        if (this.isoModel != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Firing safety event: iso27k model");
            }
            listener.loaded(this.isoModel);
        }
        if (this.boModel != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Firing safety event: bo model");
            }
            listener.loaded(this.boModel);
        }
    }

    public void removeLoadListener(IModelLoadListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private CnAElementFactory() {
        this.elementbuilders.put("stellungnahmedsb", new ElementBuilder(){

            public CnATreeElement build(CnATreeElement container, BuildInput input) throws CommandException {
                StellungnahmeDSB child = CnAElementFactory.this.dbHome.save(container, StellungnahmeDSB.class, "stellungnahmedsb");
                this.init(container, (CnATreeElement)child);
                return child;
            }
        });
        this.elementbuilders.put("personengruppen", new DefaultElementBuilder("personengruppen"));
        this.elementbuilders.put("datenverarbeitung", new DefaultElementBuilder("datenverarbeitung"));
        this.elementbuilders.put("verarbeitungsangaben", new DefaultElementBuilder("verarbeitungsangaben"));
        this.elementbuilders.put("zweckbestimmung", new DefaultElementBuilder("zweckbestimmung"));
        this.elementbuilders.put("verantwortlichestelle", new DefaultElementBuilder("verantwortlichestelle"));
        this.elementbuilders.put("netzkategorie", new DefaultElementBuilder("netzkategorie"));
        this.elementbuilders.put("sonstitkategorie", new DefaultElementBuilder("sonstitkategorie"));
        this.elementbuilders.put("personkategorie", new DefaultElementBuilder("personkategorie"));
        this.elementbuilders.put("anwendungenkategorie", new DefaultElementBuilder("anwendungenkategorie"));
        this.elementbuilders.put("gebaeudekategorie", new DefaultElementBuilder("gebaeudekategorie"));
        this.elementbuilders.put("raeumekategorie", new DefaultElementBuilder("raeumekategorie"));
        this.elementbuilders.put("tkkategorie", new DefaultElementBuilder("tkkategorie"));
        this.elementbuilders.put("serverkategorie", new DefaultElementBuilder("serverkategorie"));
        this.elementbuilders.put("clientskategorie", new DefaultElementBuilder("clientskategorie"));
        this.elementbuilders.put("massnahmeKategorie", new DefaultElementBuilder("massnahmeKategorie"));
        this.elementbuilders.put("gebaeude", new DefaultElementBuilder("gebaeude"));
        this.elementbuilders.put("client", new DefaultElementBuilder("client"));
        this.elementbuilders.put("sonstit", new DefaultElementBuilder("sonstit"));
        this.elementbuilders.put("server", new DefaultElementBuilder("server"));
        this.elementbuilders.put("tkkomponente", new DefaultElementBuilder("tkkomponente"));
        this.elementbuilders.put("raum", new DefaultElementBuilder("raum"));
        this.elementbuilders.put("netzkomponente", new DefaultElementBuilder("netzkomponente"));
        this.elementbuilders.put("person", new DefaultElementBuilder("person"));
        this.elementbuilders.put("anwendung", new ElementBuilder(){

            public CnATreeElement build(CnATreeElement container, BuildInput input) throws CommandException {
                logger.debug((Object)("Creating new Anwendung in " + container));
                CreateAnwendung saveCommand = new CreateAnwendung(container, Anwendung.class);
                saveCommand = (CreateAnwendung)ServiceFactory.lookupCommandService().executeCommand((ICommand)saveCommand);
                Anwendung child = saveCommand.getNewElement();
                this.init(container, (CnATreeElement)child);
                return child;
            }
        });
        this.elementbuilders.put("bstumsetzung", new IElementBuilder<BausteinUmsetzung, Baustein>(){

            @Override
            public BausteinUmsetzung build(CnATreeElement container, BuildInput<Baustein> input) throws CommandException {
                if (input == null) {
                    return CnAElementFactory.this.dbHome.save(container, BausteinUmsetzung.class, "bstumsetzung");
                }
                BausteinUmsetzung bu = CnAElementFactory.this.dbHome.save(container, input.getInput());
                container.addChild((CnATreeElement)bu);
                bu.setParentAndScope(container);
                return bu;
            }
        });
        this.elementbuilders.put("mnums", new DefaultElementBuilder("mnums"));
        this.elementbuilders.put("gefaehrdungsumsetzung", new DefaultElementBuilder("gefaehrdungsumsetzung"));
        this.elementbuilders.put("itverbund", new ElementBuilder(){

            public ITVerbund build(CnATreeElement container, BuildInput input) throws CommandException {
                logger.debug((Object)("Creating new ITVerbund in " + container));
                boolean createChildren = true;
                if (input != null) {
                    createChildren = (Boolean)input.getInput();
                }
                CreateITVerbund saveCommand = new CreateITVerbund(container, ITVerbund.class, createChildren);
                saveCommand = (CreateITVerbund)ServiceFactory.lookupCommandService().executeCommand((ICommand)saveCommand);
                ITVerbund verbund = saveCommand.getNewElement();
                verbund.setParent((CnATreeElement)CnAElementFactory.this.loadedModel);
                return verbund;
            }
        });
        this.elementbuilders.put("org", new DefaultElementBuilder("org"));
        this.elementbuilders.put("assetgroup", new DefaultElementBuilder("assetgroup"));
        this.elementbuilders.put("asset", new DefaultElementBuilder("asset"));
        this.elementbuilders.put("persongroup", new DefaultElementBuilder("persongroup"));
        this.elementbuilders.put("person-iso", new DefaultElementBuilder("person-iso"));
        this.elementbuilders.put("auditgroup", new DefaultElementBuilder("auditgroup"));
        this.elementbuilders.put("audit", new DefaultElementBuilder("audit"));
        this.elementbuilders.put("controlgroup", new DefaultElementBuilder("controlgroup"));
        this.elementbuilders.put("control", new DefaultElementBuilder("control"));
        this.elementbuilders.put("exceptiongroup", new DefaultElementBuilder("exceptiongroup"));
        this.elementbuilders.put("exception", new DefaultElementBuilder("exception"));
        this.elementbuilders.put("requirementgroup", new DefaultElementBuilder("requirementgroup"));
        this.elementbuilders.put("requirement", new DefaultElementBuilder("requirement"));
        this.elementbuilders.put("incident", new DefaultElementBuilder("incident"));
        this.elementbuilders.put("incident_group", new DefaultElementBuilder("incident_group"));
        this.elementbuilders.put("incident_scenario", new DefaultElementBuilder("incident_scenario"));
        this.elementbuilders.put("incident_scenario_group", new DefaultElementBuilder("incident_scenario_group"));
        this.elementbuilders.put("response", new DefaultElementBuilder("response"));
        this.elementbuilders.put("response_group", new DefaultElementBuilder("response_group"));
        this.elementbuilders.put("threat", new DefaultElementBuilder("threat"));
        this.elementbuilders.put("threat_group", new DefaultElementBuilder("threat_group"));
        this.elementbuilders.put("vulnerability", new DefaultElementBuilder("vulnerability"));
        this.elementbuilders.put("vulnerability_group", new DefaultElementBuilder("vulnerability_group"));
        this.elementbuilders.put("document_group", new DefaultElementBuilder("document_group"));
        this.elementbuilders.put("document", new DefaultElementBuilder("document"));
        this.elementbuilders.put("interview_group", new DefaultElementBuilder("interview_group"));
        this.elementbuilders.put("interview", new DefaultElementBuilder("interview"));
        this.elementbuilders.put("finding_group", new DefaultElementBuilder("finding_group"));
        this.elementbuilders.put("finding", new DefaultElementBuilder("finding"));
        this.elementbuilders.put("evidence_group", new DefaultElementBuilder("evidence_group"));
        this.elementbuilders.put("evidence", new DefaultElementBuilder("evidence"));
        this.elementbuilders.put("process_group", new DefaultElementBuilder("process_group"));
        this.elementbuilders.put("process", new DefaultElementBuilder("process"));
        this.elementbuilders.put("record_group", new DefaultElementBuilder("record_group"));
        this.elementbuilders.put("record", new DefaultElementBuilder("record"));
        this.elementbuilders.put("samt_topic", new DefaultElementBuilder("samt_topic"));
        this.elementbuilders.put("bp_itnetwork", new ElementBuilder(){

            public CnATreeElement build(CnATreeElement container, BuildInput input) throws CommandException {
                logger.debug((Object)("Creating new ItNetwork in " + container));
                boolean createChildren = true;
                if (input != null) {
                    createChildren = (Boolean)input.getInput();
                }
                CreateITNetwork saveCommand = new CreateITNetwork(container, createChildren);
                saveCommand = (CreateITNetwork)ServiceFactory.lookupCommandService().executeCommand((ICommand)saveCommand);
                ItNetwork itnetwork = (ItNetwork)saveCommand.getNewElement();
                itnetwork.setParent((CnATreeElement)CnAElementFactory.this.boModel);
                return itnetwork;
            }
        });
        this.elementbuilders.put("bp_application", new DefaultElementBuilder("bp_application"));
        this.elementbuilders.put("bp_person", new DefaultElementBuilder("bp_person"));
        this.elementbuilders.put("bp_requirement", new DefaultElementBuilder("bp_requirement"));
        this.elementbuilders.put("bp_threat", new DefaultElementBuilder("bp_threat"));
        this.elementbuilders.put("bp_businessprocess", new DefaultElementBuilder("bp_businessprocess"));
        this.elementbuilders.put("bp_device", new DefaultElementBuilder("bp_device"));
        this.elementbuilders.put("bp_icssystem", new DefaultElementBuilder("bp_icssystem"));
        this.elementbuilders.put("bp_itsystem", new DefaultElementBuilder("bp_itsystem"));
        this.elementbuilders.put("bp_network", new DefaultElementBuilder("bp_network"));
        this.elementbuilders.put("bp_room", new DefaultElementBuilder("bp_room"));
        this.elementbuilders.put("bp_safeguard", new DefaultElementBuilder("bp_safeguard"));
        this.elementbuilders.put("bp_document", new DefaultElementBuilder("bp_document"));
        this.elementbuilders.put("bp_incident", new DefaultElementBuilder("bp_incident"));
        this.elementbuilders.put("bp_record", new DefaultElementBuilder("bp_record"));
        this.elementbuilders.put("bp_application_group", new DefaultElementBuilder("bp_application_group"));
        this.elementbuilders.put("bp_person_group", new DefaultElementBuilder("bp_person_group"));
        this.elementbuilders.put("bp_requirement_group", new DefaultElementBuilder("bp_requirement_group"));
        this.elementbuilders.put("bp_threat_group", new DefaultElementBuilder("bp_threat_group"));
        this.elementbuilders.put("bp_businessprocess_group", new DefaultElementBuilder("bp_businessprocess_group"));
        this.elementbuilders.put("bp_device_group", new DefaultElementBuilder("bp_device_group"));
        this.elementbuilders.put("bp_icssystem_group", new DefaultElementBuilder("bp_icssystem_group"));
        this.elementbuilders.put("bp_itsystem_group", new DefaultElementBuilder("bp_itsystem_group"));
        this.elementbuilders.put("bp_network_group", new DefaultElementBuilder("bp_network_group"));
        this.elementbuilders.put("bp_room_group", new DefaultElementBuilder("bp_room_group"));
        this.elementbuilders.put("bp_safeguard_group", new DefaultElementBuilder("bp_safeguard_group"));
        this.elementbuilders.put("bp_document_group", new DefaultElementBuilder("bp_document_group"));
        this.elementbuilders.put("bp_incident_group", new DefaultElementBuilder("bp_incident_group"));
        this.elementbuilders.put("bp_record_group", new DefaultElementBuilder("bp_record_group"));
    }

    public static CnAElementFactory getInstance() {
        if (instance == null) {
            instance = new CnAElementFactory();
        }
        return instance;
    }

    public CnATreeElement saveNewOrganisation(CnATreeElement container, boolean createChildren, boolean fireUpdates) throws CommandException {
        String title = HitroUtil.getInstance().getTypeFactory().getMessage("org");
        CreateElement saveCommand = new CreateElement(container, Organization.class, title, false, createChildren);
        saveCommand = (CreateElement)this.getCommandService().executeCommand((ICommand)saveCommand);
        CnATreeElement child = saveCommand.getNewElement();
        container.addChild(child);
        child.setParentAndScope(container);
        if (fireUpdates) {
            CnAElementFactory.getModel(child).childAdded(container, child);
            CnAElementFactory.getModel(child).databaseChildAdded(child);
        }
        return child;
    }

    public CnATreeElement saveNewAudit(CnATreeElement container, boolean createChildren, boolean fireUpdates) throws CommandException, CnATreeElementBuildException {
        IElementBuilder builder = this.elementbuilders.get("audit");
        if (builder == null) {
            throw new CnATreeElementBuildException(String.valueOf(Messages.getString("CnAElementFactory.0")) + "audit");
        }
        Object child = builder.build(container, null);
        if (fireUpdates) {
            CnAElementFactory.getModel(child).childAdded(container, child);
            CnAElementFactory.getModel(child).databaseChildAdded(child);
        }
        if (createChildren) {
            CnAElementFactory.getInstance().saveNew((CnATreeElement)child, "assetgroup", null, false);
            CnAElementFactory.getInstance().saveNew((CnATreeElement)child, "controlgroup", null, false);
            CnAElementFactory.getInstance().saveNew((CnATreeElement)child, "persongroup", null, false);
            CnAElementFactory.getInstance().saveNew((CnATreeElement)child, "finding_group", null, false);
            CnAElementFactory.getInstance().saveNew((CnATreeElement)child, "evidence_group", null, false);
            CnAElementFactory.getInstance().saveNew((CnATreeElement)child, "interview_group", null, false);
        }
        return child;
    }

    public CnATreeElement saveNew(CnATreeElement container, String buildableTypeId, BuildInput input, boolean fireUpdates, boolean inheritIcon) throws CnATreeElementBuildException, CommandException {
        IElementBuilder builder = this.elementbuilders.get(buildableTypeId);
        if (builder == null) {
            logger.error((Object)(String.valueOf(Messages.getString("CnAElementFactory.0")) + buildableTypeId));
            throw new CnATreeElementBuildException(String.valueOf(Messages.getString("CnAElementFactory.0")) + buildableTypeId);
        }
        Object child = builder.build(container, input);
        if (inheritIcon) {
            this.inheritIcon(container, (CnATreeElement)child);
        }
        if (fireUpdates) {
            CnAElementFactory.getModel(child).childAdded(container, child);
            CnAElementFactory.getModel(child).databaseChildAdded(child);
        }
        return child;
    }

    private CnATreeElement inheritIcon(CnATreeElement container, CnATreeElement child) throws CommandException {
        String iconPath;
        if (!container.isScope() && !"audit".equals(container.getTypeId()) && (iconPath = container.getIconPath()) != null) {
            child.setIconPath(iconPath);
            Activator.inheritVeriniceContextState();
            UpdateElement updateCommand = new UpdateElement((ITypedElement)child, false, ChangeLogEntry.STATION_ID);
            this.getCommandService().executeCommand((ICommand)updateCommand);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("IconPath of containerElement:\t" + iconPath));
                logger.debug((Object)("IconPath of child (after setter was called):\t" + child.getIconPath()));
            }
        }
        return child;
    }

    public CnATreeElement saveNew(CnATreeElement container, String buildableTypeId, BuildInput input, boolean inheritIcon) throws CommandException, CnATreeElementBuildException {
        return this.saveNew(container, buildableTypeId, input, true, inheritIcon);
    }

    public static BSIModel getLoadedModel() {
        return CnAElementFactory.getInstance().loadedModel;
    }

    public static boolean isModelLoaded() {
        return CnAElementFactory.getInstance().loadedModel != null;
    }

    public boolean ifModelLoaded(Consumer<BSIModel> callback) {
        if (this.loadedModel == null) {
            return false;
        }
        callback.accept(this.loadedModel);
        return true;
    }

    public static boolean isIsoModelLoaded() {
        return CnAElementFactory.getInstance().isoModel != null;
    }

    public boolean ifIsoModelLoaded(Consumer<ISO27KModel> callback) {
        if (this.isoModel == null) {
            return false;
        }
        callback.accept(this.isoModel);
        return true;
    }

    public static boolean isBpModelLoaded() {
        return CnAElementFactory.getInstance().boModel != null;
    }

    public boolean ifBpModelLoaded(Consumer<BpModel> callback) {
        if (this.boModel == null) {
            return false;
        }
        callback.accept(this.boModel);
        return true;
    }

    public static boolean isModernizedBpCatalogLoaded() {
        return CnAElementFactory.getInstance().catalogModel != null;
    }

    public void closeModel() {
        this.dbHome.close();
        this.fireClosed();
        CnAElementFactory.dereferenceModel();
    }

    private static void dereferenceModel() {
        CnAElementFactory.getInstance().loadedModel = null;
    }

    private void fireClosed() {
        for (IModelLoadListener listener : this.listeners) {
            listener.closed(this.loadedModel);
        }
    }

    private void fireLoad() {
        for (IModelLoadListener listener : this.listeners) {
            listener.loaded(this.loadedModel);
        }
    }

    private void fireLoad(ISO27KModel model) {
        for (IModelLoadListener listener : this.listeners) {
            listener.loaded(model);
        }
    }

    private void fireLoad(BpModel model) {
        for (IModelLoadListener listener : this.listeners) {
            listener.loaded(model);
        }
    }

    private void fireLoad(CatalogModel model) {
        for (IModelLoadListener listener : this.listeners) {
            listener.loaded(model);
        }
    }

    public boolean isDbOpen() {
        return this.dbHome != null && this.dbHome.isOpen();
    }

    public static CnATreeElement getModel(CnATreeElement element) {
        Object model = null;
        model = element instanceof ISO27KModel || element instanceof IISO27kElement ? CnAElementFactory.getInstance().getISO27kModel() : (element instanceof BpModel || element instanceof IBpElement ? CnAElementFactory.getInstance().getBpModel() : CnAElementFactory.getLoadedModel());
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISO27KModel getISO27kModel() {
        if (this.isoModel != null) {
            return this.isoModel;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.isoModel == null) {
                this.isoModel = this.loadIsoModel();
                if (this.isoModel == null) {
                    this.createIsoModel();
                }
            }
            return this.isoModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpModel getBpModel() {
        if (this.boModel != null) {
            return this.boModel;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.boModel == null) {
                this.boModel = this.loadBpModel();
                if (this.boModel == null) {
                    this.createBpModel();
                }
            }
        }
        return this.boModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CatalogModel getCatalogModel() {
        if (this.catalogModel != null) {
            return this.catalogModel;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.catalogModel == null) {
                this.catalogModel = this.loadCatalogModel();
                if (this.catalogModel == null) {
                    this.createCatalogModel();
                }
            }
        }
        return this.catalogModel;
    }

    private void createCatalogModel() {
        try {
            CreateCatalogModel command = new CreateCatalogModel();
            command = (CreateCatalogModel)this.getCommandService().executeCommand((ICommand)command);
            this.catalogModel = (CatalogModel)command.getElement();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Catalog Model created");
            }
            if (this.catalogModel != null) {
                this.fireLoad(this.catalogModel);
            }
        }
        catch (CommandException e) {
            logger.error((Object)"Error creating CatalogModel", (Throwable)e);
        }
    }

    private CatalogModel loadCatalogModel() {
        CatalogModel model = null;
        try {
            LoadModel loadModel = new LoadModel(CatalogModel.class);
            loadModel = (LoadModel)this.getCommandService().executeCommand((ICommand)loadModel);
            model = (CatalogModel)loadModel.getModel();
            if (model != null) {
                this.fireLoad(model);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error loading the CatalogModel", (Throwable)e);
            throw new RuntimeException("Error loading the CatalogModel", e);
        }
        return model;
    }

    private ISO27KModel loadIsoModel() {
        ISO27KModel model = null;
        try {
            LoadModel loadModel = new LoadModel(ISO27KModel.class);
            loadModel = (LoadModel)this.getCommandService().executeCommand((ICommand)loadModel);
            model = (ISO27KModel)loadModel.getModel();
            if (model != null) {
                this.fireLoad(model);
            }
        }
        catch (Exception e) {
            logger.error((Object)Messages.getString("CnAElementFactory.1"), (Throwable)e);
            throw new RuntimeException(Messages.getString("CnAElementFactory.1"), e);
        }
        return model;
    }

    private void createIsoModel() {
        try {
            CreateIsoModel command = new CreateIsoModel();
            command = (CreateIsoModel)this.getCommandService().executeCommand((ICommand)command);
            this.isoModel = (ISO27KModel)command.getElement();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"ISO27KModel created");
            }
            if (this.isoModel != null) {
                this.fireLoad(this.isoModel);
            }
        }
        catch (CommandException e) {
            logger.error((Object)Messages.getString("CnAElementFactory.2"), (Throwable)e);
        }
    }

    private BpModel loadBpModel() {
        BpModel model = null;
        try {
            LoadBpModel modelLoadCommand = new LoadBpModel();
            modelLoadCommand = (LoadBpModel)this.getCommandService().executeCommand((ICommand)modelLoadCommand);
            model = modelLoadCommand.getModel();
            if (model != null) {
                this.fireLoad(model);
            }
        }
        catch (CommandException e) {
            logger.error((Object)"Error loading model for modernized ITBP", (Throwable)e);
            throw new RuntimeException("Error loading model for modernized ITBP", e);
        }
        return model;
    }

    private void createBpModel() {
        try {
            CreateBpModel modelCreationCommand = new CreateBpModel();
            modelCreationCommand = (CreateBpModel)this.getCommandService().executeCommand((ICommand)modelCreationCommand);
            this.boModel = (BpModel)modelCreationCommand.getElement();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Model for modernized ITBP created");
            }
            if (this.boModel != null) {
                this.fireLoad(this.boModel);
            }
        }
        catch (CommandException e) {
            logger.error((Object)Messages.getString("CnAElementFactory.2"), (Throwable)e);
        }
    }

    public BSIModel loadOrCreateModel(IProgress monitor) throws MalformedURLException, CommandException, CnATreeElementBuildException {
        if (!this.dbHome.isOpen()) {
            this.dbHome.open(monitor);
        }
        monitor.setTaskName(Messages.getString("CnAElementFactory.3"));
        Activator.checkDbVersion();
        this.loadedModel = this.dbHome.loadModel(monitor);
        if (this.loadedModel != null) {
            this.fireLoad();
            return this.loadedModel;
        }
        logger.debug((Object)"Creating new model in DB.");
        monitor.setTaskName(Messages.getString("CnAElementFactory.4"));
        this.loadedModel = new BSIModel();
        this.createBausteinVorschlaege();
        this.loadedModel = this.dbHome.save(this.loadedModel);
        Activator.checkDbVersion();
        ITVerbund verbund = (ITVerbund)CnAElementFactory.getInstance().saveNew((CnATreeElement)this.loadedModel, "itverbund", null, false);
        this.loadedModel.addChild((CnATreeElement)verbund);
        this.fireLoad();
        return this.loadedModel;
    }

    private void createBausteinVorschlaege() {
        SubtypenZielobjekte mapping = new SubtypenZielobjekte();
        List list = mapping.getMapping();
        UpdateMultipleElements command = new UpdateMultipleElements(list, ChangeLogEntry.STATION_ID, 1);
        try {
            ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        }
        catch (CommandException e) {
            throw new RuntimeCommandException((Throwable)e);
        }
    }

    public void reloadAllModelsFromDatabase() {
        try {
            this.fireClosed();
            this.reloadBsiModelFromDatabasePrivate();
            this.reloadIsoModelFromDatabasePrivate();
            this.reloadBpModelFromDatabasePrivate();
            this.reloadCatalogModelFromDatabasePrivate();
        }
        catch (Exception e) {
            logger.error((Object)Messages.getString("CnAElementFactory.5"), (Throwable)e);
        }
    }

    public void reloadBsiModelFromDatabase() {
        this.fireClosed();
        try {
            this.reloadBsiModelFromDatabasePrivate();
        }
        catch (Exception e) {
            logger.error((Object)"Could not reload BSI (old base protection) model from database", (Throwable)e);
        }
    }

    private void reloadBsiModelFromDatabasePrivate() throws CommandException {
        if (CnAElementFactory.isModelLoaded()) {
            BSIModel newModel = this.dbHome.loadModel(new NullMonitor());
            this.loadedModel.modelReload(newModel);
            this.loadedModel.moveListener(newModel);
            this.loadedModel = newModel;
            this.fireLoad();
        }
    }

    public void reloadIsoModelFromDatabase() {
        this.fireClosed();
        try {
            this.reloadIsoModelFromDatabasePrivate();
        }
        catch (Exception e) {
            logger.error((Object)"Could not reload iso model from database", (Throwable)e);
        }
    }

    private void reloadIsoModelFromDatabasePrivate() {
        if (CnAElementFactory.isIsoModelLoaded()) {
            ISO27KModel newModel = this.loadIsoModel();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"reloadModelFromDatabase, ISO-model loaded");
            }
            this.isoModel.modelReload(newModel);
            this.isoModel.moveListener(newModel);
            this.isoModel = newModel;
            this.fireLoad(this.isoModel);
        }
    }

    public void reloadBpModelFromDatabase() {
        this.fireClosed();
        try {
            this.reloadBpModelFromDatabasePrivate();
        }
        catch (Exception e) {
            logger.error((Object)"Could not reload (renewed) base protection model from database", (Throwable)e);
        }
    }

    private void reloadBpModelFromDatabasePrivate() {
        if (CnAElementFactory.isBpModelLoaded()) {
            BpModel newModel = this.loadBpModel();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"reloadBpModelFromDatabasePrivate, (renewed) base protection model loaded");
            }
            this.boModel.modelReload(newModel);
            this.boModel.moveListener(newModel);
            this.boModel = newModel;
            this.fireLoad(this.boModel);
        }
    }

    public void reloadCatalogModelFromDatabase() {
        this.fireClosed();
        try {
            this.reloadCatalogModelFromDatabasePrivate();
        }
        catch (Exception e) {
            logger.error((Object)"Could not reload catalog model from database", (Throwable)e);
        }
    }

    private void reloadCatalogModelFromDatabasePrivate() {
        if (CnAElementFactory.isModernizedBpCatalogLoaded()) {
            CatalogModel newModel = this.loadCatalogModel();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"reloadCatalogModelFromDatabasePrivate,catalog model loaded");
            }
            this.catalogModel.modelReload(newModel);
            this.catalogModel.moveListener(newModel);
            this.catalogModel = newModel;
            this.fireLoad(this.catalogModel);
        }
    }

    private ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandService();
        }
        return this.commandService;
    }

    private ICommandService createCommandService() {
        try {
            ServiceFactory.openCommandService();
        }
        catch (MalformedURLException e) {
            logger.error((Object)Messages.getString("CnAElementFactory.6"), (Throwable)e);
            throw new RuntimeException(Messages.getString("CnAElementFactory.7"), e);
        }
        this.commandService = ServiceFactory.lookupCommandService();
        return this.commandService;
    }

    public static void databaseChildRemoved(ChangeLogEntry changeLogEntry) {
        CnAElementFactory.getInstance().ifModelLoaded(model -> model.databaseChildRemoved(changeLogEntry));
        CnAElementFactory.getInstance().ifIsoModelLoaded(model -> model.databaseChildRemoved(changeLogEntry));
        CnAElementFactory.getInstance().ifBpModelLoaded(model -> model.databaseChildRemoved(changeLogEntry));
    }

    public static boolean selectionOnlyContainsScopes(IStructuredSelection selection) {
        for (Object selectedEl : selection.toList()) {
            if (!(selectedEl instanceof CnATreeElement)) {
                return false;
            }
            if (((CnATreeElement)selectedEl).isScope()) continue;
            return false;
        }
        return true;
    }

    private final class DefaultElementBuilder
    extends ElementBuilder {
        private final Class<CnATreeElement> elementClass;
        private final String typeId;

        DefaultElementBuilder(String typeId) {
            this.elementClass = CnATypeMapper.getClassFromTypeId((String)typeId);
            this.typeId = typeId;
        }

        public CnATreeElement build(CnATreeElement container, BuildInput input) throws CommandException {
            CnATreeElement child = CnAElementFactory.this.dbHome.save(container, this.elementClass, this.typeId);
            this.init(container, child);
            return child;
        }
    }

    private static abstract class ElementBuilder
    implements IElementBuilder {
        private ElementBuilder() {
        }

        protected void init(CnATreeElement container, CnATreeElement child) {
            container.addChild(child);
            child.setParentAndScope(container);
        }
    }

    private static interface IElementBuilder<T extends CnATreeElement, U> {
        public T build(CnATreeElement var1, BuildInput<U> var2) throws CommandException;
    }
}

