/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.wizards;

import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.wizards.Messages;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.IEntityElement;
import sernet.hui.common.connect.PropertyTypeNameComparator;

public class PropertiesSelectionPage
extends WizardPage {
    private static final Logger LOG = Logger.getLogger(PropertiesSelectionPage.class);
    private static final char DEFAULT_SEPARATOR = ';';
    private char separator = (char)59;
    private String entityName;
    private String entityId;
    private File csvDatei;
    private Table mainTable;
    private TableItem[] items;
    private List<Text> texts;
    private List<CCombo> combos;
    private List<String> propertyIDs;
    private String[] columnHeaders = null;
    private List<List<String>> csvContent = null;
    private Charset charset;

    protected PropertiesSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.PropertiesSelectionPage_0);
        this.setDescription(Messages.PropertiesSelectionPage_1);
        this.setPageComplete(false);
        this.combos = new ArrayList<CCombo>();
        this.propertyIDs = new ArrayList<String>();
        this.texts = new ArrayList<Text>();
        this.csvContent = new ArrayList<List<String>>();
    }

    public void createControl(Composite parent) {
        String[] titles;
        int gdVerticalSpan = 4;
        int mainTableItemHeightFactor = 20;
        int tableColumnDefaultWidth = 225;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Label lab = new Label(container, 0);
        lab.setText(Messages.PropertiesSelectionPage_2);
        lab.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.mainTable = new Table(container, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 4;
        int listHeight = this.mainTable.getItemHeight() * 20;
        Rectangle trim = this.mainTable.computeTrim(0, 0, 0, listHeight);
        gridData.heightHint = trim.height;
        this.mainTable.setLayoutData((Object)gridData);
        this.mainTable.setHeaderVisible(true);
        this.mainTable.setLinesVisible(true);
        String[] stringArray = titles = new String[]{Messages.PropertiesSelectionPage_3, Messages.PropertiesSelectionPage_4};
        int n = titles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            TableColumn column = new TableColumn(this.mainTable, 0);
            column.setText(title);
            column.setWidth(225);
            ++n2;
        }
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void fillTable() throws IOException {
        int count;
        if (!this.propertyIDs.isEmpty()) {
            this.propertyIDs.clear();
        }
        String[] propertyNames = null;
        if (this.entityId != null) {
            Activator.inheritVeriniceContextState();
            EntityType entityType = HitroUtil.getInstance().getTypeFactory().getEntityType(this.entityId);
            ArrayList propertyTypes = new ArrayList(entityType.getAllPropertyTypes());
            Collections.sort(propertyTypes, PropertyTypeNameComparator.getInstance());
            propertyNames = new String[propertyTypes.size()];
            count = 0;
            for (IEntityElement element : propertyTypes) {
                propertyNames[count] = element.getName();
                this.propertyIDs.add(element.getId());
                ++count;
            }
        }
        if (this.items != null) {
            IEntityElement element;
            element = this.items;
            count = ((TableItem[])element).length;
            int propertyTypes = 0;
            while (propertyTypes < count) {
                TableItem item = element[propertyTypes];
                item.dispose();
                ++propertyTypes;
            }
        }
        String[] propertyColumns = this.getFirstLine();
        int i = 1;
        while (i < propertyColumns.length) {
            new TableItem(this.mainTable, 0);
            ++i;
        }
        this.items = this.mainTable.getItems();
        for (CCombo combo : this.combos) {
            combo.dispose();
        }
        for (Text text : this.texts) {
            text.dispose();
        }
        if (!this.combos.isEmpty()) {
            this.combos.clear();
            this.texts.clear();
        }
        i = 0;
        while (i < this.items.length) {
            TableEditor editor = new TableEditor(this.mainTable);
            Text text = new Text((Composite)this.mainTable, 0);
            String currentCsvColumn = propertyColumns[i + 1];
            text.setText(currentCsvColumn);
            text.setEditable(false);
            editor.grabHorizontal = true;
            editor.setEditor((Control)text, this.items[i], 0);
            this.texts.add(text);
            editor = new TableEditor(this.mainTable);
            CCombo combo = new CCombo((Composite)this.mainTable, 0);
            combo.setEditable(false);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertiesSelectionPage.this.setPageComplete(PropertiesSelectionPage.this.validateCCombos());
                }
            });
            combo.setText("");
            boolean itemFound = false;
            int j = 0;
            while (j < propertyNames.length) {
                String propertyName = propertyNames[j];
                combo.add(String.valueOf(propertyName) + " (" + this.propertyIDs.get(j) + ")");
                if (!itemFound && propertyName.equals(currentCsvColumn)) {
                    combo.select(j);
                    itemFound = true;
                }
                ++j;
            }
            this.combos.add(combo);
            if (itemFound) {
                this.setPageComplete(true);
            }
            editor.grabHorizontal = true;
            editor.setEditor((Control)combo, this.items[i], 1);
            ++i;
        }
    }

    private boolean validateCCombos() {
        boolean valid = false;
        try {
            for (CCombo combo : this.combos) {
                if (combo.getSelectionIndex() <= -1) continue;
                valid = true;
                break;
            }
            if (valid) {
                int i = 0;
                while (i < this.combos.size() - 1) {
                    int j = i + 1;
                    while (j < this.combos.size() - 1) {
                        int is = this.combos.get(i).getSelectionIndex();
                        int js = this.combos.get(j).getSelectionIndex();
                        if (is > -1 && js == is) {
                            valid = false;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while validating combo boxes.", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Comco boxes valid = " + valid));
        }
        return valid;
    }

    public List<List<String>> getPropertyTable() throws IOException {
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        String[] spalten = this.getFirstLine();
        int i = 1;
        while (i < spalten.length) {
            ArrayList<String> temp = new ArrayList<String>();
            int index = this.combos.get(i - 1).getSelectionIndex();
            if (index != -1) {
                temp.add(this.propertyIDs.get(index));
                temp.add(spalten[i]);
                table.add(temp);
            }
            ++i;
        }
        return table;
    }

    public void setCSVDatei(File csvDatei) {
        this.csvDatei = csvDatei;
        this.columnHeaders = null;
        this.csvContent.clear();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String[] getFirstLine() throws IOException {
        if (this.columnHeaders == null) {
            this.readFile();
        }
        return (String[])this.columnHeaders.clone();
    }

    public List<List<String>> getContent() throws IOException {
        if (this.csvContent == null) {
            this.readFile();
        }
        return this.csvContent;
    }

    private void readFile() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CSVReader reader = new CSVReaderBuilder((Reader)Files.newBufferedReader(this.csvDatei.toPath(), this.getCharset())).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(this.getSeparator()).build()).build();){
            this.columnHeaders = reader.readNext();
            this.csvContent.clear();
            String[] nextLine = null;
            while ((nextLine = reader.readNext()) != null) {
                this.csvContent.add(Arrays.asList(nextLine));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    protected char getSeparator() {
        return this.separator;
    }

    protected void setSeparator(char separator) {
        this.separator = separator;
    }
}

