/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.wizards;

import de.sernet.sync.data.SyncAttribute;
import de.sernet.sync.data.SyncData;
import de.sernet.sync.data.SyncObject;
import de.sernet.sync.mapping.SyncMapping;
import de.sernet.sync.sync.SyncRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.wizards.EntitySelectionPage;
import sernet.gs.ui.rcp.main.bsi.wizards.Messages;
import sernet.gs.ui.rcp.main.bsi.wizards.PropertiesSelectionPage;

public class ImportCSVWizard
extends Wizard {
    private static final Logger LOG = Logger.getLogger(ImportCSVWizard.class);
    private EntitySelectionPage entityPage;
    private PropertiesSelectionPage propertyPage = new PropertiesSelectionPage(Messages.EntitySelectionPage_0);
    private String sourceId;
    private SyncRequest sr = null;

    public ImportCSVWizard() {
        this.entityPage = new EntitySelectionPage(Messages.PropertiesSelectionPage_0);
    }

    public boolean getInsertState() {
        return this.entityPage.getInsertState();
    }

    public boolean getUpdateState() {
        return this.entityPage.getUpdateState();
    }

    public boolean getDeleteState() {
        return this.entityPage.getDeleteState();
    }

    public SyncRequest getSyncRequest() {
        return this.sr;
    }

    public boolean performFinish() {
        try {
            this.sr = this.createSyncRequest();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while importing CSV data.", (Throwable)e);
            ExceptionUtil.log(e, Messages.ImportCSVWizard_1);
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.entityPage);
        this.addPage((IWizardPage)this.propertyPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.entityPage) {
            try {
                this.propertyPage.setEntityName(this.entityPage.getEntityName());
                this.propertyPage.setEntityId(this.entityPage.getEntityNameId());
                this.propertyPage.setCSVDatei(this.entityPage.getCSVDatei());
                this.setSourceId(this.entityPage.getSourceIdText().getText());
                this.propertyPage.setSeparator(this.entityPage.getSeparatorCombo().getText().charAt(0));
                this.propertyPage.setCharset(Charset.forName(this.entityPage.getCharsetCombo().getText()));
                this.propertyPage.setPageComplete(false);
                String[] firstLine = this.propertyPage.getFirstLine();
                if (firstLine == null || firstLine.length == 0) {
                    String message = NLS.bind((String)Messages.ImportCSVWizard_2, (Object)this.entityPage.getCSVDatei().getPath());
                    LOG.warn((Object)message);
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportCSVWizard_3, (String)message);
                } else if (firstLine[0] == null || !firstLine[0].toLowerCase().contains("ext")) {
                    String message = Messages.ImportCSVWizard_5;
                    LOG.warn((Object)(String.valueOf(message) + " File: " + this.entityPage.getCSVDatei().getPath()));
                    this.entityPage.setWarning(message);
                } else {
                    this.entityPage.setWarning("");
                }
                this.propertyPage.fillTable();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while creating next wizard page.", (Throwable)e);
            }
        }
        return super.getNextPage(page);
    }

    private SyncRequest createSyncRequest() throws IOException {
        String entityName = this.propertyPage.getEntityName();
        SyncRequest sr = new SyncRequest();
        sr.setSourceId(this.getSourceId());
        SyncMapping sm = new SyncMapping();
        sr.setSyncMapping(sm);
        List mots = sm.getMapObjectType();
        SyncMapping.MapObjectType mot = new SyncMapping.MapObjectType();
        mot.setExtId(entityName);
        mot.setIntId(this.entityPage.getEntityNameId());
        LinkedList<String> extIdList = new LinkedList<String>();
        for (List<String> properties : this.propertyPage.getPropertyTable()) {
            String extId;
            String intId = properties.get(0);
            if (!this.isValid(intId, extId = properties.get(1))) continue;
            SyncMapping.MapObjectType.MapAttributeType mat = new SyncMapping.MapObjectType.MapAttributeType();
            mat.setExtId(extId);
            extIdList.add(extId);
            mat.setIntId(intId);
            mot.getMapAttributeType().add(mat);
        }
        mots.add(mot);
        SyncData sd = new SyncData();
        sr.setSyncData(sd);
        String[] columns = this.propertyPage.getFirstLine();
        int i = 0;
        List syncObjects = sd.getSyncObject();
        for (List<String> tableLine : this.propertyPage.getContent()) {
            SyncObject so = new SyncObject();
            so.setExtObjectType(entityName);
            List syncAttributes = so.getSyncAttribute();
            int j = 0;
            for (String tableCell : tableLine) {
                if (j == 0) {
                    so.setExtId(tableCell);
                } else if (extIdList.contains(columns[j])) {
                    SyncAttribute sa = new SyncAttribute();
                    sa.setName(columns[j]);
                    sa.getValue().add(tableCell);
                    syncAttributes.add(sa);
                }
                ++j;
            }
            syncObjects.add(so);
            ++i;
        }
        return sr;
    }

    private boolean isValid(String intId, String extId) {
        return intId != null && extId != null && !intId.trim().isEmpty() && !extId.trim().isEmpty();
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getEntityType() {
        return this.entityPage.getEntityNameId();
    }
}

