/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.wizards;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.gs.service.VeriniceCharset;
import sernet.gs.ui.rcp.main.bsi.wizards.Messages;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.model.common.Domain;
import sernet.verinice.service.commands.CnATypeMapper;

public class EntitySelectionPage
extends WizardPage {
    private static final String[] FILTEREXTEND = new String[]{"*.csv", "*.CSV", "*.*"};
    private static final int NUMBER_OF_COLUMNS_UPPER_GRID = 6;
    private static final int NUMBER_OF_COLUMNS_BOTTOM_GRID = 3;
    private static final int DEFAULT_GRID_DATA_VERTICAL_SPAN = 4;
    private static final int DEFAULT_HORIZONTAL_SPACING = 30;
    private static final int DEFAULT_LIST_HEIGHT_FACTOR = 12;
    private static final int DEFAULT_GRID_DATA_WIDTH = 120;
    private static final int DEFAULT_GRID_DATA_HEIGHT = 15;
    private File csvFile;
    private String entityName = "";
    private Text sourceIdText;
    private Combo separatorCombo;
    private Combo charsetCombo;
    private Text csvText;
    private Text entityText;
    private Label warningLabel;
    private String entityNameId = "";
    private boolean insert;
    private boolean update;
    private boolean delete;

    protected EntitySelectionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.EntitySelectionPage_0);
        this.setDescription(Messages.EntitySelectionPage_1);
        this.setPageComplete(false);
    }

    public void createControl(final Composite parent) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Group idGroup = new Group(container, 0);
        idGroup.setText(Messages.EntitySelectionPage_2);
        gridLayout = new GridLayout(6, false);
        idGroup.setLayout((Layout)gridLayout);
        idGroup.setLayoutData((Object)new GridData(768));
        Label sourceIdLabel = new Label((Composite)idGroup, 16384);
        sourceIdLabel.setText(Messages.EntitySelectionPage_3);
        this.sourceIdText = new Text((Composite)idGroup, 2048);
        this.sourceIdText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Label separatorLabel = new Label((Composite)idGroup, 16384);
        separatorLabel.setText(Messages.EntitySelectionPage_4);
        this.separatorCombo = new Combo((Composite)idGroup, 8);
        this.separatorCombo.add(";");
        this.separatorCombo.add(",");
        this.separatorCombo.select(0);
        this.separatorCombo.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.separatorCombo.pack();
        Label charsetLabel = new Label((Composite)idGroup, 16384);
        charsetLabel.setText(Messages.EntitySelectionPage_7);
        this.charsetCombo = new Combo((Composite)idGroup, 8);
        this.charsetCombo.add(VeriniceCharset.CHARSET_UTF_8.displayName());
        this.charsetCombo.add(VeriniceCharset.CHARSET_ISO_8859_15.displayName());
        this.charsetCombo.add(VeriniceCharset.CHARSET_WINDOWS_1252.displayName());
        this.charsetCombo.select(0);
        Group operationGroup = new Group(container, 0);
        operationGroup.setText(Messages.EntitySelectionPage_8);
        operationGroup.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        operationGroup.setLayout((Layout)gridLayout);
        final Button insertCheck = new Button((Composite)operationGroup, 32);
        insertCheck.setSelection(true);
        this.insert = true;
        insertCheck.setText(Messages.EntitySelectionPage_9);
        insertCheck.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        insertCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EntitySelectionPage.this.insert = insertCheck.getSelection();
                EntitySelectionPage.this.setPageComplete(EntitySelectionPage.this.validateData());
            }
        });
        Label insertText = new Label((Composite)operationGroup, 16384);
        insertText.setText(Messages.EntitySelectionPage_10);
        insertText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        final Button updateCheck = new Button((Composite)operationGroup, 32);
        updateCheck.setText(Messages.EntitySelectionPage_11);
        updateCheck.setSelection(true);
        this.update = true;
        updateCheck.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        updateCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EntitySelectionPage.this.update = updateCheck.getSelection();
                EntitySelectionPage.this.setPageComplete(EntitySelectionPage.this.validateData());
            }
        });
        Label updateText = new Label((Composite)operationGroup, 16384);
        updateText.setText(Messages.EntitySelectionPage_12);
        updateText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        final Button deleteCheck = new Button((Composite)operationGroup, 32);
        deleteCheck.setText(Messages.EntitySelectionPage_13);
        deleteCheck.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        deleteCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EntitySelectionPage.this.delete = deleteCheck.getSelection();
                EntitySelectionPage.this.setPageComplete(EntitySelectionPage.this.validateData());
            }
        });
        Label deleteText = new Label((Composite)operationGroup, 16384);
        deleteText.setText(Messages.EntitySelectionPage_14);
        deleteText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.createTypeSelectionList(container);
        gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 30;
        Composite comp = new Composite(container, 0);
        comp.setLayout((Layout)gridLayout);
        Label selectedEntity = new Label(comp, 0);
        selectedEntity.setText(Messages.EntitySelectionPage_16);
        selectedEntity.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label importedCSV = new Label(comp, 0);
        importedCSV.setText(Messages.EntitySelectionPage_17);
        importedCSV.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.entityText = new Text(comp, 2048);
        this.entityText.setEnabled(false);
        this.entityText.setLayoutData((Object)new GridData(120, 15));
        this.csvText = new Text(comp, 2048);
        this.csvText.setEnabled(false);
        this.csvText.setLayoutData((Object)new GridData(120, 15));
        Button dataBrowse = new Button(comp, 8);
        dataBrowse.setText(Messages.EntitySelectionPage_18);
        dataBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        dataBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntitySelectionPage.this.displayFiles(parent.getShell());
                EntitySelectionPage.this.setPageComplete(EntitySelectionPage.this.validateData());
            }
        });
        this.warningLabel = new Label(comp, 0);
        this.warningLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
    }

    protected void createTypeSelectionList(Composite container) {
        final List list = new List(container, 2564);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 4;
        int listHeight = list.getItemHeight() * 12;
        Rectangle trim = list.computeTrim(0, 0, 0, listHeight);
        gridData.heightHint = trim.height;
        list.setLayoutData((Object)gridData);
        final ArrayList entityNames = new ArrayList();
        HitroUtil.getInstance().getTypeFactory().getAllEntityTypes().stream().filter(EntitySelectionPage::isDomainElement).filter(type -> CnATypeMapper.getDomainFromTypeId((String)type.getId()) != Domain.DATA_PROTECTION).sorted((o1, o2) -> o1.getName().compareTo(o2.getName())).forEach(entityType -> {
            String typeId = entityType.getId();
            Domain domain = CnATypeMapper.getDomainFromTypeId((String)typeId);
            String entityNameWithDomain = String.join((CharSequence)"", entityType.getName(), " (", domain.getLabel(), ": ", typeId, ")");
            list.add(entityNameWithDomain);
            entityNames.add(typeId);
        });
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EntitySelectionPage.this.entityText.setText(list.getItem(list.getSelectionIndex()));
                EntitySelectionPage.this.entityName = list.getItem(list.getSelectionIndex());
                EntitySelectionPage.this.entityNameId = (String)entityNames.get(list.getSelectionIndex());
                EntitySelectionPage.this.setPageComplete(EntitySelectionPage.this.validateData());
            }
        });
    }

    private static boolean isDomainElement(EntityType type) {
        String typeId = type.getId();
        return !"attachment".equals(typeId) && !"configuration".equals(typeId) && !"note".equals(typeId) && !"role".equals(typeId) && !typeId.toLowerCase().endsWith("group");
    }

    public boolean validateData() {
        boolean valid = this.sourceIdText.getText() != null && !this.sourceIdText.getText().isEmpty();
        valid = valid && this.entityName != null && !this.entityName.isEmpty();
        boolean bl = valid = valid && this.csvText.getText() != null && !this.csvText.getText().isEmpty();
        return valid && (this.insert || this.update || this.delete);
    }

    private void displayFiles(Shell shell) {
        File file;
        FileDialog dialog = new FileDialog(shell, 0);
        dialog.setFilterExtensions(FILTEREXTEND);
        String path = dialog.open();
        if (path != null && (file = new File(path)).isFile()) {
            this.csvText.setText(file.getName());
            this.csvFile = file;
            if (this.sourceIdText.getText() == null || this.sourceIdText.getText().isEmpty() || this.sourceIdText.getText().endsWith(".csv")) {
                this.sourceIdText.setText(file.getName());
            }
        }
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityNameId() {
        return this.entityNameId;
    }

    public File getCSVDatei() {
        return this.csvFile;
    }

    public void resetEntitySelectionPage() {
        this.csvText.setText("");
        this.entityText.setText("");
    }

    public boolean getInsertState() {
        return this.insert;
    }

    public boolean getUpdateState() {
        return this.update;
    }

    public boolean getDeleteState() {
        return this.delete;
    }

    protected Text getSourceIdText() {
        return this.sourceIdText;
    }

    public Combo getSeparatorCombo() {
        return this.separatorCombo;
    }

    public Combo getCharsetCombo() {
        return this.charsetCombo;
    }

    public void setWarning(String message) {
        int red = 200;
        boolean green = false;
        boolean blue = false;
        this.warningLabel.setForeground(SWTResourceManager.getColor((int)200, (int)0, (int)0));
        this.warningLabel.setText(message);
    }
}

