/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views.chart;

import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.views.chart.MaturitySpiderChart;
import sernet.gs.ui.rcp.main.bsi.views.chart.Messages;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.service.commands.stats.MassnahmenSummaryHome;

public class SamtProgressChart
extends MaturitySpiderChart {
    private static final float CHART_FOREGROUND_ALPHA = 0.6f;

    @Override
    public JFreeChart createChart(CnATreeElement elmt) {
        if (!(elmt instanceof ControlGroup)) {
            return null;
        }
        super.setElmt((ControlGroup)elmt);
        try {
            return this.createBarChart(this.createBarDataset());
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, Messages.SamtProgressChart_0);
            return null;
        }
    }

    protected JFreeChart createBarChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart3D(null, (String)Messages.SamtProgressChart_1, (String)Messages.SamtProgressChart_2, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.getPlot().setForegroundAlpha(0.6f);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.getRenderer().setSeriesPaint(0, (Paint)ChartColor.LIGHT_RED);
        plot.getRenderer().setSeriesPaint(1, (Paint)ChartColor.LIGHT_GREEN);
        plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        int numUnanswered = dataset.getValue(0, 0).intValue();
        int numAnswered = dataset.getValue(1, 0).intValue();
        int sum = numAnswered + numUnanswered;
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        if (sum == 0) {
            axis.setTickLabelsVisible(false);
        } else {
            int upperBound = sum + (5 - sum % 5);
            axis.setUpperBound((double)upperBound);
        }
        return chart;
    }

    protected CategoryDataset createBarDataset() throws CommandException {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        MassnahmenSummaryHome dao = new MassnahmenSummaryHome();
        Map items = dao.getSamtTopicsProgress(this.getElmt());
        Set entrySet = items.entrySet();
        for (Map.Entry entry : entrySet) {
            dataset.addValue((Number)entry.getValue(), (Comparable)entry.getKey(), (Comparable)((Object)""));
        }
        return dataset;
    }
}

