/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views.chart;

import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.views.chart.MaturitySpiderChart;
import sernet.gs.ui.rcp.main.bsi.views.chart.Messages;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.service.commands.stats.MassnahmenSummaryHome;

public class MaturityBarChart
extends MaturitySpiderChart {
    @Override
    public JFreeChart createChart(CnATreeElement elmt) {
        if (!(elmt instanceof ControlGroup)) {
            return null;
        }
        this.setElmt((ControlGroup)elmt);
        try {
            return this.createBarChart(this.createBarDataset());
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, Messages.MaturityBarChart_0);
            return null;
        }
    }

    protected JFreeChart createBarChart(Object dataset) {
        float plotForegroundAlpha = 0.6f;
        int axisUpperBound = 9;
        JFreeChart chart = ChartFactory.createBarChart3D(null, (String)Messages.MaturityBarChart_1, (String)Messages.MaturityBarChart_2, (CategoryDataset)((CategoryDataset)dataset), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.getPlot().setForegroundAlpha(0.6f);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.getRenderer().setSeriesPaint(0, (Paint)ChartColor.LIGHT_BLUE);
        plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setUpperBound(9.0);
        return chart;
    }

    protected Object createBarDataset() throws CommandException {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        MassnahmenSummaryHome dao = new MassnahmenSummaryHome();
        Map items1 = dao.getControlGroups(this.getElmt());
        Set entrySet = items1.entrySet();
        for (Map.Entry entry : entrySet) {
            dataset.addValue((Number)entry.getValue(), (Comparable)((Object)Messages.MaturityBarChart_3), (Comparable)entry.getKey());
        }
        return dataset;
    }
}

