/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views.chart;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.views.chart.ISelectionChartGenerator;
import sernet.gs.ui.rcp.main.bsi.views.chart.Messages;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.service.commands.crud.LoadCnAElementById;
import sernet.verinice.service.commands.crud.LoadReportElementWithChildren;
import sernet.verinice.service.commands.stats.MassnahmenSummaryHome;

public class ISRSpiderChart
implements ISelectionChartGenerator {
    private ControlGroup elmt;

    protected JFreeChart createSpiderChart(Object dataset) {
        SpiderWebPlot plot = new SpiderWebPlot((CategoryDataset)dataset);
        plot.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        plot.setSeriesPaint(0, (Paint)new Color(0.0f, 1.0f, 0.0f, 1.0f));
        plot.setSeriesPaint(1, (Paint)new Color(1.0f, 1.0f, 0.0f, 1.0f));
        plot.setSeriesPaint(2, (Paint)new Color(1.0f, 0.0f, 0.0f, 1.0f));
        plot.setSeriesPaint(3, (Paint)new Color(0.0f, 0.0f, 0.0f, 1.0f));
        plot.setWebFilled(true);
        JFreeChart chart = new JFreeChart(Messages.ISRSpiderChart_0, TextTitle.DEFAULT_FONT, (Plot)plot, false);
        LegendTitle legend = new LegendTitle((LegendItemSource)plot);
        legend.setPosition(RectangleEdge.BOTTOM);
        chart.addSubtitle((Title)legend);
        return chart;
    }

    protected Object createSpiderDataset() throws CommandException {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        MassnahmenSummaryHome dao = new MassnahmenSummaryHome();
        Map items2 = dao.getControlMaxGroupsISR(this.elmt);
        Set<Map.Entry<String, Double>> entrySet2 = items2.entrySet();
        for (Map.Entry<String, Double> entry : this.sort(entrySet2)) {
            dataset.addValue((Number)entry.getValue(), (Comparable)((Object)Messages.ISRSpiderChart_1), (Comparable)((Object)entry.getKey()));
        }
        Map items4 = dao.getControlGoal2Groups(this.elmt);
        Set<Map.Entry<String, Double>> entrySet4 = items4.entrySet();
        for (Map.Entry<String, Double> entry : this.sort(entrySet4)) {
            dataset.addValue((Number)entry.getValue(), (Comparable)((Object)Messages.ISRSpiderChart_2), (Comparable)((Object)entry.getKey()));
        }
        Map items3 = dao.getControlGoal1Groups(this.elmt);
        Set<Map.Entry<String, Double>> entrySet3 = items3.entrySet();
        for (Map.Entry<String, Double> entry : this.sort(entrySet3)) {
            dataset.addValue((Number)entry.getValue(), (Comparable)((Object)Messages.ISRSpiderChart_3), (Comparable)((Object)entry.getKey()));
        }
        Map items1 = dao.getControlGroupsISR(this.elmt);
        Set<Map.Entry<String, Double>> entrySet = items1.entrySet();
        for (Map.Entry<String, Double> entry : this.sort(entrySet)) {
            dataset.addValue((Number)entry.getValue(), (Comparable)((Object)Messages.ISRSpiderChart_4), (Comparable)((Object)entry.getKey()));
        }
        return dataset;
    }

    private List<Map.Entry<String, Double>> sort(Set<Map.Entry<String, Double>> entrySet) {
        ArrayList<Map.Entry<String, Double>> list = new ArrayList<Map.Entry<String, Double>>();
        list.addAll(entrySet);
        Collections.sort(list, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return list;
    }

    public JFreeChart createChart(Integer rootId) {
        ICommandService commandService = ServiceFactory.lookupCommandService();
        LoadReportElementWithChildren cmd = new LoadReportElementWithChildren("controlgroup", rootId);
        try {
            cmd = (LoadReportElementWithChildren)commandService.executeCommand((ICommand)cmd);
            ControlGroup controlGroup = (ControlGroup)cmd.getResult().iterator().next();
            LoadCnAElementById cmd2 = new LoadCnAElementById("controlgroup", controlGroup.getDbId());
            cmd2 = (LoadCnAElementById)commandService.executeCommand((ICommand)cmd2);
            this.elmt = (ControlGroup)cmd2.getFound();
        }
        catch (CommandException e1) {
            throw new RuntimeCommandException(e1.getCause());
        }
        try {
            return this.createSpiderChart(this.createSpiderDataset());
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, Messages.ISRSpiderChart_5);
            return null;
        }
    }

    public JFreeChart createChart(String rootId) {
        return this.createChart(Integer.parseInt(rootId));
    }

    @Override
    public JFreeChart createChart() {
        return null;
    }

    @Override
    public JFreeChart createChart(CnATreeElement elmt) {
        return null;
    }
}

