/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views.chart;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.jfree.chart.JFreeChart;
import org.jfree.experimental.chart.swt.ChartComposite;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.views.chart.Emptychart;
import sernet.gs.ui.rcp.main.bsi.views.chart.IChartGenerator;
import sernet.gs.ui.rcp.main.bsi.views.chart.ISelectionChartGenerator;
import sernet.gs.ui.rcp.main.bsi.views.chart.MaturityBarChart;
import sernet.gs.ui.rcp.main.bsi.views.chart.MaturitySpiderChart;
import sernet.gs.ui.rcp.main.bsi.views.chart.Messages;
import sernet.gs.ui.rcp.main.bsi.views.chart.SamtProgressChart;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.model.bp.IBpModelListener;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.NullListener;
import sernet.verinice.model.iso27k.IISO27KModelListener;
import sernet.verinice.model.iso27k.ISO27KModel;

public class ChartView
extends ViewPart {
    public static final String ID = "sernet.gs.ui.rcp.main.chartview";
    private static final Logger LOG = Logger.getLogger(ChartView.class);
    private IModelLoadListener loadListener;
    private ChangeListener changeListener;
    private Composite parent;
    private ChartComposite frame;
    private Action chooseBarDiagramAction;
    private IChartGenerator currentChartGenerator;
    private Emptychart emptyChart;
    private MaturitySpiderChart maturitySpiderChart;
    protected SamtProgressChart samtProgressChart;
    private Action chooseMaturityDiagramAction;
    private ISelectionListener selectionListener;
    protected CnATreeElement element = null;
    private Action chooseMaturityBarDiagramAction;
    private MaturityBarChart maturityBarChart;

    public void createPartControl(Composite parent) {
        this.initView(parent);
        this.startInitDataJob();
    }

    private void initView(Composite parent) {
        this.parent = parent;
        this.frame = new ChartComposite(parent, 0, null, true);
        this.createChartGenerators();
        this.createSelectionListeners();
        this.hookSelectionListeners();
        this.hookPageSelection();
        this.createMenus();
        this.setDescription();
        this.currentChartGenerator = this.getDefaultChartGenerator();
    }

    protected void setDescription() {
        this.setContentDescription(Messages.ChartView_0);
    }

    protected synchronized void startInitDataJob() {
        if (CnAElementFactory.isModelLoaded()) {
            JobScheduler.scheduleInitJob(this.createDrawChartJob());
        }
    }

    protected IChartGenerator getDefaultChartGenerator() {
        return this.samtProgressChart;
    }

    private void createChartGenerators() {
        this.emptyChart = new Emptychart();
        this.maturitySpiderChart = new MaturitySpiderChart();
        this.maturityBarChart = new MaturityBarChart();
        this.samtProgressChart = new SamtProgressChart();
    }

    protected void createMenus() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        this.chooseBarDiagramAction = new Action(Messages.ChartView_1, 32){

            public void run() {
                ChartView.this.currentChartGenerator = ChartView.this.samtProgressChart;
                ChartView.this.drawChart();
            }
        };
        this.chooseBarDiagramAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("chart_bar.png"));
        this.chooseMaturityDiagramAction = new Action(Messages.ChartView_7, 32){

            public void run() {
                ChartView.this.currentChartGenerator = ChartView.this.maturitySpiderChart;
                ChartView.this.drawChart();
                ChartView.this.setContentDescription(Messages.ChartView_8);
            }
        };
        this.chooseMaturityDiagramAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("chart_pie.png"));
        this.chooseMaturityBarDiagramAction = new Action(Messages.ChartView_9, 32){

            public void run() {
                ChartView.this.currentChartGenerator = ChartView.this.maturityBarChart;
                ChartView.this.drawChart();
                ChartView.this.setContentDescription(Messages.ChartView_10);
            }
        };
        this.chooseMaturityBarDiagramAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("chart_bar.png"));
        menuManager.add((IAction)this.chooseBarDiagramAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.chooseMaturityDiagramAction);
        menuManager.add((IAction)this.chooseMaturityBarDiagramAction);
        this.fillLocalToolBar();
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.chooseBarDiagramAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.chooseMaturityDiagramAction);
        manager.add((IAction)this.chooseMaturityBarDiagramAction);
    }

    protected synchronized void drawChart() {
        this.createDrawChartJob().schedule();
    }

    private WorkspaceJob createDrawChartJob() {
        return new WorkspaceJob(Messages.ChartView_6){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                Activator.inheritVeriniceContextState();
                if (ChartView.this.parent != null && !ChartView.this.parent.isDisposed() && ChartView.this.frame != null && !ChartView.this.frame.isDisposed()) {
                    JFreeChart chart;
                    CnATreeElement currentElement = null;
                    if (ChartView.this.currentChartGenerator instanceof ISelectionChartGenerator) {
                        currentElement = ChartView.this.getElement();
                        if (currentElement == null) {
                            currentElement = ChartView.this.getDefaultElement();
                        }
                        chart = ((ISelectionChartGenerator)ChartView.this.currentChartGenerator).createChart(currentElement);
                    } else {
                        chart = ChartView.this.currentChartGenerator.createChart();
                    }
                    if (chart != null) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if ((this).ChartView.this.frame.isDisposed()) {
                                        return;
                                    }
                                    (this).ChartView.this.frame.setChart(chart);
                                    (this).ChartView.this.frame.forceRedraw();
                                }
                                catch (Exception e) {
                                    LOG.error((Object)e);
                                }
                            }
                        });
                    }
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void createSelectionListeners() {
        this.loadListener = new IModelLoadListener(){

            @Override
            public void closed(BSIModel model) {
                Display.getDefault().asyncExec(() -> {
                    ChartView.this.currentChartGenerator = ChartView.this.emptyChart;
                    ChartView.this.drawChart();
                });
            }

            @Override
            public void loaded(BSIModel model) {
                Display.getDefault().asyncExec(() -> CnAElementFactory.getLoadedModel().addBSIModelListener((IBSIModelListener)ChartView.this.changeListener));
            }

            @Override
            public void loaded(ISO27KModel model) {
                Display.getDefault().asyncExec(() -> {
                    CnAElementFactory.getInstance().getISO27kModel().addISO27KModelListener((IISO27KModelListener)ChartView.this.changeListener);
                    ChartView.this.currentChartGenerator = ChartView.this.getDefaultChartGenerator();
                    ChartView.this.drawChart();
                });
            }

            @Override
            public void loaded(BpModel model) {
                Display.getDefault().asyncExec(() -> CnAElementFactory.getInstance().getBpModel().addModITBOModelListener((IBpModelListener)ChartView.this.changeListener));
            }

            @Override
            public void loaded(CatalogModel model) {
            }
        };
        this.changeListener = this.createChangeListener();
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener();
    }

    private void hookPageSelection() {
        this.selectionListener = this::pageSelectionChanged;
        this.getSite().getPage().addPostSelectionListener(this.selectionListener);
    }

    protected synchronized void pageSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object firstSelection = ((IStructuredSelection)selection).getFirstElement();
        CnATreeElement selectedElement = (CnATreeElement)firstSelection;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Selection changed, selected element: " + selectedElement));
        }
        if (firstSelection instanceof CnATreeElement) {
            if (this.element != null && selectedElement == this.element) {
                return;
            }
            this.element = selectedElement;
            this.drawChart();
        }
    }

    protected void hookSelectionListeners() {
        CnAElementFactory.getInstance().addLoadListener(this.loadListener);
        if (CnAElementFactory.getLoadedModel() != null) {
            CnAElementFactory.getLoadedModel().addBSIModelListener((IBSIModelListener)this.changeListener);
        }
    }

    public void dispose() {
        this.getSite().getPage().removePostSelectionListener(this.selectionListener);
        CnAElementFactory.getInstance().removeLoadListener(this.loadListener);
        if (CnAElementFactory.getLoadedModel() != null) {
            CnAElementFactory.getLoadedModel().removeBSIModelListener((IBSIModelListener)this.changeListener);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Disposing chart view " + (Object)((Object)this)));
        }
    }

    public void setFocus() {
        this.frame.setFocus();
    }

    protected CnATreeElement getElement() {
        return this.element;
    }

    protected CnATreeElement getDefaultElement() {
        return null;
    }

    protected class ChangeListener
    extends NullListener
    implements IBSIModelListener,
    IISO27KModelListener,
    IBpModelListener {
        protected ChangeListener() {
        }

        public void modelRefresh(Object source) {
            ChartView.this.drawChart();
        }

        public void modelReload(BpModel newModel) {
        }

        public void modelReload(ISO27KModel newModel) {
        }
    }
}

