/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.dialogs.TodoFilterDialog;
import sernet.gs.ui.rcp.main.bsi.filter.AuditDurchFilter;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenSiegelFilter;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenUmsetzungFilter;
import sernet.gs.ui.rcp.main.bsi.filter.ZielobjektPropertyFilter;
import sernet.gs.ui.rcp.main.bsi.views.GenericMassnahmenView;

public class AuditViewFilterAction
extends Action {
    private Shell shell;
    private GenericMassnahmenView view;
    private MassnahmenUmsetzungFilter umsetzungFilter;
    private MassnahmenSiegelFilter siegelFilter;
    private AuditDurchFilter umsetzungDurchFilter;
    private ZielobjektPropertyFilter zielobjektFilter;

    public AuditViewFilterAction(GenericMassnahmenView view, StructuredViewer viewer, String title, MassnahmenUmsetzungFilter filter1, MassnahmenSiegelFilter filter2) {
        super(title);
        this.view = view;
        this.shell = viewer.getControl().getShell();
        this.umsetzungFilter = filter1;
        this.siegelFilter = filter2;
        this.umsetzungDurchFilter = new AuditDurchFilter(viewer);
        this.zielobjektFilter = new ZielobjektPropertyFilter(viewer);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("filter_tsk.gif"));
    }

    public void run() {
        TodoFilterDialog dialog = new TodoFilterDialog(this.shell, this.umsetzungFilter.getUmsetzungPattern(), this.siegelFilter.getPattern(), this.umsetzungDurchFilter.getPattern(), this.zielobjektFilter.getPattern());
        if (dialog.open() != 0) {
            return;
        }
        this.umsetzungFilter.setUmsetzungPattern(dialog.getUmsetzungSelection());
        this.siegelFilter.setPattern(dialog.getSiegelSelection());
        this.umsetzungDurchFilter.setPattern(dialog.getUmsetzungDurch());
        this.zielobjektFilter.setPattern(dialog.getZielobjekt());
        this.view.setLoadBlockNumber(0);
        this.view.getLoadMoreAction().setEnabled(true);
        this.view.reloadMeasures();
    }
}

