/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenSiegelFilter;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenUmsetzungFilter;
import sernet.gs.ui.rcp.main.bsi.views.CnAImageProvider;
import sernet.gs.ui.rcp.main.bsi.views.GenericMassnahmenView;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.bsi.views.actions.TodoViewFilterAction;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.verinice.model.bpm.TodoViewItem;

public class TodoView
extends GenericMassnahmenView {
    public static final String ID = "sernet.gs.ui.rcp.main.bsi.views.todoview";
    private GenericMassnahmenView.TableSorter tableSorter = new GenericMassnahmenView.TableSorter();

    @Override
    protected void createPartControlImpl(Composite parent) {
        Table table = this.getViewer().getTable();
        int iconColumnWidth = 25;
        int dateColumnWidth = 200;
        int bearbeiterColumnWidth = 100;
        int siegelColumnWidth = 20;
        int zielColumnWidth = 150;
        int titleColumnWidth = 250;
        this.iconColumn = new TableColumn(table, 16384);
        this.iconColumn.setText(" ");
        this.iconColumn.setWidth(25);
        this.iconColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.iconColumn, 0));
        this.dateColumn = new TableColumn(table, 16384);
        this.dateColumn.setText(Messages.TodoView_8);
        this.dateColumn.setWidth(200);
        this.dateColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.dateColumn, 1));
        this.bearbeiterColumn = new TableColumn(table, 16384);
        this.bearbeiterColumn.setText(Messages.TodoView_9);
        this.bearbeiterColumn.setWidth(100);
        this.bearbeiterColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.bearbeiterColumn, 2));
        this.siegelColumn = new TableColumn(table, 16384);
        this.siegelColumn.setText(Messages.TodoView_10);
        this.siegelColumn.setWidth(20);
        this.siegelColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.siegelColumn, 3));
        this.zielColumn = new TableColumn(table, 16384);
        this.zielColumn.setText(Messages.TodoView_11);
        this.zielColumn.setWidth(150);
        this.zielColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.zielColumn, 4));
        this.titleColumn = new TableColumn(table, 16384);
        this.titleColumn.setText(Messages.TodoView_12);
        this.titleColumn.setWidth(250);
        this.titleColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.titleColumn, 5));
        this.getViewer().setColumnProperties(new String[]{"_icon", "_date", "_bearbeiter", "_siegel", "_ziel", "_title"});
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    @Override
    protected Action createFilterAction(MassnahmenUmsetzungFilter umsetzungFilter, MassnahmenSiegelFilter siegelFilter) {
        return new TodoViewFilterAction(this, (StructuredViewer)this.getViewer(), Messages.TodoView_2, umsetzungFilter, siegelFilter);
    }

    @Override
    protected String[] getUmsetzungPattern() {
        return new String[]{"mnums_umsetzung_nein", "mnums_umsetzung_teilweise", "mnums_umsetzung_unbearbeitet"};
    }

    @Override
    protected String getMeasureLoadJobLabel() {
        return Messages.TodoView_13;
    }

    @Override
    protected ILabelProvider createLabelProvider() {
        return new TodoLabelProvider();
    }

    @Override
    protected String getMeasureLoadPlaceholderLabel() {
        return Messages.TodoView_14;
    }

    @Override
    protected GenericMassnahmenView.TableSorter createSorter() {
        return this.tableSorter;
    }

    @Override
    protected String getTaskErrorLabel() {
        return Messages.TodoView_15;
    }

    @Override
    protected String getMeasureLoadTaskLabel() {
        return Messages.TodoView_14;
    }

    @Override
    protected String getSortByProperty() {
        return "mnums_umsetzungbis";
    }

    @Override
    protected String getDateProperty() {
        return "mnums_umsetzungbis";
    }

    @Override
    public String getRightID() {
        return "todo";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    private static class TodoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy, EE");

        private TodoLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof PlaceHolder) {
                return null;
            }
            TodoViewItem mn = (TodoViewItem)element;
            if (columnIndex == 0) {
                return CnAImageProvider.getImage(mn);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            int fullTextColumnIndex = 5;
            if (element instanceof PlaceHolder) {
                PlaceHolder ph = (PlaceHolder)element;
                if (columnIndex == 5) {
                    return ph.getTitle();
                }
                if (columnIndex > 0) {
                    return ph.getTitleShort();
                }
                return "";
            }
            TodoViewItem mn = (TodoViewItem)element;
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    Date date = mn.getUmsetzungBis();
                    if (date == null) {
                        return Messages.TodoView_3;
                    }
                    return this.dateFormat.format(date);
                }
                case 2: {
                    return mn.getUmsetzungDurch();
                }
                case 3: {
                    return "" + mn.getStufe();
                }
                case 4: {
                    return mn.getParentTitle();
                }
                case 5: {
                    return mn.getTitle();
                }
            }
            return "";
        }
    }
}

