/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.LoadElementById;

public class ThreadSafeViewerUpdate {
    private static final Logger LOG = Logger.getLogger(ThreadSafeViewerUpdate.class);
    private TreeViewer viewer;

    public ThreadSafeViewerUpdate(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void add(final Object parent, final Object child) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.viewer.add(parent, child);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ThreadSafeViewerUpdate.this.viewer.add(parent, child);
                }
            });
        }
    }

    public void refresh(final Object child) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.viewer.refresh(child);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ThreadSafeViewerUpdate.this.viewer.refresh(child);
                }
            });
        }
    }

    public void remove(final Object child) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.viewer.remove(child);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ThreadSafeViewerUpdate.this.viewer.remove(child);
                }
            });
        }
    }

    public void refresh() {
        if (Display.getCurrent() != null) {
            this.viewer.refresh();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ThreadSafeViewerUpdate.this.viewer != null) {
                        ThreadSafeViewerUpdate.this.viewer.refresh();
                    }
                }
            });
        }
    }

    public void reveal(final Object child) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            if (!(child instanceof MassnahmenUmsetzung)) {
                this.viewer.reveal(child);
            }
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!(child instanceof MassnahmenUmsetzung)) {
                    ThreadSafeViewerUpdate.this.viewer.reveal(child);
                }
            }
        });
    }

    public void setInput(Object newModel) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        final Object newInput = this.getNewInput(newModel);
        if (Display.getCurrent() != null) {
            this.viewer.setInput(newInput);
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ThreadSafeViewerUpdate.this.viewer.setInput(newInput);
            }
        });
    }

    private Object getNewInput(Object newModel) {
        Object returnValue = newModel;
        Object oldInput = this.viewer.getInput();
        if (oldInput != null && !oldInput.getClass().equals(newModel.getClass()) && oldInput instanceof CnATreeElement) {
            CnATreeElement element = (CnATreeElement)oldInput;
            RetrieveInfo ri = new RetrieveInfo();
            ri.setProperties(true).setPermissions(true).setParent(true).setChildren(true).setSiblings(true);
            LoadElementById loadByUuid = new LoadElementById(element.getDbId(), ri);
            try {
                Activator.inheritVeriniceContextState();
                loadByUuid = (LoadElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)loadByUuid);
                element = loadByUuid.getElement();
                if (element.getParent() != null) {
                    element.getParent().setParent(null);
                }
                returnValue = element;
            }
            catch (CommandException e) {
                LOG.error((Object)"Error while reloading tree root", (Throwable)e);
            }
        }
        return returnValue;
    }
}

