/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import org.apache.log4j.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;

public class SerializeBrowserLoadingListener
implements ProgressListener {
    private static final Logger LOG = Logger.getLogger(SerializeBrowserLoadingListener.class);
    private Browser browser;
    private boolean isLoading = false;
    private String html;

    public SerializeBrowserLoadingListener(Browser browser) {
        this.browser = browser;
    }

    public void changed(ProgressEvent event) {
    }

    public void completed(ProgressEvent event) {
        this.isLoading = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Loading completed.");
        }
        if (this.html != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Browser will now render saved HTML...");
            }
            this.setText(this.html);
            this.html = null;
        }
    }

    public void setText(String text) {
        if (!this.isLoading) {
            this.isLoading = true;
            try {
                this.browser.setText(text);
            }
            catch (RuntimeException e) {
                this.isLoading = false;
                throw e;
            }
            catch (Exception e) {
                this.isLoading = false;
                throw new RuntimeException(e);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Browser is busy, HTML is saved and rendered later.");
            }
            this.html = text;
        }
    }
}

