/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.Collections;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import sernet.gs.ui.rcp.main.bsi.views.IRelationTable;
import sernet.gs.ui.rcp.main.bsi.views.RelationTableViewer;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.ITypedElement;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.service.commands.UpdateElement;

public class RiskTreatmentEditingSupport
extends EditingSupport {
    private static final Logger LOG = Logger.getLogger(RiskTreatmentEditingSupport.class);
    private static final String[] RISK_TREATMENT_LABELS;
    private IRelationTable view;
    private TableViewer viewer;
    private ICommandService commandService;

    static {
        LinkedList riskTreatmentLabelList = new LinkedList(CnALink.riskTreatmentLabels.values());
        Collections.sort(riskTreatmentLabelList);
        RISK_TREATMENT_LABELS = riskTreatmentLabelList.toArray(new String[riskTreatmentLabelList.size()]);
    }

    public RiskTreatmentEditingSupport(IRelationTable view, TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.view = view;
        this.viewer = viewer;
    }

    protected boolean canEdit(Object element) {
        boolean canEdit = element instanceof CnALink;
        if (canEdit) {
            CnALink link = (CnALink)element;
            canEdit = RelationTableViewer.isAssetAndSzenario(link);
        }
        return canEdit;
    }

    protected CellEditor getCellEditor(Object element) {
        if (!(element instanceof CnALink)) {
            return null;
        }
        ComboBoxCellEditor cellEditor = new ComboBoxCellEditor((Composite)this.viewer.getTable(), RISK_TREATMENT_LABELS, 8);
        cellEditor.setActivationStyle(1);
        return cellEditor;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof CnALink)) {
            return null;
        }
        CnALink cnaLink = (CnALink)element;
        CnALink.RiskTreatment riskTreatmentValue = cnaLink.getRiskTreatment();
        return this.getIndexOfRiskTreatment(riskTreatmentValue);
    }

    public int getIndexOfRiskTreatment(CnALink.RiskTreatment riskTreatment) {
        if (riskTreatment == null) {
            riskTreatment = CnALink.RiskTreatment.UNEDITED;
        }
        int i = 0;
        int index = -1;
        String selectedLabel = (String)CnALink.riskTreatmentLabels.get(riskTreatment.name());
        String[] stringArray = RISK_TREATMENT_LABELS;
        int n = RISK_TREATMENT_LABELS.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            if (selectedLabel.equals(label)) {
                index = i;
                break;
            }
            ++i;
            ++n2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Index of selected risk treatment is: " + index));
        }
        return index;
    }

    protected void setValue(Object element, Object selectedIndex) {
        try {
            if (!(element instanceof CnALink)) {
                return;
            }
            CnALink cnaLink = (CnALink)element;
            String selectedLabel = RISK_TREATMENT_LABELS[(Integer)selectedIndex];
            this.selectRiskTreatment(cnaLink, selectedLabel);
            CnALink newLink = this.updateLink(cnaLink);
            CnAElementFactory.getModel(cnaLink.getDependant()).linkChanged(cnaLink, newLink, (Object)this.view);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Risk treatment of cnalink saved: " + newLink.getRiskTreatment()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while setting risk treatment.", (Throwable)e);
        }
    }

    public void selectRiskTreatment(CnALink cnaLink, String selectedLabel) {
        for (String key : CnALink.riskTreatmentLabels.keySet()) {
            if (!selectedLabel.equals(CnALink.riskTreatmentLabels.get(key))) continue;
            cnaLink.setRiskTreatment(CnALink.RiskTreatment.valueOf((String)key));
            break;
        }
    }

    public CnALink updateLink(CnALink cnaLink) throws CommandException {
        UpdateElement command = new UpdateElement((ITypedElement)cnaLink, true, ChangeLogEntry.STATION_ID);
        command = (UpdateElement)this.getCommandService().executeCommand((ICommand)command);
        return (CnALink)command.getElement();
    }

    private ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = ServiceFactory.lookupCommandService();
        }
        return this.commandService;
    }
}

