/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.views.CnAImageProvider;
import sernet.gs.ui.rcp.main.bsi.views.IRelationTable;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.bsi.views.RelationTableViewer;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.HuiRelation;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.CnATreeElementLabelGenerator;
import sernet.verinice.rcp.ElementTitleCache;

public class RelationViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final Logger log = Logger.getLogger(RelationViewLabelProvider.class);
    private IRelationTable view;

    public RelationViewLabelProvider(IRelationTable view) {
        this.view = view;
    }

    private static String getRisk(CnALink link, String col) {
        String riskValue;
        switch (col) {
            case "_riskc": {
                riskValue = RelationViewLabelProvider.riskValueToString(link.getRiskConfidentiality());
                break;
            }
            case "_riskc_controls": {
                riskValue = RelationViewLabelProvider.riskValueToString(link.getRiskConfidentialityWithControls());
                break;
            }
            case "_riski": {
                riskValue = RelationViewLabelProvider.riskValueToString(link.getRiskIntegrity());
                break;
            }
            case "_riski_controls": {
                riskValue = RelationViewLabelProvider.riskValueToString(link.getRiskIntegrityWithControls());
                break;
            }
            case "_riska": {
                riskValue = RelationViewLabelProvider.riskValueToString(link.getRiskAvailability());
                break;
            }
            case "_riska_controls": {
                riskValue = RelationViewLabelProvider.riskValueToString(link.getRiskAvailabilityWithControls());
                break;
            }
            case "_risk_treatment": {
                if (link.getRiskTreatment() != null) {
                    riskValue = (String)CnALink.riskTreatmentLabels.get(link.getRiskTreatment().name());
                    break;
                }
                if (RelationTableViewer.isAssetAndSzenario(link)) {
                    riskValue = (String)CnALink.riskTreatmentLabels.get(CnALink.RiskTreatment.UNEDITED.name());
                    break;
                }
                riskValue = "";
                break;
            }
            default: {
                riskValue = "";
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Risk values for column: " + col + " is: " + riskValue));
        }
        return riskValue;
    }

    private static String riskValueToString(Integer value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public String getColumnText(Object obj, int index) {
        if (obj instanceof PlaceHolder) {
            if (index != 1) {
                return "";
            }
            PlaceHolder pl = (PlaceHolder)obj;
            return pl.getTitle();
        }
        CnALink link = (CnALink)obj;
        HuiRelation relation = HitroUtil.getInstance().getTypeFactory().getRelation(link.getRelationId());
        switch (index) {
            case 0: {
                return "";
            }
            case 1: {
                return RelationViewLabelProvider.getRelationLabel(this.view.getInputElmt(), link, relation);
            }
            case 2: {
                return "";
            }
            case 3: {
                RelationViewLabelProvider.replaceLinkEntities(link);
                return RelationViewLabelProvider.getLinkTargetTitleIncludingPotentialIdentifier(this.view.getInputElmt(), link);
            }
            case 4: {
                CnATreeElement target = RelationViewLabelProvider.getElementOnOtherSide(this.view.getInputElmt(), link);
                return ElementTitleCache.getInstance().get(target.getScopeId());
            }
            case 5: {
                return link.getComment();
            }
            case 6: {
                return RelationViewLabelProvider.getRisk(link, "_risk_treatment");
            }
            case 7: {
                return RelationViewLabelProvider.getRisk(link, "_riskc");
            }
            case 8: {
                return RelationViewLabelProvider.getRisk(link, "_riski");
            }
            case 9: {
                return RelationViewLabelProvider.getRisk(link, "_riska");
            }
            case 10: {
                return RelationViewLabelProvider.getRisk(link, "_riskc_controls");
            }
            case 11: {
                return RelationViewLabelProvider.getRisk(link, "_riski_controls");
            }
            case 12: {
                return RelationViewLabelProvider.getRisk(link, "_riska_controls");
            }
        }
        return "";
    }

    private static CnATreeElement getElementOnOtherSide(CnATreeElement elementOnThisSide, CnALink link) {
        CnATreeElement dependency = link.getDependency();
        if (dependency.equals((Object)elementOnThisSide)) {
            return link.getDependant();
        }
        return dependency;
    }

    public static String getLinkTargetTitleIncludingPotentialIdentifier(CnATreeElement linkSource, CnALink link) {
        CnATreeElement linkTarget = RelationViewLabelProvider.getElementOnOtherSide(linkSource, link);
        return CnATreeElementLabelGenerator.getElementTitle((CnATreeElement)linkTarget);
    }

    public static void replaceLinkEntities(CnALink link) {
        CnATreeElement dependantWithProperties = Retriever.checkRetrieveElement((CnATreeElement)link.getDependant());
        CnATreeElement dependencyWithProperties = Retriever.checkRetrieveElement((CnATreeElement)link.getDependency());
        link.getDependant().setEntity(dependantWithProperties.getEntity());
        link.getDependency().setEntity(dependencyWithProperties.getEntity());
    }

    public Image getColumnImage(Object obj, int index) {
        if (obj instanceof PlaceHolder) {
            return null;
        }
        CnALink link = (CnALink)obj;
        switch (index) {
            case 0: {
                if (CnALink.isDownwardLink((CnATreeElement)this.view.getInputElmt(), (CnALink)link)) {
                    return ImageCache.getInstance().getImage("link_down.png");
                }
                return ImageCache.getInstance().getImage("link_up.png");
            }
            case 2: {
                if (CnALink.isDownwardLink((CnATreeElement)this.view.getInputElmt(), (CnALink)link)) {
                    return RelationViewLabelProvider.getObjTypeImage(link.getDependency());
                }
                return RelationViewLabelProvider.getObjTypeImage(link.getDependant());
            }
        }
        return null;
    }

    public static String getRelationLabel(CnATreeElement element, CnALink link, HuiRelation relation) {
        if (CnALink.isDownwardLink((CnATreeElement)element, (CnALink)link)) {
            return relation != null ? relation.getName() : Messages.RelationViewLabelProvider_2;
        }
        return relation != null ? relation.getReversename() : Messages.RelationViewLabelProvider_3;
    }

    private static Image getObjTypeImage(CnATreeElement elmt) {
        return CnAImageProvider.getImage(elmt);
    }

    public CnATreeElement getInputElemt() {
        return this.view.getInputElmt();
    }
}

