/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.views.IRelationTable;
import sernet.gs.ui.rcp.main.common.model.CnATreeElementScopeUtils;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.verinice.bp.rcp.filter.ThreatByProceedingFilterUtil;
import sernet.verinice.model.bp.IBpModelListener;
import sernet.verinice.model.bp.ISecurityLevelProvider;
import sernet.verinice.model.bp.Proceeding;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bp.elements.BpThreat;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.NullListener;
import sernet.verinice.model.iso27k.IISO27KModelListener;
import sernet.verinice.model.iso27k.ISO27KModel;

public class RelationViewContentProvider
extends NullListener
implements IStructuredContentProvider,
IBSIModelListener,
IISO27KModelListener,
IBpModelListener {
    private IRelationTable view;
    private TableViewer viewer;

    public RelationViewContentProvider(IRelationTable view, TableViewer viewer) {
        this.view = view;
        this.viewer = viewer;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput instanceof PlaceHolder) {
            return;
        }
        CnATreeElement inputElmt = (CnATreeElement)newInput;
        this.view.setInputElmt(inputElmt);
        this.viewer.refresh();
    }

    public Object[] getElements(Object obj) {
        CnATreeElement scope;
        if (obj instanceof PlaceHolder) {
            return new Object[]{obj};
        }
        if (this.view == null || this.view.getInputElmt() == null) {
            return new Object[0];
        }
        CnATreeElement inputElement = this.view.getInputElmt();
        Set linksDown = inputElement.getLinksDown();
        Set linksUp = inputElement.getLinksUp();
        if (linksDown.isEmpty() && linksUp.isEmpty()) {
            return new Object[0];
        }
        Stream<CnALink> linksDownStream = linksDown.stream();
        Stream<CnALink> linksUpStream = linksUp.stream();
        boolean filterByProceeding = Activator.getDefault().getPreferenceStore().getBoolean("filter_information_networks_by_proceeding");
        if (filterByProceeding && (scope = CnATreeElementScopeUtils.getScope(inputElement)) instanceof ItNetwork) {
            ItNetwork itNetwork = (ItNetwork)scope;
            Proceeding proceeding = (itNetwork = (ItNetwork)Retriever.checkRetrieveElement((CnATreeElement)itNetwork)).getProceeding();
            if (proceeding != null) {
                linksDownStream = RelationViewContentProvider.filterLinksByProceeding(linksDownStream, CnALink::getDependency, proceeding);
                linksUpStream = RelationViewContentProvider.filterLinksByProceeding(linksUpStream, CnALink::getDependant, proceeding);
            }
        }
        return Stream.concat(linksDownStream, linksUpStream).toArray();
    }

    private static Stream<CnALink> filterLinksByProceeding(Stream<CnALink> links, Function<CnALink, CnATreeElement> elementExtractor, Proceeding proceeding) {
        return links.filter(link -> {
            CnATreeElement element = (CnATreeElement)elementExtractor.apply((CnALink)link);
            if (element instanceof BpThreat) {
                return ThreatByProceedingFilterUtil.showThreatWhenProceedingFilterIsEnabled((BpThreat)element);
            }
            if (element instanceof ISecurityLevelProvider) {
                return proceeding.requires(((ISecurityLevelProvider)element).getSecurityLevel());
            }
            return true;
        });
    }

    public void childChanged(CnATreeElement child) {
        this.view.reloadAll();
    }

    public void databaseChildRemoved(CnATreeElement child) {
        this.view.reloadAll();
    }

    public void linkAdded(CnALink link) {
        this.view.reloadAll();
    }

    public void linkChanged(CnALink old, CnALink link, Object source) {
        if (this.view.equals(source)) {
            this.view.reload(old, link);
        } else {
            this.view.reloadAll();
        }
    }

    public void linkRemoved(CnALink link) {
        this.view.reloadAll();
    }

    public void modelRefresh(Object source) {
        this.view.reloadAll();
    }

    public void modelReload(BSIModel newModel) {
        this.view.reloadAll();
    }

    public void modelReload(ISO27KModel newModel) {
        this.view.reloadAll();
    }

    public void modelReload(BpModel newModel) {
        this.view.reloadAll();
    }
}

