/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.views.IRelationTable;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.bsi.views.RelationComparator;
import sernet.gs.ui.rcp.main.bsi.views.RelationTableViewer;
import sernet.gs.ui.rcp.main.bsi.views.RelationViewContentProvider;
import sernet.gs.ui.rcp.main.bsi.views.RelationViewLabelProvider;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.iso27k.rcp.ILinkedWithEditorView;
import sernet.verinice.iso27k.rcp.LinkWithEditorPartListener;
import sernet.verinice.model.bp.IBpModelListener;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.CnATreeElementLabelGenerator;
import sernet.verinice.model.iso27k.IISO27KModelListener;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.rcp.catalog.CatalogView;
import sernet.verinice.service.commands.task.FindRelationsFor;

public class RelationView
extends RightsEnabledView
implements IRelationTable,
ILinkedWithEditorView {
    public static final String ID = "sernet.gs.ui.rcp.main.bsi.views.RelationView";
    private TableViewer viewer;
    private Action jumpToAction;
    private ISelectionListener selectionListener;
    private CnATreeElement inputElmt;
    private RelationViewContentProvider contentProvider;
    private IModelLoadListener loadListener;
    private IPartListener2 linkWithEditorPartListener = new LinkWithEditorPartListener(this);
    private IPropertyChangeListener proceedingFilterDisabledToggleListener;
    private Action linkWithEditorAction;
    private boolean linkingActive = false;
    private boolean readOnly = false;
    private WorkspaceJob currentlyRunningLoadLinksJob;

    @Override
    public String getRightID() {
        return "relations";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    public void loadLinks(final CnATreeElement elmt) {
        if (!CnAElementHome.getInstance().isOpen() || this.inputElmt == null) {
            return;
        }
        Display.getDefault().syncExec(() -> {
            this.setContentDescription(String.valueOf(Messages.RelationView_9) + " " + CnATreeElementLabelGenerator.getElementTitle((CnATreeElement)elmt));
            this.viewer.setInput((Object)new PlaceHolder(Messages.RelationView_0));
        });
        Optional.ofNullable(this.currentlyRunningLoadLinksJob).ifPresent(Job::cancel);
        this.currentlyRunningLoadLinksJob = new WorkspaceJob(Messages.RelationView_0){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                Activator.inheritVeriniceContextState();
                FindRelationsFor command = new FindRelationsFor(elmt);
                try {
                    command = (FindRelationsFor)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                    CnATreeElement linkElmt = command.getElmt();
                    if (!monitor.isCanceled()) {
                        Display.getDefault().syncExec(() -> {
                            if (!RelationView.this.viewer.getTable().isDisposed()) {
                                RelationView.this.viewer.setInput((Object)linkElmt);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Display.getDefault().syncExec(() -> {
                        if (!RelationView.this.viewer.getTable().isDisposed()) {
                            RelationView.this.viewer.setInput((Object)new PlaceHolder(Messages.RelationView_3));
                        }
                    });
                    ExceptionUtil.log(e, Messages.RelationView_4);
                }
                return Status.OK_STATUS;
            }
        };
        this.currentlyRunningLoadLinksJob.setUser(false);
        this.currentlyRunningLoadLinksJob.schedule();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.viewer = new RelationTableViewer(this, parent, 65538, false);
        this.contentProvider = new RelationViewContentProvider(this, this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        RelationViewLabelProvider relationViewLabelProvider = new RelationViewLabelProvider(this);
        this.viewer.setLabelProvider((IBaseLabelProvider)relationViewLabelProvider);
        this.viewer.setComparator((ViewerComparator)new RelationComparator("_title", "_type_img"));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)1);
        List<RelationTableViewer.PathCellLabelProvider> cellLabelProviders = ((RelationTableViewer)this.viewer).initToolTips(relationViewLabelProvider, parent);
        this.addResizeListener(parent, cellLabelProviders);
        this.toggleLinking(Activator.getDefault().getPreferenceStore().getBoolean("link_to_editor"));
        this.hookModelLoadListener();
        this.proceedingFilterDisabledToggleListener = event -> {
            if ("filter_information_networks_by_proceeding".equals(event.getProperty())) {
                this.viewer.refresh();
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.proceedingFilterDisabledToggleListener);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.hookPageSelection();
    }

    private void addResizeListener(final Composite parent, final List<RelationTableViewer.PathCellLabelProvider> cellLabelProviders) {
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                for (RelationTableViewer.PathCellLabelProvider c : cellLabelProviders) {
                    c.updateShellWidthAndX(parent.getShell().getBounds().width, parent.getShell().getBounds().x);
                }
            }
        });
    }

    private void hookModelLoadListener() {
        this.loadListener = new DefaultModelLoadListener(){
            private AtomicBoolean bsiModelListenerRegistered = new AtomicBoolean(false);
            private AtomicBoolean isoModelListenerRegistered = new AtomicBoolean(false);
            private AtomicBoolean bpModelListenerRegistered = new AtomicBoolean(false);

            @Override
            public void closed(BSIModel model) {
                Display.getDefault().asyncExec(() -> RelationView.this.viewer.setInput((Object)new PlaceHolder("")));
            }

            @Override
            public void loaded(BSIModel model) {
                if (this.bsiModelListenerRegistered.compareAndSet(false, true)) {
                    CnAElementFactory.getInstance().ifModelLoaded(bsiModel -> bsiModel.addBSIModelListener((IBSIModelListener)RelationView.this.contentProvider));
                }
            }

            @Override
            public void loaded(ISO27KModel model) {
                if (this.isoModelListenerRegistered.compareAndSet(false, true)) {
                    CnAElementFactory.getInstance().ifIsoModelLoaded(isoModel -> CnAElementFactory.getInstance().getISO27kModel().addISO27KModelListener((IISO27KModelListener)RelationView.this.contentProvider));
                }
            }

            @Override
            public void loaded(BpModel model) {
                if (this.bpModelListenerRegistered.compareAndSet(false, true)) {
                    CnAElementFactory.getInstance().ifBpModelLoaded(bpModel -> bpModel.addModITBOModelListener((IBpModelListener)RelationView.this.contentProvider));
                }
            }
        };
        CnAElementFactory.getInstance().addLoadListener(this.loadListener);
    }

    protected void removeModelListeners() {
        if (CnAElementFactory.isModelLoaded()) {
            CnAElementFactory.getLoadedModel().removeBSIModelListener((IBSIModelListener)this.contentProvider);
        }
        if (CnAElementFactory.isIsoModelLoaded()) {
            CnAElementFactory.getInstance().getISO27kModel().removeISO27KModelListener((IISO27KModelListener)this.contentProvider);
        }
        if (CnAElementFactory.isBpModelLoaded()) {
            CnAElementFactory.getInstance().getBpModel().removeBpModelListener((IBpModelListener)this.contentProvider);
        }
    }

    public CnATreeElement getInputElement() {
        return this.inputElmt;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillContextMenu);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void hookPageSelection() {
        this.selectionListener = this::pageSelectionChanged;
        this.getSite().getPage().addPostSelectionListener(this.selectionListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addPartListener(this.linkWithEditorPartListener);
    }

    public void dispose() {
        CnAElementFactory.getInstance().removeLoadListener(this.loadListener);
        this.removeModelListeners();
        this.getSite().getPage().removePostSelectionListener(this.selectionListener);
        this.getSite().getPage().removePartListener(this.linkWithEditorPartListener);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.proceedingFilterDisabledToggleListener);
        super.dispose();
    }

    protected void pageSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this) {
            return;
        }
        if (!this.getSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (((IStructuredSelection)selection).size() != 1) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof CnATreeElement) {
            this.readOnly = part instanceof CatalogView;
            this.setNewInput((CnATreeElement)element);
        }
    }

    private void setNewInput(CnATreeElement elmt) {
        this.inputElmt = elmt;
        this.loadLinks(elmt);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.jumpToAction);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.jumpToAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.jumpToAction);
        manager.add((IAction)this.linkWithEditorAction);
    }

    private void makeActions() {
        this.jumpToAction = new Action(){

            public void run() {
                ISelection selection = RelationView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj == null) {
                    return;
                }
                CnALink link = (CnALink)obj;
                if (CnALink.isDownwardLink((CnATreeElement)RelationView.this.inputElmt, (CnALink)link)) {
                    RelationView.this.setNewInput(link.getDependency());
                } else {
                    RelationView.this.setNewInput(link.getDependant());
                }
            }
        };
        this.jumpToAction.setText(Messages.RelationView_10);
        this.jumpToAction.setToolTipText(Messages.RelationView_11);
        this.jumpToAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("arrow_in.png"));
        this.linkWithEditorAction = new Action(Messages.RelationView_2, 2){

            public void run() {
                RelationView.this.toggleLinking(this.isChecked());
            }
        };
        this.linkWithEditorAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("linked.gif"));
        this.linkWithEditorAction.setChecked(this.isLinkingActive());
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(event -> {
            ISelection selection = event.getViewer().getSelection();
            if (!selection.isEmpty()) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                CnALink link = (CnALink)obj;
                if (CnALink.isDownwardLink((CnATreeElement)this.inputElmt, (CnALink)link)) {
                    EditorFactory.getInstance().updateAndOpenObject(link.getDependency(), this.readOnly);
                } else {
                    EditorFactory.getInstance().updateAndOpenObject(link.getDependant(), this.readOnly);
                }
            }
        });
    }

    @Override
    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public void reload(CnALink oldLink, CnALink newLink) {
        newLink.setDependant(oldLink.getDependant());
        newLink.setDependency(oldLink.getDependency());
        boolean removedLinkDown = this.getInputElmt().removeLinkDown(oldLink);
        boolean removedLinkUp = this.getInputElmt().removeLinkUp(oldLink);
        if (removedLinkUp) {
            this.getInputElmt().addLinkUp(newLink);
        }
        if (removedLinkDown) {
            this.getInputElmt().addLinkDown(newLink);
        }
        this.viewer.refresh();
    }

    @Override
    public CnATreeElement getInputElmt() {
        if (this.inputElmt != null) {
            RelationView.checkAndRetrieve(this.inputElmt);
        }
        return this.inputElmt;
    }

    private static void checkAndRetrieve(@NonNull CnATreeElement inputElmt) {
        CnATreeElement elementWithProperties = Retriever.checkRetrieveElement((CnATreeElement)inputElmt);
        inputElmt.setEntity(elementWithProperties.getEntity());
        CnATreeElement elementWithLinks = Retriever.checkRetrieveLinks((CnATreeElement)inputElmt, (boolean)true);
        inputElmt.setLinksDown(elementWithLinks.getLinksDown());
        inputElmt.setLinksUp(elementWithLinks.getLinksUp());
    }

    @Override
    public void setInputElmt(CnATreeElement inputElmt) {
        this.inputElmt = inputElmt;
    }

    @Override
    public void reloadAll() {
        this.loadLinks(this.inputElmt);
    }

    protected void toggleLinking(boolean checked) {
        this.linkingActive = checked;
        if (checked) {
            Optional.ofNullable(this.getSite().getPage().getActiveEditor()).ifPresent(this::editorActivated);
        }
    }

    protected boolean isLinkingActive() {
        return this.linkingActive;
    }

    @Override
    public void editorActivated(IEditorPart activeEditor) {
        if (!this.isLinkingActive() || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        CnATreeElement element = BSIElementEditorInput.extractElement(activeEditor);
        if (element == null) {
            return;
        }
        if (activeEditor.getEditorInput() instanceof BSIElementEditorInput) {
            BSIElementEditorInput editorInput = (BSIElementEditorInput)activeEditor.getEditorInput();
            this.readOnly = editorInput.isReadOnly();
        }
        this.setNewInput(element);
    }
}

