/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.views.IRelationTable;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.HuiRelation;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.CreateLink;
import sernet.verinice.service.commands.crud.ChangeLinkType;

public class RelationTypeEditingSupport
extends EditingSupport {
    private static final Logger log = Logger.getLogger(RelationTypeEditingSupport.class);
    private IRelationTable view;
    private TableViewer viewer;
    private static HUITypeFactory huiTypeFactory = HitroUtil.getInstance().getTypeFactory();

    public RelationTypeEditingSupport(IRelationTable view, TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.view = view;
    }

    protected boolean canEdit(Object element) {
        String targetEntityTypeId;
        if (!(element instanceof CnALink)) {
            return false;
        }
        CnALink cnaLink = (CnALink)element;
        String sourceEntityTypeId = cnaLink.getDependant().getEntityType().getId();
        Set possibleRelations = huiTypeFactory.getPossibleRelations(sourceEntityTypeId, targetEntityTypeId = cnaLink.getDependency().getEntityType().getId());
        return possibleRelations != null && !possibleRelations.isEmpty();
    }

    protected CellEditor getCellEditor(Object element) {
        if (!(element instanceof CnALink)) {
            return null;
        }
        CnALink cnaLink = (CnALink)element;
        String[] linkTypeNames = this.getPossibleLinkTypeNames(cnaLink);
        ComboBoxCellEditor cellEditor = new ComboBoxCellEditor((Composite)this.viewer.getTable(), linkTypeNames, 8);
        cellEditor.setActivationStyle(1);
        return cellEditor;
    }

    private String[] getPossibleLinkTypeNames(CnALink cnaLink) {
        String relationName;
        CnATreeElement relationSource = cnaLink.getDependant();
        CnATreeElement relationTarget = cnaLink.getDependency();
        String relationSourceEntityTypeId = relationSource.getEntityType().getId();
        String relationTargetEntityTypeId = relationTarget.getEntityType().getId();
        Set possibleDownRelations = huiTypeFactory.getPossibleRelations(relationSourceEntityTypeId, relationTargetEntityTypeId);
        Set possibleUpRelations = huiTypeFactory.getPossibleRelations(relationTargetEntityTypeId, relationSourceEntityTypeId);
        HashSet<String> relationNames = new HashSet<String>();
        for (HuiRelation huiRelation : possibleDownRelations) {
            relationName = CnALink.isDownwardLink((CnATreeElement)this.view.getInputElmt(), (CnALink)cnaLink) ? huiRelation.getName() : huiRelation.getReversename();
            relationNames.add(relationName);
        }
        for (HuiRelation huiRelation : possibleUpRelations) {
            relationName = CnALink.isDownwardLink((CnATreeElement)this.view.getInputElmt(), (CnALink)cnaLink) ? huiRelation.getReversename() : huiRelation.getName();
            relationNames.add(relationName);
        }
        String[] currentLinkTypeNames = relationNames.toArray(new String[relationNames.size()]);
        Arrays.sort(currentLinkTypeNames, 0, currentLinkTypeNames.length, new NumericStringComparator());
        return currentLinkTypeNames;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof CnALink)) {
            return null;
        }
        CnALink cnaLink = (CnALink)element;
        String currentName = CnALink.getRelationName((CnATreeElement)this.view.getInputElmt(), (CnALink)cnaLink);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Current name: " + currentName));
        }
        int index = this.getIndex(currentName, this.getPossibleLinkTypeNames(cnaLink));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Index in getValue(): " + index));
        }
        return index;
    }

    private int getIndex(String currentName, String[] currentLinkTypeNames) {
        int i = 0;
        String[] stringArray = currentLinkTypeNames;
        int n = currentLinkTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(currentName)) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    protected void setValue(Object element, Object value) {
        int oldIndex;
        if (!(element instanceof CnALink)) {
            return;
        }
        CnALink cnaLink = (CnALink)element;
        int index = (Integer)value;
        if (index == (oldIndex = ((Integer)this.getValue(cnaLink)).intValue())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Link type unchanged, returning");
            }
            return;
        }
        String[] possibleLinkTypeNames = this.getPossibleLinkTypeNames(cnaLink);
        String linkTypeName = possibleLinkTypeNames[index];
        String linkTypeId = this.getLinkTypeIdForName(cnaLink, linkTypeName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting value " + linkTypeId));
        }
        CnALink newCnaLink = null;
        if (this.changeLinkDirection(cnaLink, linkTypeId)) {
            CreateLink createLinkCommand = new CreateLink(cnaLink.getDependency(), cnaLink.getDependant(), linkTypeId);
            try {
                createLinkCommand = (CreateLink)ServiceFactory.lookupCommandService().executeCommand((ICommand)createLinkCommand);
                newCnaLink = createLinkCommand.getLink();
                if (CnAElementHome.getInstance().isDeleteAllowed(cnaLink)) {
                    CnAElementHome.getInstance().remove(cnaLink);
                    if (CnAElementFactory.isModelLoaded()) {
                        CnAElementFactory.getLoadedModel().linkRemoved(cnaLink);
                        CnAElementFactory.getLoadedModel().linkAdded(newCnaLink);
                    }
                    CnAElementFactory.getInstance().getISO27kModel().linkRemoved(cnaLink);
                    CnAElementFactory.getInstance().getISO27kModel().linkAdded(newCnaLink);
                    CnAElementFactory.getInstance().getBpModel().linkRemoved(cnaLink);
                    CnAElementFactory.getInstance().getBpModel().linkAdded(newCnaLink);
                }
            }
            catch (CommandException e) {
                ExceptionUtil.log(e, Messages.RelationTypeEditingSupport_1);
            }
        } else {
            ChangeLinkType command = new ChangeLinkType(cnaLink, linkTypeId, cnaLink.getComment());
            try {
                command = (ChangeLinkType)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                newCnaLink = command.getLink();
            }
            catch (CommandException e) {
                ExceptionUtil.log(e, Messages.RelationTypeEditingSupport_2);
            }
            CnATreeElement source = cnaLink.getDependant();
            CnATreeElement sourceModel = CnAElementFactory.getModel(source);
            sourceModel.linkChanged(cnaLink, newCnaLink, (Object)this.view);
            if (CnAElementFactory.isModelLoaded()) {
                CnAElementFactory.getLoadedModel().linkChanged(cnaLink, newCnaLink, (Object)this.view);
            }
            CnAElementFactory.getInstance().getISO27kModel().linkChanged(cnaLink, newCnaLink, (Object)this.view);
            CnAElementFactory.getInstance().getBpModel().linkChanged(cnaLink, newCnaLink, (Object)this.view);
        }
    }

    private boolean changeLinkDirection(CnALink link, String linkTypeId) {
        String sourceTypeId = link.getDependency().getEntityType().getId();
        String targetTypeId = link.getDependant().getEntityType().getId();
        Set huiRelations = huiTypeFactory.getPossibleRelations(sourceTypeId, targetTypeId);
        for (HuiRelation huiRelation : huiRelations) {
            if (!huiRelation.getId().equals(linkTypeId)) continue;
            return true;
        }
        return false;
    }

    private String getLinkTypeIdForName(CnALink link, String linkTypeName) {
        String name;
        String id;
        String sourceTypeId = link.getDependant().getEntityType().getId();
        String targetTypeId = link.getDependency().getEntityType().getId();
        Set possibleDownRelations = huiTypeFactory.getPossibleRelations(sourceTypeId, targetTypeId);
        Set possibleUpRelations = huiTypeFactory.getPossibleRelations(targetTypeId, sourceTypeId);
        for (HuiRelation huiRelation : possibleDownRelations) {
            id = huiRelation.getId();
            name = CnALink.isDownwardLink((CnATreeElement)this.view.getInputElmt(), (CnALink)link) ? huiRelation.getName() : huiRelation.getReversename();
            if (!name.equals(linkTypeName)) continue;
            return id;
        }
        for (HuiRelation huiRelation : possibleUpRelations) {
            id = huiRelation.getId();
            name = this.view.getInputElmt().getLinksUp().contains(link) ? huiRelation.getName() : huiRelation.getReversename();
            if (!name.equals(linkTypeName)) continue;
            return id;
        }
        return "";
    }
}

