/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.awt.MouseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.ui.rcp.main.bsi.views.IRelationTable;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.bsi.views.RelationDescriptionEditingSupport;
import sernet.gs.ui.rcp.main.bsi.views.RelationTypeEditingSupport;
import sernet.gs.ui.rcp.main.bsi.views.RelationViewLabelProvider;
import sernet.gs.ui.rcp.main.bsi.views.RiskTreatmentEditingSupport;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.CnATreeElementLabelGenerator;
import sernet.verinice.service.commands.LoadAncestors;

public class RelationTableViewer
extends TableViewer {
    private static final Logger LOG = Logger.getLogger(RelationTableViewer.class);
    private TableViewerColumn col6;
    private TableViewerColumn col7;
    private TableViewerColumn col8;
    private final TableViewerColumn col1;
    private final TableViewerColumn viewerCol2;
    private final TableViewerColumn col4;
    private final IRelationTable view;
    private final TableViewerColumn col3;
    private final TableViewerColumn viewerCol5;
    private final TableViewerColumn col5;
    private TableViewerColumn colRiskTreatment;
    private TableViewerColumn colCWithControls;
    private TableViewerColumn colIWithControls;
    private TableViewerColumn colAWithControls;

    public RelationTableViewer(IRelationTable relationView, Composite parent, int style, boolean showRisk) {
        super(parent, style);
        int defaultColumnWidth = 30;
        int viewerCol2Width = 100;
        int col4Width = 150;
        int col5Width = 100;
        int viewerCol5Width = 250;
        int colWithRiskTreatment = 130;
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this, (int)2);
        this.view = relationView;
        Table table = this.getTable();
        this.col1 = new TableViewerColumn((TableViewer)this, 16384);
        this.col1.getColumn().setText("");
        this.col1.getColumn().setWidth(30);
        this.col1.getColumn().setResizable(false);
        this.viewerCol2 = new TableViewerColumn((TableViewer)this, 16384);
        this.viewerCol2.getColumn().setText(Messages.RelationTableViewer_1);
        this.viewerCol2.getColumn().setWidth(100);
        this.viewerCol2.setEditingSupport((EditingSupport)new RelationTypeEditingSupport(this.view, this));
        this.col3 = new TableViewerColumn((TableViewer)this, 0x1000000);
        this.col3.getColumn().setText("");
        this.col3.getColumn().setWidth(30);
        this.col4 = new TableViewerColumn((TableViewer)this, 16384);
        this.col4.getColumn().setText(Messages.RelationTableViewer_6);
        this.col4.getColumn().setWidth(150);
        this.col5 = new TableViewerColumn((TableViewer)this, 16384);
        this.col5.getColumn().setText(Messages.RelationTableViewer_5);
        this.col5.getColumn().setWidth(100);
        this.viewerCol5 = new TableViewerColumn((TableViewer)this, 16384);
        this.viewerCol5.getColumn().setText(Messages.RelationTableViewer_7);
        this.viewerCol5.getColumn().setWidth(250);
        this.viewerCol5.setEditingSupport((EditingSupport)new RelationDescriptionEditingSupport(this.view, this));
        if (showRisk) {
            this.colRiskTreatment = new TableViewerColumn((TableViewer)this, 16384);
            this.colRiskTreatment.getColumn().setText(Messages.RelationTableViewer_0);
            this.colRiskTreatment.getColumn().setWidth(130);
            this.colRiskTreatment.setEditingSupport((EditingSupport)new RiskTreatmentEditingSupport(this.view, this));
            this.col6 = new TableViewerColumn((TableViewer)this, 16384);
            this.col6.getColumn().setText("C");
            this.col6.getColumn().setWidth(30);
            this.col7 = new TableViewerColumn((TableViewer)this, 16384);
            this.col7.getColumn().setText("I");
            this.col7.getColumn().setWidth(30);
            this.col8 = new TableViewerColumn((TableViewer)this, 16384);
            this.col8.getColumn().setText("A");
            this.col8.getColumn().setWidth(30);
            this.colCWithControls = new TableViewerColumn((TableViewer)this, 16384);
            this.colCWithControls.getColumn().setText(Messages.RelationTableViewer_2);
            this.colCWithControls.getColumn().setWidth(30);
            this.colIWithControls = new TableViewerColumn((TableViewer)this, 16384);
            this.colIWithControls.getColumn().setText(Messages.RelationTableViewer_8);
            this.colIWithControls.getColumn().setWidth(30);
            this.colAWithControls = new TableViewerColumn((TableViewer)this, 16384);
            this.colAWithControls.getColumn().setText(Messages.RelationTableViewer_9);
            this.colAWithControls.getColumn().setWidth(30);
        }
        this.setColumnProperties(new String[]{"_img", "_type", "_type_img", "_scope_id", "_title", "_comment", "_risk_treatment", "_riskc", "_riski", "_riska", "_riskc_controls", "_riski_controls", "_riska_controls"});
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    public List<PathCellLabelProvider> initToolTips(RelationViewLabelProvider relationViewLabelProvider, Composite parent) {
        ArrayList<PathCellLabelProvider> relTblCellLabelProv = new ArrayList<PathCellLabelProvider>();
        PathCellLabelProvider relTableCellProviderCol1 = new PathCellLabelProvider(relationViewLabelProvider, parent, 0);
        relTblCellLabelProv.add(relTableCellProviderCol1);
        this.col1.setLabelProvider((CellLabelProvider)relTableCellProviderCol1);
        PathCellLabelProvider relTableCellProviderCol3 = new PathCellLabelProvider(relationViewLabelProvider, parent, 2);
        relTblCellLabelProv.add(relTableCellProviderCol3);
        this.col3.setLabelProvider((CellLabelProvider)relTableCellProviderCol3);
        PathCellLabelProvider relTableCellProviderCol4 = new PathCellLabelProvider(relationViewLabelProvider, parent, 3);
        relTblCellLabelProv.add(relTableCellProviderCol4);
        this.col4.setLabelProvider((CellLabelProvider)relTableCellProviderCol4);
        if (this.getTable().getColumnCount() > 7) {
            this.col6.setLabelProvider((CellLabelProvider)new InfoCellLabelProvider(relationViewLabelProvider, 7));
            this.col7.setLabelProvider((CellLabelProvider)new InfoCellLabelProvider(relationViewLabelProvider, 8));
            this.col8.setLabelProvider((CellLabelProvider)new InfoCellLabelProvider(relationViewLabelProvider, 9));
            this.colCWithControls.setLabelProvider((CellLabelProvider)new InfoCellLabelProvider(relationViewLabelProvider, 10));
            this.colIWithControls.setLabelProvider((CellLabelProvider)new InfoCellLabelProvider(relationViewLabelProvider, 11));
            this.colAWithControls.setLabelProvider((CellLabelProvider)new InfoCellLabelProvider(relationViewLabelProvider, 12));
        }
        return relTblCellLabelProv;
    }

    public static boolean isAssetAndSzenario(CnALink link) {
        try {
            CnATreeElement dependant = link.getDependant();
            CnATreeElement dependency = link.getDependency();
            return "asset".equals(dependant.getTypeId()) && "incident_scenario".equals(dependency.getTypeId()) || "asset".equals(dependency.getTypeId()) && "incident_scenario".equals(dependant.getTypeId());
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking link.", (Throwable)e);
            return false;
        }
    }

    public static class InfoCellLabelProvider
    extends CellLabelProvider {
        static final Map<Integer, String> TOOLTIPS = new HashMap<Integer, String>();
        RelationViewLabelProvider relationViewLabelProvider;
        private int column;

        static {
            TOOLTIPS.put(7, Messages.RelationTableViewer_C);
            TOOLTIPS.put(8, Messages.RelationTableViewer_I);
            TOOLTIPS.put(9, Messages.RelationTableViewer_A);
            TOOLTIPS.put(10, Messages.RelationTableViewer_C_with_controls);
            TOOLTIPS.put(11, Messages.RelationTableViewer_I_with_controls);
            TOOLTIPS.put(12, Messages.RelationTableViewer_A_with_Controls);
        }

        public InfoCellLabelProvider(RelationViewLabelProvider relationViewLabelProvider, int column) {
            this.relationViewLabelProvider = relationViewLabelProvider;
            this.column = column;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.relationViewLabelProvider.getColumnText(cell.getElement(), this.column));
        }

        public String getToolTipText(Object element) {
            String tooltip = TOOLTIPS.get(this.column);
            if (tooltip == null) {
                tooltip = "";
            }
            return tooltip;
        }
    }

    public static class PathCellLabelProvider
    extends CellLabelProvider {
        private int shellWidth;
        private int shellX;
        Composite parent;
        private int column;
        private int charWidth;
        RelationViewLabelProvider relationViewLabelProvider;

        public PathCellLabelProvider(RelationViewLabelProvider relationViewLabelProvider, Composite parent, int column) {
            this.relationViewLabelProvider = relationViewLabelProvider;
            this.parent = parent;
            this.column = column;
            GC gc = new GC((Drawable)parent);
            try {
                FontMetrics fmt = gc.getFontMetrics();
                this.charWidth = fmt.getAverageCharWidth();
            }
            finally {
                gc.dispose();
            }
        }

        public String getToolTipText(Object element) {
            if (!(element instanceof CnALink)) {
                return "";
            }
            CnALink link = (CnALink)element;
            int mouseX = MouseInfo.getPointerInfo().getLocation().x;
            LOG.debug((Object)("mouse location: " + mouseX));
            boolean isDownwardLink = CnALink.isDownwardLink((CnATreeElement)this.relationViewLabelProvider.getInputElemt(), (CnALink)link);
            CnATreeElement cnATreeElement = isDownwardLink ? link.getDependency() : link.getDependant();
            try {
                RetrieveInfo ri = RetrieveInfo.getPropertyInstance();
                RelationViewLabelProvider.replaceLinkEntities(link);
                LoadAncestors command = new LoadAncestors(cnATreeElement.getTypeId(), cnATreeElement.getUuid(), ri);
                command = (LoadAncestors)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                CnATreeElement current = command.getElement();
                StringBuilder sb = new StringBuilder();
                sb.insert(0, CnATreeElementLabelGenerator.getElementTitle((CnATreeElement)current));
                while (current.getParent() != null) {
                    current = current.getParent();
                    sb.insert(0, "/");
                    sb.insert(0, CnATreeElementLabelGenerator.getElementTitle((CnATreeElement)current));
                }
                String[] p = sb.toString().split("/");
                sb = new StringBuilder();
                int i = 1;
                while (i < p.length) {
                    sb.append("/").append(p[i]);
                    ++i;
                }
                sb.deleteCharAt(0);
                return this.cropToolTip(sb.toString(), mouseX);
            }
            catch (CommandException e) {
                LOG.debug((Object)"loading ancestors failed", (Throwable)e);
                return "";
            }
        }

        public String cropToolTip(String toolTipText, int mouseX) {
            int spaceLeft = this.shellWidth - Math.abs(this.shellX - mouseX);
            if (this.charWidth * toolTipText.length() >= spaceLeft - "...".length() * this.charWidth) {
                String[] p = toolTipText.split("/");
                StringBuilder sb = new StringBuilder();
                if (p.length == 1) {
                    return toolTipText;
                }
                int i = 0;
                while (i < p.length - 1) {
                    sb.append("/").append(p[i]);
                    ++i;
                }
                sb.deleteCharAt(0);
                return this.cropToolTip(String.valueOf(sb.toString()) + " ...", mouseX);
            }
            return toolTipText;
        }

        public void update(ViewerCell cell) {
            switch (this.column) {
                case 0: {
                    cell.setImage(this.relationViewLabelProvider.getColumnImage(cell.getElement(), this.column));
                    break;
                }
                case 2: {
                    cell.setImage(this.relationViewLabelProvider.getColumnImage(cell.getElement(), this.column));
                    break;
                }
                case 3: {
                    cell.setText(this.relationViewLabelProvider.getColumnText(cell.getElement(), this.column));
                }
            }
        }

        public void updateShellWidthAndX(int shellWidth, int shellX) {
            this.shellWidth = shellWidth;
            this.shellX = shellX;
        }
    }
}

