/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.views.IRelationTable;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.ITypedElement;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.service.commands.UpdateElement;

public class RelationDescriptionEditingSupport
extends EditingSupport {
    static final Logger LOG = Logger.getLogger(RelationDescriptionEditingSupport.class);
    private IRelationTable view;
    private TableViewer viewer;

    public RelationDescriptionEditingSupport(IRelationTable view, TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.view = view;
    }

    protected boolean canEdit(Object element) {
        return element instanceof CnALink;
    }

    protected CellEditor getCellEditor(Object element) {
        if (!(element instanceof CnALink)) {
            return null;
        }
        return new TextCellEditor((Composite)this.viewer.getTable());
    }

    protected Object getValue(Object element) {
        if (!(element instanceof CnALink)) {
            return null;
        }
        CnALink link = (CnALink)element;
        String comment = link.getComment();
        Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)("description " + comment));
        return comment;
    }

    protected void setValue(Object element, Object value) {
        CnALink link = (CnALink)element;
        String description = (String)value;
        link.setComment(description);
        CnALink newLink = null;
        try {
            UpdateElement command = new UpdateElement((ITypedElement)link, true, ChangeLogEntry.STATION_ID);
            command = (UpdateElement)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            newLink = (CnALink)command.getElement();
        }
        catch (Exception e) {
            ExceptionUtil.log(e, "Fehler beim Erstellen von Kommentaren.");
        }
        CnAElementFactory.getModel(link.getDependant()).linkChanged(link, newLink, (Object)this.view);
    }
}

