/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.ui.rcp.main.bsi.views.RelationViewLabelProvider;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.verinice.bp.rcp.BaseProtectionTreeComparator;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.bp.ISecurityLevelProvider;
import sernet.verinice.model.bp.SecurityLevel;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;

public class RelationComparator
extends ViewerComparator {
    private Set<String> sorterProperties;
    private NumericStringComparator numComp = new NumericStringComparator();
    private BaseProtectionTreeComparator baseProtectionTreeSorter = new BaseProtectionTreeComparator();
    private static HUITypeFactory huiTypeFactory = HUITypeFactory.getInstance();

    public RelationComparator(String ... sorterProperties) {
        this.sorterProperties = new HashSet<String>(sorterProperties.length);
        Collections.addAll(this.sorterProperties, sorterProperties);
    }

    public boolean isSorterProperty(Object element, String property) {
        return this.sorterProperties.contains(property);
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        SecurityLevel securityLevel2;
        SecurityLevel securityLevel1;
        int comparisonBySecurityLevel;
        String relationName2;
        String relationName1;
        int comparisonByRelationNames;
        if (o1 == null || o2 == null) {
            return 0;
        }
        CnATreeElement elementInQuestion = (CnATreeElement)viewer.getInput();
        CnALink link1 = (CnALink)o1;
        CnALink link2 = (CnALink)o2;
        CnATreeElement linkedElement1 = CnALink.getRelationObject((CnATreeElement)elementInQuestion, (CnALink)link1);
        CnATreeElement linkedElement2 = CnALink.getRelationObject((CnATreeElement)elementInQuestion, (CnALink)link2);
        String otherElementTypeId1 = linkedElement1.getTypeId();
        String otherElementTypeId2 = linkedElement2.getTypeId();
        if (elementInQuestion instanceof IBpElement) {
            int category2;
            int category1 = this.baseProtectionTreeSorter.category(linkedElement1);
            if (category1 != (category2 = this.baseProtectionTreeSorter.category(linkedElement2))) {
                return Integer.compare(category1, category2);
            }
        } else {
            String otherElementTypeName2;
            String otherElementTypeName1 = huiTypeFactory.getEntityType(otherElementTypeId1).getName();
            int comparisonByLinkedElementTypeNames = otherElementTypeName1.compareTo(otherElementTypeName2 = huiTypeFactory.getEntityType(otherElementTypeId2).getName());
            if (comparisonByLinkedElementTypeNames != 0) {
                return comparisonByLinkedElementTypeNames;
            }
        }
        if ((comparisonByRelationNames = (relationName1 = RelationViewLabelProvider.getRelationLabel(elementInQuestion, link1, huiTypeFactory.getRelation(link1.getRelationId()))).compareTo(relationName2 = RelationViewLabelProvider.getRelationLabel(elementInQuestion, link2, huiTypeFactory.getRelation(link2.getRelationId())))) != 0) {
            return comparisonByRelationNames;
        }
        if (linkedElement1 instanceof ISecurityLevelProvider && linkedElement2 instanceof ISecurityLevelProvider && (comparisonBySecurityLevel = SecurityLevel.compare((SecurityLevel)(securityLevel1 = ((ISecurityLevelProvider)linkedElement1).getSecurityLevel()), (SecurityLevel)(securityLevel2 = ((ISecurityLevelProvider)linkedElement2).getSecurityLevel()))) != 0) {
            return comparisonBySecurityLevel;
        }
        String title1 = RelationViewLabelProvider.getLinkTargetTitleIncludingPotentialIdentifier(elementInQuestion, link1);
        String title2 = RelationViewLabelProvider.getLinkTargetTitleIncludingPotentialIdentifier(elementInQuestion, link2);
        return this.numComp.compare((Object)title1, (Object)title2);
    }
}

