/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.iso27k.rcp.ILinkedWithEditorView;
import sernet.verinice.iso27k.rcp.LinkWithEditorPartListener;
import sernet.verinice.model.bsi.Addition;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.bsi.Note;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.service.commands.crud.DeleteNote;
import sernet.verinice.service.commands.crud.LoadNotes;

public class NoteView
extends RightsEnabledView
implements ILinkedWithEditorView {
    private static final Logger LOG = Logger.getLogger(NoteView.class);
    public static final String ID = "sernet.gs.ui.rcp.main.bsi.views.NoteView";
    private ExpandBar expandBar;
    private ISelectionListener selectionListener;
    private ICommandService commandService;
    private CnATreeElement currentCnaElement;
    private RightsEnabledAction addNoteAction;
    private IBSIModelListener modelListener;
    private IPartListener2 linkWithEditorPartListener = new LinkWithEditorPartListener(this);
    private Action linkWithEditorAction;
    private boolean linkingActive = true;

    @Override
    public String getRightID() {
        return "notes";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        int expandBarSpacing = 4;
        parent.setLayout((Layout)new FillLayout());
        this.toggleLinking(Activator.getDefault().getPreferenceStore().getBoolean("link_to_editor"));
        try {
            this.expandBar = new ExpandBar(parent, 512);
            this.expandBar.setSpacing(4);
            this.hookPageSelection();
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.BrowserView_3);
            LOG.error((Object)"Error while creating control", (Throwable)e);
        }
        this.makeActions();
        this.fillLocalToolBar();
    }

    @Override
    public void setFocus() {
        this.expandBar.setFocus();
    }

    private void hookPageSelection() {
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                NoteView.this.pageSelectionChanged(part, selection);
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.selectionListener);
        this.getSite().getPage().addPartListener(this.linkWithEditorPartListener);
    }

    protected void pageSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (((IStructuredSelection)selection).size() != 1) {
            return;
        }
        try {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            this.elementSelected(element);
            if (element instanceof CnATreeElement) {
                this.setNewInput((CnATreeElement)element);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading notes", (Throwable)e);
        }
    }

    private void elementSelected(Object element) {
        if (element instanceof CnATreeElement && !element.equals(this.getCurrentCnaElement())) {
            if (this.addNoteAction.checkRights()) {
                this.addNoteAction.setEnabled(true);
            }
            this.setCurrentCnaElement((CnATreeElement)element);
            this.clear();
            this.loadNotes();
        } else {
            this.addNoteAction.setEnabled(false);
        }
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.addNoteAction);
        manager.add((IAction)this.linkWithEditorAction);
    }

    private void makeActions() {
        this.addNoteAction = new RightsEnabledAction("addnote"){

            @Override
            public void doRun() {
                Note note = new Note();
                note.setCnATreeElement(NoteView.this.getCurrentCnaElement());
                note.setCnAElementTitel(NoteView.this.getCurrentCnaElement().getTitle());
                note.setTitel(Messages.NoteView_2);
                note.addListener(new Addition.INoteChangedListener(){

                    public void noteChanged() {
                        NoteView.this.clear();
                        NoteView.this.loadNotes();
                    }
                });
                EditorFactory.getInstance().openEditor(note);
            }
        };
        this.addNoteAction.setText(Messages.NoteView_3);
        this.addNoteAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("note-new.png"));
        this.addNoteAction.setEnabled(false);
        this.linkWithEditorAction = new Action(Messages.NoteView_0, 2){

            public void run() {
                NoteView.this.toggleLinking(this.isChecked());
            }
        };
        this.linkWithEditorAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("linked.gif"));
        this.linkWithEditorAction.setChecked(this.isLinkingActive());
    }

    public void loadNotes() {
        int defaultMargin = 4;
        int layoutVerticalSpacing = 10;
        int gdHeightHint = 100;
        try {
            LoadNotes command = new LoadNotes(this.getCurrentCnaElement().getDbId());
            command = (LoadNotes)this.getCommandService().executeCommand((ICommand)command);
            List noteList = command.getNoteList();
            if (noteList != null && noteList.size() > 0) {
                for (final Note note : noteList) {
                    note.addListener(new Addition.INoteChangedListener(){

                        public void noteChanged() {
                            NoteView.this.clear();
                            NoteView.this.loadNotes();
                        }
                    });
                    note.setCnAElementTitel(this.getCurrentCnaElement().getTitle());
                    Composite composite = new Composite((Composite)this.expandBar, 0);
                    GridLayout layout = new GridLayout(2, false);
                    layout.marginLeft = 4;
                    layout.marginTop = 4;
                    layout.marginRight = 4;
                    layout.marginBottom = 4;
                    layout.verticalSpacing = 10;
                    composite.setLayout((Layout)layout);
                    GridData gdText = new GridData();
                    gdText.grabExcessHorizontalSpace = true;
                    gdText.grabExcessVerticalSpace = false;
                    gdText.horizontalAlignment = 4;
                    gdText.verticalAlignment = 2;
                    gdText.heightHint = 100;
                    gdText.verticalSpan = 2;
                    int style = 2058;
                    Text text = new Text(composite, style | 0x40 | 0x200);
                    text.setLayoutData((Object)gdText);
                    if (note.getText() != null) {
                        text.setText(note.getText());
                    }
                    Button editButton = new Button(composite, 0);
                    editButton.setImage(ImageCache.getInstance().getImage("edit.png"));
                    editButton.setToolTipText(Messages.NoteView_4);
                    editButton.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            NoteView.this.editNote(note);
                        }
                    });
                    Button deleteButton = new Button(composite, 0);
                    deleteButton.setImage(ImageCache.getInstance().getImage("delete.png"));
                    deleteButton.setToolTipText(Messages.NoteView_5);
                    deleteButton.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            boolean b = MessageDialog.openQuestion((Shell)NoteView.this.getSite().getShell(), (String)Messages.NoteView_6, (String)NLS.bind((String)Messages.NoteView_7, (Object)note.getTitel()));
                            if (b) {
                                NoteView.this.deleteNote(note);
                            }
                        }
                    });
                    ExpandItem item0 = new ExpandItem(this.expandBar, 0, 0);
                    if (note.getTitel() != null) {
                        item0.setText(note.getTitel());
                    }
                    item0.setHeight(composite.computeSize((int)-1, (int)-1).y);
                    item0.setControl((Control)composite);
                    item0.setExpanded(true);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading notes", (Throwable)e);
            ExceptionUtil.log(e, "Error while loading notes");
        }
    }

    protected void editNote(Note note) {
        EditorFactory.getInstance().openEditor(note);
    }

    protected void deleteNote(Note note) {
        DeleteNote command = new DeleteNote((Addition)note);
        try {
            this.getCommandService().executeCommand((ICommand)command);
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while saving note", (Throwable)e);
            ExceptionUtil.log(e, Messages.NoteView_12);
        }
        this.clear();
        this.loadNotes();
    }

    public void clear() {
        Control[] controlArray = this.expandBar.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctl = controlArray[n2];
            ctl.dispose();
            ++n2;
        }
        controlArray = this.expandBar.getItems();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            Control item = controlArray[n2];
            item.dispose();
            ++n2;
        }
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    public CnATreeElement getCurrentCnaElement() {
        return this.currentCnaElement;
    }

    public void setCurrentCnaElement(CnATreeElement currentCnaElement) {
        this.currentCnaElement = currentCnaElement;
    }

    public void dispose() {
        this.getSite().getPage().removePostSelectionListener(this.selectionListener);
        BSIModel model = CnAElementFactory.getLoadedModel();
        model.removeBSIModelListener(this.modelListener);
        this.getSite().getPage().removePartListener(this.linkWithEditorPartListener);
        super.dispose();
    }

    protected void toggleLinking(boolean checked) {
        this.linkingActive = checked;
        if (checked) {
            Optional.ofNullable(this.getSite().getPage().getActiveEditor()).ifPresent(this::editorActivated);
        }
    }

    protected boolean isLinkingActive() {
        return this.linkingActive;
    }

    @Override
    public void editorActivated(IEditorPart activeEditor) {
        if (!this.isLinkingActive() || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        CnATreeElement element = BSIElementEditorInput.extractElement(activeEditor);
        if (element == null) {
            return;
        }
        this.elementSelected(element);
    }

    private void setNewInput(CnATreeElement elmt) {
        this.setViewTitle(String.valueOf(Messages.NoteView_8) + " " + elmt.getTitle());
    }

    private void setViewTitle(String title) {
        this.setContentDescription(title);
    }
}

