/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.views.GenericMassnahmenView;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bpm.TodoViewItem;
import sernet.verinice.model.bsi.Anwendung;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.Client;
import sernet.verinice.model.bsi.Gebaeude;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.NetzKomponente;
import sernet.verinice.model.bsi.Person;
import sernet.verinice.model.bsi.Raum;
import sernet.verinice.model.bsi.Server;
import sernet.verinice.model.bsi.SonstIT;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.validation.CnAValidation;
import sernet.verinice.service.commands.task.FindMassnahmeById;

class MassnahmenUmsetzungContentProvider
implements IStructuredContentProvider {
    private static final Logger LOG = Logger.getLogger(MassnahmenUmsetzungContentProvider.class);
    private static final int ADD = 0;
    private static final int UPDATE = 1;
    private static final int REMOVE = 2;
    private static final int REFRESH = 3;
    private TableViewer viewer;
    private GenericMassnahmenView todoView;
    private IBSIModelListener modelListener = new IBSIModelListener(){

        public void childAdded(CnATreeElement category, CnATreeElement child) {
            if (child instanceof BausteinUmsetzung && MassnahmenUmsetzungContentProvider.this.isOfInterest(child)) {
                MassnahmenUmsetzungContentProvider.this.reloadMeasures();
            } else if (child instanceof ITVerbund) {
                MassnahmenUmsetzungContentProvider.this.todoView.compoundAdded((ITVerbund)child);
            }
        }

        public void linkChanged(CnALink old, CnALink link, Object source) {
            if (link.getDependency() instanceof Person) {
                MassnahmenUmsetzungContentProvider.this.updateViewer(3, null);
            }
        }

        public void linkAdded(CnALink link) {
            if (link.getDependency() instanceof Person) {
                MassnahmenUmsetzungContentProvider.this.reloadMeasures();
            }
        }

        public void linkRemoved(CnALink link) {
            if (link.getDependency() instanceof Person) {
                MassnahmenUmsetzungContentProvider.this.reloadMeasures();
            }
        }

        public void childChanged(CnATreeElement child) {
            if (child instanceof MassnahmenUmsetzung) {
                try {
                    if (!MassnahmenUmsetzungContentProvider.this.isOfInterest(child)) {
                        LOG.debug((Object)("MassnahmenUmsetzung is not of interest for view: " + child));
                        return;
                    }
                    Activator.inheritVeriniceContextState();
                    FindMassnahmeById command = new FindMassnahmeById(child.getDbId());
                    command = (FindMassnahmeById)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                    List items = command.getAll();
                    if (items.size() > 0) {
                        TodoViewItem item = (TodoViewItem)items.get(0);
                        MassnahmenUmsetzungContentProvider.this.updateViewer(1, item);
                    }
                }
                catch (CommandException e) {
                    Logger.getLogger(this.getClass()).debug((Object)"Fehler beim Aktualisieren von TodoView", (Throwable)e);
                }
            } else if (child instanceof ITVerbund) {
                MassnahmenUmsetzungContentProvider.this.todoView.compoundChanged((ITVerbund)child);
            }
        }

        public void childRemoved(CnATreeElement category, CnATreeElement child) {
            if (child instanceof ITVerbund) {
                MassnahmenUmsetzungContentProvider.this.todoView.compoundRemoved((ITVerbund)child);
            } else if (MassnahmenUmsetzungContentProvider.this.canContainMeasures(child) && MassnahmenUmsetzungContentProvider.this.isOfInterest(child)) {
                MassnahmenUmsetzungContentProvider.this.reloadMeasures();
            }
        }

        public void modelRefresh() {
            this.modelRefresh(null);
        }

        public void modelRefresh(Object source) {
            if (source != null) {
                MassnahmenUmsetzungContentProvider.this.todoView.setLoadBlockNumber(0);
                MassnahmenUmsetzungContentProvider.this.todoView.getLoadMoreAction().setEnabled(true);
                MassnahmenUmsetzungContentProvider.this.reloadMeasures();
            }
        }

        public void databaseChildAdded(CnATreeElement child) {
            if (child instanceof BausteinUmsetzung && MassnahmenUmsetzungContentProvider.this.isOfInterest(child)) {
                MassnahmenUmsetzungContentProvider.this.reloadMeasures();
            }
        }

        public void databaseChildChanged(CnATreeElement child) {
            this.childChanged(child);
        }

        public void databaseChildRemoved(CnATreeElement child) {
            this.childRemoved(child.getParent(), child);
        }

        public void modelReload(BSIModel newModel) {
        }

        public void databaseChildRemoved(ChangeLogEntry entry) {
        }

        public void validationAdded(Integer scopeId) {
        }

        public void validationRemoved(Integer scopeId) {
        }

        public void validationChanged(CnAValidation oldValidation, CnAValidation newValidation) {
        }
    };

    public MassnahmenUmsetzungContentProvider(GenericMassnahmenView todoView) {
        this.todoView = todoView;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)viewer;
        BSIModel model = CnAElementFactory.getLoadedModel();
        if (model != null) {
            model.removeBSIModelListener(this.modelListener);
            model.addBSIModelListener(this.modelListener);
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof PlaceHolder) {
            return new Object[]{inputElement};
        }
        List mns = (List)inputElement;
        return mns.toArray(new Object[mns.size()]);
    }

    public void dispose() {
        BSIModel model = CnAElementFactory.getLoadedModel();
        model.removeBSIModelListener(this.modelListener);
    }

    void reloadMeasures() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    MassnahmenUmsetzungContentProvider.this.todoView.reloadMeasures();
                }
                catch (RuntimeException e) {
                    ExceptionUtil.log(e, "Konnte Realisierungsplan nicht neu laden.");
                }
            }
        });
    }

    void updateViewer(final int type, final Object child) {
        if (Display.getCurrent() != null) {
            switch (type) {
                case 0: {
                    this.viewer.add(child);
                    return;
                }
                case 1: {
                    this.viewer.update(child, new String[]{"umsetzung"});
                    return;
                }
                case 2: {
                    this.viewer.remove(child);
                    return;
                }
                case 3: {
                    this.viewer.refresh();
                    return;
                }
            }
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                switch (type) {
                    case 0: {
                        MassnahmenUmsetzungContentProvider.this.viewer.add(child);
                        return;
                    }
                    case 1: {
                        MassnahmenUmsetzungContentProvider.this.viewer.update(child, new String[]{"umsetzung"});
                        return;
                    }
                    case 2: {
                        MassnahmenUmsetzungContentProvider.this.viewer.remove(child);
                        return;
                    }
                    case 3: {
                        MassnahmenUmsetzungContentProvider.this.viewer.refresh();
                        return;
                    }
                }
            }
        });
    }

    private boolean isOfInterest(CnATreeElement child) {
        ITVerbund expectedCompound = this.todoView.getCurrentCompound();
        if (expectedCompound == null) {
            return false;
        }
        CnATreeElement parent = child.getParent();
        while (!(parent instanceof ITVerbund)) {
            if (parent == null) {
                LOG.warn((Object)"Element with no IT-Verbund ancestor. Skipping ...");
                return false;
            }
            parent = Retriever.checkRetrieveParent((CnATreeElement)parent);
            parent = parent.getParent();
        }
        return parent.equals((Object)expectedCompound);
    }

    private boolean canContainMeasures(CnATreeElement child) {
        Class[] classes;
        Class[] classArray = classes = new Class[]{BausteinUmsetzung.class, Anwendung.class, Server.class, Client.class, SonstIT.class, Gebaeude.class, NetzKomponente.class, Raum.class};
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (c.isAssignableFrom(child.getClass())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

