/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.osgi.util.NLS;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.Massnahme;
import sernet.gs.service.GSServiceException;
import sernet.gs.service.Retriever;
import sernet.gs.service.VeriniceCharset;
import sernet.gs.ui.rcp.main.CnAWorkspace;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.RisikoMassnahmeHome;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.Property;
import sernet.hui.common.connect.PropertyList;
import sernet.hui.common.connect.PropertyType;
import sernet.verinice.interfaces.iso27k.IItem;
import sernet.verinice.interfaces.licensemanagement.ILicenseManagementService;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.bp.IBpGroup;
import sernet.verinice.model.bpm.TodoViewItem;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.OwnGefaehrdung;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Control;
import sernet.verinice.model.iso27k.Threat;
import sernet.verinice.model.iso27k.Vulnerability;
import sernet.verinice.model.licensemanagement.LicenseManagementException;
import sernet.verinice.model.licensemanagement.LicenseMessageInfos;
import sernet.verinice.model.licensemanagement.NoLicenseAssignedException;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.rcp.account.LicenseMgmtPage;
import sernet.verinice.service.parser.GSScraperUtil;

public abstract class HtmlWriter {
    private static final Logger LOG = Logger.getLogger(HtmlWriter.class);
    private static final String ISO_8859_1 = "iso-8859-1";
    private static final String UTF_8 = "utf-8";
    private static final String NULL_STRING = "null";

    private HtmlWriter() {
    }

    public static String getHtml(Object element) throws GSServiceException {
        String html = HtmlWriter.handleRequestDynamic(element);
        if (StringUtils.isEmpty((String)html)) {
            html = HtmlWriter.handleRequestStatic(element);
        }
        if (element instanceof IBpElement || element instanceof IBpGroup) {
            StringBuilder buf = new StringBuilder();
            HtmlWriter.writeHtml(buf, "", html, VeriniceCharset.CHARSET_UTF_8.name());
            html = buf.toString();
        }
        return html;
    }

    private static String handleRequestDynamic(Object element) {
        CnATreeElement cnaTreeElement;
        EntityType entityType;
        StringBuilder sb = new StringBuilder();
        if (element instanceof CnATreeElement && (entityType = (cnaTreeElement = (CnATreeElement)element).getEntityType()) != null) {
            List htmlProperties = entityType.getObjectBrowserPropertyTypes();
            Iterator iterator = htmlProperties.iterator();
            while (iterator.hasNext()) {
                String html = HtmlWriter.buildObjectBrowserContent(cnaTreeElement, (PropertyType)iterator.next());
                if (StringUtils.isEmpty((String)html)) continue;
                sb.append(html);
                if (!iterator.hasNext()) continue;
                sb.append("<br><br>");
            }
        }
        return sb.toString();
    }

    private static String buildObjectBrowserContent(CnATreeElement cnaTreeElement, PropertyType propertyType) {
        StringBuilder sb = new StringBuilder();
        cnaTreeElement = Retriever.checkRetrieveElement((CnATreeElement)cnaTreeElement);
        PropertyList propertyList = cnaTreeElement.getEntity().getProperties(propertyType.getId());
        try {
            for (Property property : propertyList.getProperties()) {
                sb.append(property.isLimitedLicense() != false ? HtmlWriter.getLicenseRestrictedContent(property) : HtmlWriter.getProperty(cnaTreeElement, propertyType));
            }
        }
        catch (LicenseManagementException e) {
            LOG.error((Object)"Error while validating license", (Throwable)e);
        }
        return sb.toString();
    }

    private static String getProperty(CnATreeElement cnATreeElement, PropertyType propertyType) {
        String value = "";
        if ("risiko-massnahmen-umsetzung".equals(cnATreeElement.getObjectType())) {
            value = HtmlWriter.getOwnRiskSafeguardText(cnATreeElement);
        }
        if (StringUtils.isEmpty((String)value)) {
            value = cnATreeElement.getPropertyValue(propertyType.getId());
        }
        return value;
    }

    private static String getOwnRiskSafeguardText(CnATreeElement cnATreeElement) {
        RisikoMassnahmenUmsetzung ums = (RisikoMassnahmenUmsetzung)cnATreeElement;
        RisikoMassnahmeHome.getInstance().initRisikoMassnahmeUmsetzung(ums);
        if (ums.getRisikoMassnahme() != null) {
            return HtmlWriter.toHtml(ums);
        }
        return "";
    }

    private static String getLicenseRestrictedContent(Property property) throws LicenseManagementException {
        StringBuilder sb = new StringBuilder();
        LicenseMessageInfos infos = HtmlWriter.getLicenseMgmtService().getLicenseMessageInfos(ServiceFactory.lookupAuthService().getUsername(), property.getLicenseContentId(), "", null);
        if (infos.isNoLicenseAvailable()) {
            return Messages.BrowserView_No_License_assigned;
        }
        infos.setAccountWizardLabel(LicenseMgmtPage.getLicenseLabelString(infos.getLicenseId()));
        if (infos.getValidUntil().isBefore(LocalDate.now())) {
            return NLS.bind((String)Messages.BrowserView_License_Not_Valid_Anymore, (Object[])new Object[]{infos.getAccountWizardLabel()});
        }
        if (infos.isInvalidSoon()) {
            LocalDate dateNow = LocalDate.now();
            LocalDate validUntil = infos.getValidUntil();
            long daysValid = ChronoUnit.DAYS.between(dateNow, validUntil);
            String msg = NLS.bind((String)Messages.BrowserView_License_Ends_Soon, (Object[])new Object[]{infos.getAccountWizardLabel(), daysValid});
            sb.append(msg);
        }
        sb.append(HtmlWriter.getLicenseRestrictedPropertyValue(property));
        return sb.toString();
    }

    private static String getLicenseRestrictedPropertyValue(Property property) {
        String encryptedContentId = property.getLicenseContentId();
        String cypherText = property.getPropertyValue();
        String currentUser = ServiceFactory.lookupAuthService().getUsername();
        try {
            return HtmlWriter.getLicenseMgmtService().decryptRestrictedProperty(encryptedContentId, cypherText, currentUser);
        }
        catch (NoLicenseAssignedException e) {
            String msg = "User has no license assigned for this content";
            LOG.error((Object)msg, (Throwable)e);
        }
        catch (LicenseManagementException e) {
            String msg = "Something went wrong decrypting license restricted information";
            LOG.error((Object)msg, (Throwable)e);
        }
        return Messages.BrowserView_No_License_assigned;
    }

    private static String handleRequestStatic(Object element) throws GSServiceException {
        if (element instanceof Baustein) {
            Baustein bst = (Baustein)element;
            return HtmlWriter.getHtmlFromStream(GSScraperUtil.getInstance().getModel().getBaustein(bst.getUrl(), bst.getStand()), bst.getEncoding());
        }
        if (element instanceof OwnGefaehrdung) {
            OwnGefaehrdung ownGefaehrdung = (OwnGefaehrdung)element;
            if (ownGefaehrdung.getUrl() == null || ownGefaehrdung.getUrl().isEmpty() || ownGefaehrdung.getUrl().equals(NULL_STRING)) {
                return HtmlWriter.toHtml(ownGefaehrdung);
            }
            return HtmlWriter.getHtmlFromStream(GSScraperUtil.getInstance().getModel().getGefaehrdung(ownGefaehrdung.getUrl(), ownGefaehrdung.getStand()), UTF_8);
        }
        if (element instanceof Gefaehrdung) {
            Gefaehrdung gef = (Gefaehrdung)element;
            return HtmlWriter.getHtmlFromStream(GSScraperUtil.getInstance().getModel().getGefaehrdung(gef.getUrl(), gef.getStand()), gef.getEncoding());
        }
        if (element instanceof GefaehrdungsUmsetzung) {
            GefaehrdungsUmsetzung gefUms = (GefaehrdungsUmsetzung)element;
            if (gefUms.getUrl() == null || gefUms.getUrl().isEmpty() || gefUms.getUrl().equals(NULL_STRING)) {
                return HtmlWriter.toHtml(gefUms);
            }
            return HtmlWriter.getHtmlFromStream(GSScraperUtil.getInstance().getModel().getGefaehrdung(gefUms.getUrl(), gefUms.getStand()), UTF_8);
        }
        if (element instanceof BausteinUmsetzung) {
            BausteinUmsetzung bst = (BausteinUmsetzung)element;
            if (bst.getUrl() == null || bst.getUrl().isEmpty() || bst.getUrl().equals(NULL_STRING)) {
                return HtmlWriter.toHtml(bst);
            }
            return HtmlWriter.getHtmlFromStream(GSScraperUtil.getInstance().getModel().getBaustein(bst.getUrl(), bst.getStand()), bst.getEncoding());
        }
        if (element instanceof Massnahme) {
            Massnahme mn = (Massnahme)element;
            return GSScraperUtil.getInstance().getModel().getMassnahmeHtml(mn.getUrl(), mn.getStand());
        }
        if (element instanceof RisikoMassnahmenUmsetzung) {
            RisikoMassnahmenUmsetzung ums = (RisikoMassnahmenUmsetzung)element;
            RisikoMassnahmeHome.getInstance().initRisikoMassnahmeUmsetzung(ums);
            if (ums.getRisikoMassnahme() != null) {
                return HtmlWriter.toHtml(ums);
            }
            return GSScraperUtil.getInstance().getModel().getMassnahmeHtml(ums.getUrl(), ums.getStand());
        }
        if (element instanceof MassnahmenUmsetzung) {
            MassnahmenUmsetzung mnu = (MassnahmenUmsetzung)element;
            if (mnu.getUrl() == null || mnu.getUrl().isEmpty() || mnu.getUrl().equals(NULL_STRING)) {
                return HtmlWriter.toHtml(mnu);
            }
            return GSScraperUtil.getInstance().getModel().getMassnahmeHtml(mnu.getUrl(), mnu.getStand());
        }
        if (element instanceof TodoViewItem) {
            TodoViewItem item = (TodoViewItem)element;
            return GSScraperUtil.getInstance().getModel().getMassnahmeHtml(item.getUrl(), item.getStand());
        }
        if (element instanceof IItem) {
            IItem item = (IItem)element;
            StringBuilder sb = new StringBuilder();
            HtmlWriter.writeHtml(sb, item.getName(), item.getDescription(), VeriniceCharset.CHARSET_UTF_8.name());
            return sb.toString();
        }
        if (element instanceof Control) {
            StringBuilder sb = new StringBuilder();
            Control control = (Control)element;
            PropertyType titleProperty = HUITypeFactory.getInstance().getPropertyType(control.getEntityType().getId(), "control_name");
            PropertyType descriptionProperty = HUITypeFactory.getInstance().getPropertyType(control.getEntityType().getId(), "control_desc");
            HtmlWriter.writeHtml(sb, HtmlWriter.buildObjectBrowserContent((CnATreeElement)control, titleProperty), HtmlWriter.buildObjectBrowserContent((CnATreeElement)control, descriptionProperty), VeriniceCharset.CHARSET_UTF_8.name());
            return sb.toString();
        }
        if (element instanceof SamtTopic) {
            StringBuilder sb = new StringBuilder();
            SamtTopic samtTopic = (SamtTopic)element;
            PropertyType titleProperty = HUITypeFactory.getInstance().getPropertyType(samtTopic.getEntityType().getId(), "samt_topic_name");
            PropertyType descriptionProperty = HUITypeFactory.getInstance().getPropertyType(samtTopic.getEntityType().getId(), "samt_topic_desc");
            HtmlWriter.writeHtml(sb, HtmlWriter.buildObjectBrowserContent((CnATreeElement)samtTopic, titleProperty), HtmlWriter.buildObjectBrowserContent((CnATreeElement)samtTopic, descriptionProperty), VeriniceCharset.CHARSET_UTF_8.name());
            return sb.toString();
        }
        if (element instanceof Threat) {
            Threat item = (Threat)element;
            StringBuilder sb = new StringBuilder();
            PropertyType titleProperty = HUITypeFactory.getInstance().getPropertyType(item.getEntityType().getId(), "threat_name");
            PropertyType descriptionProperty = HUITypeFactory.getInstance().getPropertyType(item.getEntityType().getId(), "threat_description");
            HtmlWriter.writeHtml(sb, HtmlWriter.buildObjectBrowserContent((CnATreeElement)item, titleProperty), HtmlWriter.buildObjectBrowserContent((CnATreeElement)item, descriptionProperty), VeriniceCharset.CHARSET_UTF_8.name());
            return sb.toString();
        }
        if (element instanceof Vulnerability) {
            Vulnerability item = (Vulnerability)element;
            StringBuilder sb = new StringBuilder();
            PropertyType titleProperty = HUITypeFactory.getInstance().getPropertyType(item.getEntityType().getId(), "vulnerability_name");
            PropertyType descriptionProperty = HUITypeFactory.getInstance().getPropertyType(item.getEntityType().getId(), "vulnerability_desc");
            HtmlWriter.writeHtml(sb, HtmlWriter.buildObjectBrowserContent((CnATreeElement)item, titleProperty), HtmlWriter.buildObjectBrowserContent((CnATreeElement)item, descriptionProperty), VeriniceCharset.CHARSET_UTF_8.name());
            return sb.toString();
        }
        return "";
    }

    private static String toHtml(BausteinUmsetzung bstums) {
        StringBuilder buf = new StringBuilder();
        PropertyType titleProperty = HUITypeFactory.getInstance().getPropertyType(bstums.getEntityType().getId(), "bstumsetzung_name");
        PropertyType descriptionProperty = HUITypeFactory.getInstance().getPropertyType(bstums.getEntityType().getId(), "eigene_bstumsetzung_beschreibung");
        HtmlWriter.writeHtml(buf, HtmlWriter.buildObjectBrowserContent((CnATreeElement)bstums, titleProperty), HtmlWriter.buildObjectBrowserContent((CnATreeElement)bstums, descriptionProperty), ISO_8859_1);
        return buf.toString();
    }

    private static String toHtml(MassnahmenUmsetzung mnums) {
        StringBuilder buf = new StringBuilder();
        PropertyType titleProperty = HUITypeFactory.getInstance().getPropertyType(mnums.getEntityType().getId(), "mnums_name");
        PropertyType descriptionProperty = HUITypeFactory.getInstance().getPropertyType(mnums.getEntityType().getId(), "mnums_beschreibung");
        HtmlWriter.writeHtml(buf, HtmlWriter.buildObjectBrowserContent((CnATreeElement)mnums, titleProperty), HtmlWriter.buildObjectBrowserContent((CnATreeElement)mnums, descriptionProperty), ISO_8859_1);
        return buf.toString();
    }

    private static String toHtml(GefaehrdungsUmsetzung ums) {
        StringBuilder buf = new StringBuilder();
        PropertyType propertyType = HUITypeFactory.getInstance().getPropertyType(ums.getEntityType().getId(), "gefaehrdungsumsetzung_id");
        StringBuilder titleBuilder = new StringBuilder().append(HtmlWriter.buildObjectBrowserContent((CnATreeElement)ums, propertyType));
        titleBuilder.append(" ");
        propertyType = HUITypeFactory.getInstance().getPropertyType(ums.getEntityType().getId(), "gefaehrdungsumsetzung_titel");
        titleBuilder.append(HtmlWriter.buildObjectBrowserContent((CnATreeElement)ums, propertyType));
        propertyType = HUITypeFactory.getInstance().getPropertyType(ums.getEntityType().getId(), "gefaehrdungsumsetzung_description");
        HtmlWriter.writeHtml(buf, titleBuilder.toString(), HtmlWriter.buildObjectBrowserContent((CnATreeElement)ums, propertyType), ISO_8859_1);
        return buf.toString();
    }

    private static String toHtml(OwnGefaehrdung gef) {
        StringBuilder buf = new StringBuilder();
        HtmlWriter.writeHtml(buf, String.valueOf(gef.getId()) + " " + gef.getTitel(), gef.getBeschreibung(), ISO_8859_1);
        return HtmlWriter.removeUnsupportedHtmlPattern(buf.toString());
    }

    private static String toHtml(RisikoMassnahmenUmsetzung ums) {
        StringBuilder buf = new StringBuilder();
        HtmlWriter.writeHtml(buf, String.valueOf(ums.getNumber()) + " " + ums.getName(), ums.getDescription(), ISO_8859_1);
        return buf.toString();
    }

    public static String getPage(String text) {
        StringBuilder sb = new StringBuilder();
        HtmlWriter.writeHtml(sb, null, text, VeriniceCharset.CHARSET_UTF_8.name());
        return sb.toString();
    }

    private static void writeHtml(StringBuilder buf, String headline, String bodytext, String encoding) {
        if (StringUtils.isBlank((String)headline) && StringUtils.isBlank((String)bodytext)) {
            return;
        }
        String cssFile = "screen.css";
        String cssDir = CnAWorkspace.getInstance().getWorkdir().toPath().resolve("html").resolve(cssFile).toString();
        buf.append("<html><head>");
        buf.append("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=").append(encoding).append("\"/>\n");
        buf.append("<link REL=\"stylesheet\" media=\"screen\" HREF=\"").append(cssDir).append("\"/>");
        buf.append("</head><body><div id=\"content\">");
        if (headline != null) {
            buf.append("<h1>");
            buf.append(headline);
            buf.append("</h1>");
        }
        buf.append("<p>");
        if (bodytext != null) {
            buf.append(bodytext.replaceAll("\\n", "<br/>"));
        }
        buf.append("</p></div></body></html>");
    }

    private static String getHtmlFromStream(InputStream is, String encoding) {
        int utf8SkipWhitespaceChar = 160;
        try {
            String line;
            if (!encoding.equalsIgnoreCase(ISO_8859_1) && !encoding.equalsIgnoreCase(UTF_8)) {
                encoding = UTF_8;
            }
            InputStreamReader read = new InputStreamReader(is, encoding);
            BufferedReader buffRead = new BufferedReader(read);
            StringBuilder b = new StringBuilder();
            boolean skip = false;
            boolean skipComplete = false;
            String cssDir = CnAWorkspace.getInstance().getWorkdir().toPath().resolve("html").resolve("screen.css").toString();
            while ((line = buffRead.readLine()) != null) {
                if (!skipComplete) {
                    if (line.matches(".*div.*id=\"menuoben\".*") || line.matches(".*div.*class=\"standort\".*")) {
                        skip = true;
                    } else if (line.matches(".*div.*id=\"content\".*")) {
                        skip = false;
                        skipComplete = true;
                    }
                }
                line = HtmlWriter.convertCss(line, cssDir);
                line = HtmlWriter.removeUnsupportedHtmlPattern(line);
                line = line.replace('\u00a0', ' ');
                if (skip) continue;
                b.append(line);
            }
            return b.toString();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while geeting html from stream", (Throwable)e);
            return null;
        }
    }

    private static String removeUnsupportedHtmlPattern(String line) {
        line = line.replaceAll("<a.*?>", "");
        line = line.replaceAll("</a.*?>", "");
        line = line.replaceAll("<img.*?>", "");
        line = line.replace("<em>", "");
        line = line.replace("</em>", "");
        return line;
    }

    private static String convertCss(String line, String cssDir) {
        line = line.replace("../../media/style/css/screen.css", cssDir);
        line = line.replace("../../../screen.css", cssDir);
        line = line.replace("../../screen.css", cssDir);
        line = line.replace("../screen.css", cssDir);
        return line;
    }

    private static ILicenseManagementService getLicenseMgmtService() {
        return ServiceFactory.lookupLicenseManagementService();
    }
}

