/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenSiegelFilter;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenUmsetzungFilter;
import sernet.gs.ui.rcp.main.bsi.views.IMassnahmenListView;
import sernet.gs.ui.rcp.main.bsi.views.LoadMoreAction;
import sernet.gs.ui.rcp.main.bsi.views.MassnahmenUmsetzungContentProvider;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bpm.TodoViewItem;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.service.commands.crud.LoadCnATreeElementTitles;
import sernet.verinice.service.commands.task.FindMassnahmenForITVerbund;

public abstract class GenericMassnahmenView
extends RightsEnabledView
implements IMassnahmenListView {
    private static final Logger LOG = Logger.getLogger(GenericMassnahmenView.class);
    private int loadBlockNumber = 0;
    private boolean isDateSet = false;
    private List<TodoViewItem> allMassnahmen;
    private IModelLoadListener loadListener = new DefaultModelLoadListener(){
        private ITVerbund lastSelectedCompound;

        @Override
        public void closed(BSIModel model) {
            Display.getDefault().asyncExec(() -> {
                this.lastSelectedCompound = CnAElementHome.getInstance().isOpen() ? GenericMassnahmenView.this.compoundChoser.getSelectedCompound() : null;
                GenericMassnahmenView.this.compoundChoser.setSelectedCompound(null);
                GenericMassnahmenView.this.compoundChoser.setEnabled(false);
                GenericMassnahmenView.this.resetTable(false);
            });
        }

        @Override
        public void loaded(BSIModel model) {
            Display.getDefault().asyncExec(() -> {
                try {
                    this.loadCompounds(this.lastSelectedCompound);
                }
                catch (RuntimeException e) {
                    ExceptionUtil.log(e, Messages.GenericMassnahmenView_3);
                }
            });
        }

        private void loadCompounds(ITVerbund compound) {
            if (!CnAElementHome.getInstance().isOpen()) {
                GenericMassnahmenView.this.compoundChoser.setEnabled(false);
                return;
            }
            GenericMassnahmenView.this.viewer.setInput((Object)new PlaceHolder(Messages.GenericMassnahmenView_6));
            LoadCompounds job = new LoadCompounds(Messages.GenericMassnahmenView_7, compound);
            job.setUser(false);
            job.schedule();
        }
    };
    private TableViewer viewer;
    protected TableColumn iconColumn;
    protected TableColumn titleColumn;
    protected TableColumn siegelColumn;
    protected TableColumn dateColumn;
    protected TableColumn zielColumn;
    protected TableColumn bearbeiterColumn;
    private Action loadMoreAction;
    private MassnahmenUmsetzungFilter umsetzungFilter;
    private MassnahmenSiegelFilter siegelFilter;
    private MassnahmenCompoundChoser compoundChoser = new MassnahmenCompoundChoser();

    protected abstract ILabelProvider createLabelProvider();

    protected abstract TableSorter createSorter();

    protected abstract void createPartControlImpl(Composite var1);

    @Override
    public final void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.viewer = new TableViewer(parent, 66306){

            public void update(Object o, String[] props) {
                List list;
                int index;
                Object input = this.getInput();
                if (input instanceof List && (index = (list = (List)this.getInput()).indexOf(o)) >= 0) {
                    list.set(index, o);
                    Widget w = this.doFindItem(o);
                    if (w != null) {
                        w.setData(o);
                        super.update(o, props);
                    } else {
                        this.refresh();
                    }
                }
            }
        };
        this.createPartControlImpl(parent);
        this.createFilters();
        Action filterAction = this.createFilterAction(this.umsetzungFilter, this.siegelFilter);
        this.createPullDownMenu(filterAction);
        this.createLoadMoreAction();
        Action toggleDateAction = this.createToggleDateAction();
        MassnahmenUmsetzungContentProvider contentProvider = new MassnahmenUmsetzungContentProvider(this);
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        CnAElementFactory.getInstance().addLoadListener(this.loadListener);
        this.viewer.setComparator((ViewerComparator)this.createSorter());
        this.attachListeners();
        this.fillLocalToolBar(toggleDateAction, filterAction);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.dateColumn.pack();
    }

    void resetTable(boolean chooseMessage) {
        if (chooseMessage) {
            this.viewer.setInput((Object)new PlaceHolder(Messages.GenericMassnahmenView_5));
        } else {
            this.viewer.setInput(new ArrayList());
        }
    }

    @Override
    public final void reloadMeasures() {
        ITVerbund compound = this.compoundChoser.getSelectedCompound();
        if (compound == null) {
            LOG.warn((Object)"No IT-Verbund was selected during reload.");
        } else {
            this.loadMeasures(compound);
        }
    }

    protected abstract String getMeasureLoadPlaceholderLabel();

    protected abstract String getMeasureLoadJobLabel();

    protected abstract String getMeasureLoadTaskLabel();

    protected abstract String getTaskErrorLabel();

    private void loadMeasures(ITVerbund itVerbund) {
        if (!CnAElementHome.getInstance().isOpen()) {
            this.compoundChoser.setEnabled(false);
            return;
        }
        this.viewer.setInput((Object)new PlaceHolder(this.getMeasureLoadPlaceholderLabel()));
        LoadMeasures job = new LoadMeasures(this.getMeasureLoadJobLabel(), itVerbund);
        job.setUser(false);
        job.schedule();
    }

    protected abstract String getSortByProperty();

    protected abstract String getDateProperty();

    protected abstract Action createFilterAction(MassnahmenUmsetzungFilter var1, MassnahmenSiegelFilter var2);

    private void createPullDownMenu(Action filterAction) {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)filterAction);
    }

    private void fillLocalToolBar(Action toggleDateAction, Action filterAction) {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        ActionContributionItem item = new ActionContributionItem((IAction)this.loadMoreAction);
        item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        manager.add((IContributionItem)item);
        ActionContributionItem item2 = new ActionContributionItem((IAction)toggleDateAction);
        item2.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        manager.add((IContributionItem)item2);
        manager.add((IAction)filterAction);
        manager.add((IContributionItem)this.compoundChoser);
    }

    private void createLoadMoreAction() {
        this.loadMoreAction = new LoadMoreAction(this, Messages.GenericMassnahmenView_11);
    }

    private Action createToggleDateAction() {
        Action toggleDateAction = new Action(){

            public void run() {
                GenericMassnahmenView.this.isDateSet = !GenericMassnahmenView.this.isDateSet;
                this.setChecked(GenericMassnahmenView.this.isDateSet);
                GenericMassnahmenView.this.loadBlockNumber = 0;
                GenericMassnahmenView.this.loadMoreAction.setEnabled(true);
                GenericMassnahmenView.this.reloadMeasures();
            }
        };
        toggleDateAction.setChecked(this.isDateSet);
        toggleDateAction.setText(Messages.GenericMassnahmenView_12);
        toggleDateAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("16-clock.png"));
        return toggleDateAction;
    }

    private void createFilters() {
        this.umsetzungFilter = new MassnahmenUmsetzungFilter((StructuredViewer)this.viewer);
        this.siegelFilter = new MassnahmenSiegelFilter((StructuredViewer)this.viewer);
        this.umsetzungFilter.setUmsetzungPattern(this.getUmsetzungPattern());
    }

    protected abstract String[] getUmsetzungPattern();

    public final void dispose() {
        CnAElementFactory.getInstance().removeLoadListener(this.loadListener);
        super.dispose();
    }

    private void attachListeners() {
        this.viewer.addDoubleClickListener(event -> {
            Object sel = ((IStructuredSelection)event.getSelection()).getFirstElement();
            EditorFactory.getInstance().openEditor(sel);
        });
        this.viewer.addSelectionChangedListener(event -> {
            Object sel = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (sel instanceof PlaceHolder) {
                this.reloadMeasures();
            }
        });
    }

    @Override
    public final void setFocus() {
        this.viewer.getTable().setFocus();
    }

    @Override
    public final void compoundAdded(ITVerbund compound) {
        Display.getDefault().asyncExec(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("handling added compound: " + compound.getTitle()));
            }
            this.compoundChoser.compoundAdded(compound);
        });
    }

    @Override
    public final void compoundRemoved(ITVerbund compound) {
        Display.getDefault().asyncExec(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("handling removed compound: " + compound.getTitle()));
            }
            this.compoundChoser.compoundRemoved(compound);
        });
    }

    @Override
    public final void compoundChanged(ITVerbund compound) {
        Display.getDefault().asyncExec(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("handling changed compound: " + compound.getTitle()));
            }
            this.compoundChoser.compoundChanged(compound);
        });
    }

    @Override
    public final ITVerbund getCurrentCompound() {
        ITVerbund[] retval = new ITVerbund[1];
        Display.getDefault().syncExec(() -> {
            ITVerbund iTVerbund = this.compoundChoser.getSelectedCompound();
        });
        return retval[0];
    }

    public void setLoadBlockNumber(int loadBlockNumber) {
        this.loadBlockNumber = loadBlockNumber;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public Action getLoadMoreAction() {
        return this.loadMoreAction;
    }

    private final class LoadCompounds
    extends WorkspaceJob {
        private final ITVerbund compound;

        private LoadCompounds(String name, ITVerbund compound) {
            super(name);
            this.compound = compound;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            Activator.inheritVeriniceContextState();
            try {
                monitor.setTaskName("");
                LoadCnATreeElementTitles compoundLoader = new LoadCnATreeElementTitles(ITVerbund.class);
                compoundLoader = (LoadCnATreeElementTitles)ServiceFactory.lookupCommandService().executeCommand((ICommand)compoundLoader);
                List elements = compoundLoader.getElements();
                Display.getDefault().asyncExec(() -> {
                    GenericMassnahmenView.this.compoundChoser.setElements(elements);
                    GenericMassnahmenView.this.compoundChoser.setEnabled(true);
                    if (this.compound != null) {
                        GenericMassnahmenView.this.compoundChoser.setSelectedCompound(this.compound);
                        if (GenericMassnahmenView.this.compoundChoser.isSelectedCompound(this.compound)) {
                            GenericMassnahmenView.this.loadMeasures(this.compound);
                            return;
                        }
                    }
                    GenericMassnahmenView.this.viewer.setInput((Object)new PlaceHolder(Messages.GenericMassnahmenView_9));
                });
            }
            catch (Exception e) {
                ExceptionUtil.log(e, Messages.GenericMassnahmenView_10);
            }
            return Status.OK_STATUS;
        }
    }

    private final class LoadMeasures
    extends WorkspaceJob {
        private final ITVerbund itVerbund;

        private LoadMeasures(String name, ITVerbund itVerbund) {
            super(name);
            this.itVerbund = itVerbund;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            Activator.inheritVeriniceContextState();
            try {
                monitor.setTaskName(GenericMassnahmenView.this.getMeasureLoadTaskLabel());
                ++GenericMassnahmenView.this.loadBlockNumber;
                Properties filter = new Properties();
                filter.put("filter-date", GenericMassnahmenView.this.getDateProperty());
                if (GenericMassnahmenView.this.isDateSet) {
                    filter.put(GenericMassnahmenView.this.getDateProperty(), GenericMassnahmenView.this.getDateProperty());
                }
                if (GenericMassnahmenView.this.umsetzungFilter.getUmsetzungPatternSet() != null) {
                    filter.put("mnums_umsetzung", GenericMassnahmenView.this.umsetzungFilter.getUmsetzungPatternSet());
                }
                if (GenericMassnahmenView.this.siegelFilter.getPatternSet() != null) {
                    filter.put("mnums_siegel", GenericMassnahmenView.this.siegelFilter.getPatternSet());
                }
                FindMassnahmenForITVerbund command = new FindMassnahmenForITVerbund(this.itVerbund.getDbId(), GenericMassnahmenView.this.loadBlockNumber, filter, GenericMassnahmenView.this.getSortByProperty());
                command = (FindMassnahmenForITVerbund)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                int number = command.getNumber();
                if (GenericMassnahmenView.this.loadBlockNumber == 1) {
                    GenericMassnahmenView.this.allMassnahmen = command.getAll();
                } else {
                    GenericMassnahmenView.this.allMassnahmen.addAll(command.getAll());
                }
                Display.getDefault().asyncExec(() -> {
                    if (GenericMassnahmenView.this.viewer.getControl().isDisposed()) {
                        return;
                    }
                    GenericMassnahmenView.this.viewer.setInput(GenericMassnahmenView.this.allMassnahmen);
                    GenericMassnahmenView.this.compoundChoser.setEnabled(true);
                    int loaded = GenericMassnahmenView.this.loadBlockNumber * 100;
                    if (loaded > number) {
                        loaded = number;
                        GenericMassnahmenView.this.loadMoreAction.setEnabled(false);
                    }
                    String info = "(" + loaded + " of " + number + ")";
                    GenericMassnahmenView.this.loadMoreAction.setText(info);
                });
            }
            catch (Exception e) {
                Display.getDefault().asyncExec(() -> GenericMassnahmenView.this.compoundChoser.setEnabled(true));
                LOG.error((Object)"Error while loading massnahmen", (Throwable)e);
                ExceptionUtil.log(e, GenericMassnahmenView.this.getTaskErrorLabel());
            }
            return Status.OK_STATUS;
        }
    }

    private class MassnahmenCompoundChoser
    extends ContributionItem {
        private Combo combo;
        private List<ITVerbund> elements;

        private MassnahmenCompoundChoser() {
        }

        public void fill(ToolBar parent, int index) {
            int toolItemWidth = 200;
            ToolItem ti = new ToolItem(parent, 2, index);
            this.combo = new Combo((Composite)parent, 12);
            if (this.elements != null) {
                this.updateCombo();
                this.combo.setEnabled(true);
            } else {
                this.combo.setEnabled(false);
                this.combo.add(Messages.GenericMassnahmenView_1);
                this.combo.select(0);
            }
            this.combo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    int s = MassnahmenCompoundChoser.this.combo.getSelectionIndex();
                    if (s == 0) {
                        GenericMassnahmenView.this.resetTable(true);
                    } else {
                        MassnahmenCompoundChoser.this.combo.setEnabled(false);
                        ((MassnahmenCompoundChoser)MassnahmenCompoundChoser.this).GenericMassnahmenView.this.loadBlockNumber = 0;
                        ((MassnahmenCompoundChoser)MassnahmenCompoundChoser.this).GenericMassnahmenView.this.loadMoreAction.setEnabled(true);
                        GenericMassnahmenView.this.loadMeasures(MassnahmenCompoundChoser.this.elements.get(s - 1));
                    }
                }
            });
            ti.setControl((Control)this.combo);
            ti.setWidth(200);
        }

        public boolean isDynamic() {
            return true;
        }

        ITVerbund getSelectedCompound() {
            int s = this.combo.getSelectionIndex();
            if (s == 0) {
                return null;
            }
            return this.elements.get(s - 1);
        }

        void setSelectedCompound(ITVerbund compound) {
            if (compound == null) {
                this.combo.select(0);
            }
            int count = 0;
            for (ITVerbund c : this.elements) {
                if (c.equals((Object)compound)) {
                    this.combo.select(count + 1);
                    return;
                }
                ++count;
            }
            this.combo.select(0);
        }

        boolean isSelectedCompound(ITVerbund compound) {
            int s = this.combo.getSelectionIndex();
            if (s == 0) {
                return false;
            }
            return this.elements.get(s - 1).equals((Object)compound);
        }

        void setEnabled(boolean b) {
            if (this.combo != null) {
                this.combo.setEnabled(b);
            }
        }

        void setElements(List<ITVerbund> elements) {
            this.elements = elements;
            if (this.combo != null) {
                this.updateCombo();
            }
        }

        void updateCombo() {
            this.combo.removeAll();
            this.combo.add(Messages.GenericMassnahmenView_2);
            this.combo.select(0);
            for (ITVerbund c : this.elements) {
                this.combo.add(c.getTitle());
            }
        }

        void compoundAdded(ITVerbund compound) {
            this.elements.add(compound);
            this.combo.add(compound.getTitle());
        }

        void compoundRemoved(ITVerbund compound) {
            int i = this.combo.getSelectionIndex();
            if (i > 0 && this.elements.get(i - 1).equals((Object)compound)) {
                this.combo.select(0);
                GenericMassnahmenView.this.resetTable(true);
            }
            i = 0;
            for (ITVerbund c : this.elements) {
                if (c.equals((Object)compound)) {
                    this.combo.remove(i + 1);
                    this.elements.remove(i);
                    return;
                }
                ++i;
            }
        }

        void compoundChanged(ITVerbund compound) {
            int i = 0;
            for (ITVerbund c : this.elements) {
                if (c.equals((Object)compound)) {
                    this.elements.set(i, compound);
                    if (this.combo.getSelectionIndex() == i + 1) {
                        this.combo.setItem(i + 1, compound.getTitle());
                        this.combo.select(i + 1);
                    } else {
                        this.combo.setItem(i + 1, compound.getTitle());
                    }
                    return;
                }
                ++i;
            }
        }
    }

    protected static class SortSelectionAdapter
    extends SelectionAdapter {
        private GenericMassnahmenView view;
        private TableColumn column;
        private int index;

        public SortSelectionAdapter(GenericMassnahmenView view, TableColumn column, int index) {
            this.view = view;
            this.column = column;
            this.index = index;
        }

        public void widgetSelected(SelectionEvent e) {
            this.view.createSorter().setColumn(this.index);
            int dir = this.view.viewer.getTable().getSortDirection();
            dir = this.view.viewer.getTable().getSortColumn() == this.column ? (dir == 128 ? 1024 : 128) : 1024;
            this.view.viewer.getTable().setSortDirection(dir);
            this.view.viewer.getTable().setSortColumn(this.column);
            this.view.viewer.refresh();
        }
    }

    protected static class TableSorter
    extends ViewerComparator {
        private int propertyIndex = 1;
        private static final int DEFAULT_SORT_COLUMN = 1;
        protected static final int DESCENDING = 1;
        protected static final int ASCENDING = 0;
        private int direction = 0;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = this.direction == 0 ? 1 : 0;
            } else {
                this.propertyIndex = column;
                this.direction = 0;
            }
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            int rc = 0;
            try {
                TodoViewItem mn1 = (TodoViewItem)o1;
                TodoViewItem mn2 = (TodoViewItem)o2;
                if (o1 == null) {
                    if (o2 != null) {
                        rc = 1;
                    }
                } else if (o2 == null) {
                    rc = -1;
                } else {
                    switch (this.propertyIndex) {
                        case 0: {
                            rc = this.sortByString(mn1.getUmsetzung(), mn2.getUmsetzung());
                            break;
                        }
                        case 1: {
                            rc = this.sortByDate(mn1.getUmsetzungBis(), mn2.getUmsetzungBis());
                            break;
                        }
                        case 2: {
                            rc = this.sortByString(mn1.getUmsetzungDurch(), mn2.getUmsetzungDurch());
                            break;
                        }
                        case 3: {
                            rc = this.sortByString(String.valueOf(mn1.getStufe()), String.valueOf(mn2.getStufe()));
                            break;
                        }
                        case 4: {
                            rc = this.sortByString(mn1.getParentTitle(), mn2.getParentTitle());
                            break;
                        }
                        case 5: {
                            rc = this.sortByString(mn1.getTitle(), mn2.getTitle());
                            break;
                        }
                        default: {
                            rc = 0;
                        }
                    }
                }
                if (this.direction == 1) {
                    rc = -rc;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while sorting elements", (Throwable)e);
            }
            return rc;
        }

        protected int sortByString(String s1, String s2) {
            int rc = 0;
            if (s1 == null) {
                if (s2 != null) {
                    rc = 1;
                }
            } else {
                rc = s2 == null ? -1 : s1.compareTo(s2);
            }
            return rc;
        }

        protected int sortByDate(Date date1, Date date2) {
            if (date1 == null) {
                if (date2 == null) {
                    return 0;
                }
                return 1;
            }
            if (date2 == null) {
                return -1;
            }
            return date1.compareTo(date2);
        }

        public int getPropertyIndex() {
            return this.propertyIndex;
        }

        public int getDirection() {
            return this.direction;
        }
    }
}

