/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.views.AttachmentContentProvider;
import sernet.gs.ui.rcp.main.bsi.views.AttachmentImageCellProvider;
import sernet.gs.ui.rcp.main.bsi.views.FileDropTarget;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.iso27k.rcp.ILinkedWithEditorView;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.LinkWithEditorPartListener;
import sernet.verinice.model.bsi.Addition;
import sernet.verinice.model.bsi.Attachment;
import sernet.verinice.model.bsi.AttachmentFile;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.service.commands.LoadAttachmentFile;
import sernet.verinice.service.commands.LoadAttachments;
import sernet.verinice.service.commands.LoadFileSizeLimit;
import sernet.verinice.service.commands.crud.DeleteNote;

public class FileView
extends RightsEnabledView
implements ILinkedWithEditorView,
IPropertyChangeListener {
    static final Logger LOG = Logger.getLogger(FileView.class);
    public static final String ID = "sernet.gs.ui.rcp.main.bsi.views.FileView";
    private static final int DEFAULT_THUMBNAIL_SIZE = 0;
    private static Map<String, String> mimeImageMap = new HashMap<String, String>();
    private ICommandService commandService;
    private TableViewer viewer;
    private TableViewerColumn imageColumn;
    private TableComparator tableSorter = new TableComparator();
    private List<Attachment> attachmentList;
    private AttachmentContentProvider contentProvider = new AttachmentContentProvider(this);
    private RightsEnabledAction addFileAction;
    private RightsEnabledAction deleteFileAction;
    private Action saveCopyAction;
    private Action openAction;
    private Action toggleLinkAction;
    private boolean isLinkingActive = true;
    private CnATreeElement currentCnaElement;
    private IModelLoadListener modelLoadListener;
    private IPartListener2 linkWithEditorPartListener = new LinkWithEditorPartListener(this);
    private AttachmentImageCellProvider imageCellProvider = null;
    private Integer fileSizeMax;
    private ISelectionListener postSelectionListener;

    static {
        mimeImageMap.putAll(Stream.of(Attachment.getArchiveMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-archive.png")));
        mimeImageMap.putAll(Stream.of(Attachment.getAudioMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-audio.png")));
        mimeImageMap.putAll(Stream.of(Attachment.getDocumentMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-document.png")));
        mimeImageMap.putAll(Stream.of(Attachment.getHtmlMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-html.png")));
        mimeImageMap.putAll(Stream.of(Attachment.getImageMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-image.png")));
        mimeImageMap.putAll(Stream.of(Attachment.getPdfMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-pdf.png")));
        mimeImageMap.putAll(Stream.of(Attachment.getPdfMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-pdf.png")));
        mimeImageMap.putAll(Stream.of(Attachment.getSpreadsheetMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-spreadsheet.png")));
        mimeImageMap.putAll(Stream.of(Attachment.getTextMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-text.png")));
        mimeImageMap.putAll(Stream.of(Attachment.getVideoMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-video.png")));
        mimeImageMap.putAll(Stream.of(Attachment.getXmlMimeTypes()).collect(Collectors.toMap(Function.identity(), k -> "mime-xml.png")));
    }

    public FileView() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.postSelectionListener = this::pageSelectionChanged;
    }

    @Override
    public String getRightID() {
        return "files";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.initView(parent);
    }

    private void initView(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        try {
            this.createTable(parent);
            this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
            this.getSite().getPage().addPostSelectionListener(this.postSelectionListener);
            this.viewer.setInput((Object)new PlaceHolder(Messages.FileView_0));
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.BrowserView_3);
            LOG.error((Object)"Error while creating control", (Throwable)e);
        }
        this.makeActions();
        this.hookActions();
        this.hookDND();
        this.fillLocalToolBar();
        this.getSite().getPage().addPartListener(this.linkWithEditorPartListener);
    }

    private void hookDND() {
        new FileDropTarget(this);
    }

    private void createTable(Composite parent) {
        int widthHeightPadding = 4;
        int itemColumnWidth = 26;
        int filenameColumnWidth = 152;
        int mimeTypeColumnWidth = 50;
        int textColumnWidth = 250;
        int dateColumnWidth = 120;
        int versionColumnWidth = 60;
        int sizeColumnWidth = 50;
        this.viewer = new TableViewer(parent, 66306);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AttachmentLabelProvider());
        Table table = this.viewer.getTable();
        table.addListener(41, event -> {
            int n = event.height = this.getThumbnailSize() + 4;
        });
        this.imageColumn = new TableViewerColumn(this.viewer, 16384);
        this.imageColumn.setLabelProvider(this.getImageCellProvider());
        if (this.getThumbnailSize() > 0) {
            this.imageColumn.getColumn().setWidth(this.getThumbnailSize() + 4);
        } else {
            this.imageColumn.getColumn().setWidth(0);
        }
        int columnIndex = 0;
        TableColumn iconColumn = new TableColumn(table, 16384);
        iconColumn.setWidth(26);
        iconColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, iconColumn, columnIndex));
        TableColumn fileNameColumn = new TableColumn(table, 16384);
        fileNameColumn.setText(Messages.FileView_2);
        fileNameColumn.setWidth(152);
        fileNameColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, fileNameColumn, ++columnIndex));
        TableColumn mimeTypeColumn = new TableColumn(table, 16384);
        mimeTypeColumn.setText(Messages.FileView_3);
        mimeTypeColumn.setWidth(50);
        mimeTypeColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, mimeTypeColumn, ++columnIndex));
        TableColumn textColumn = new TableColumn(table, 16384);
        textColumn.setText(Messages.FileView_4);
        textColumn.setWidth(250);
        textColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, textColumn, ++columnIndex));
        ++columnIndex;
        TableColumn dateColumn = new TableColumn(table, 16384);
        dateColumn.setText(Messages.FileView_5);
        dateColumn.setWidth(120);
        dateColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, dateColumn, 4));
        TableColumn versionColumn = new TableColumn(table, 16384);
        versionColumn.setText(Messages.FileView_6);
        versionColumn.setWidth(60);
        versionColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, versionColumn, ++columnIndex));
        TableColumn sizeColumn = new TableColumn(table, 16384);
        sizeColumn.setText(Messages.FileView_35);
        sizeColumn.setWidth(50);
        sizeColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, sizeColumn, ++columnIndex));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setComparator((ViewerComparator)this.tableSorter);
        ((TableComparator)this.viewer.getComparator()).setColumn(1);
    }

    private CellLabelProvider getImageCellProvider() {
        if (this.imageCellProvider == null) {
            this.imageCellProvider = new AttachmentImageCellProvider(this.getThumbnailSize());
        }
        return this.imageCellProvider;
    }

    private int getThumbnailSize() {
        int size = 0;
        String sizeString = Activator.getDefault().getPreferenceStore().getString("thumbnail_size");
        if (sizeString != null && !sizeString.isEmpty()) {
            size = Integer.parseInt(sizeString);
        }
        return size;
    }

    private void hookActions() {
        this.viewer.addDoubleClickListener(event -> {
            ISelection selection = event.getViewer().getSelection();
            if (!selection.isEmpty()) {
                Object sel = ((IStructuredSelection)selection).getFirstElement();
                EditorFactory.getInstance().openEditor(sel);
            }
        });
        this.viewer.addSelectionChangedListener(event -> {
            this.saveCopyAction.setEnabled(true);
            this.openAction.setEnabled(true);
            this.deleteFileAction.setEnabled(this.isCnATreeElementEditable());
        });
    }

    protected void pageSelectionChanged(IWorkbenchPart part, ISelection selection) {
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (part == this) {
            this.openAction.setEnabled(element != null);
            this.saveCopyAction.setEnabled(element != null);
            this.deleteFileAction.setEnabled(element != null && this.deleteFileAction.checkRights() && this.isCnATreeElementEditable());
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            this.openAction.setEnabled(false);
            this.saveCopyAction.setEnabled(false);
            this.deleteFileAction.setEnabled(false);
            return;
        }
        this.elementSelected(element);
        if (element instanceof CnATreeElement) {
            this.setNewInput((CnATreeElement)element);
        }
    }

    protected void elementSelected(Object element) {
        try {
            if (element instanceof CnATreeElement) {
                this.setCurrentCnaElement((CnATreeElement)element);
                this.addFileAction.setEnabled(this.addFileAction.checkRights() && this.isCnATreeElementEditable());
                this.loadFiles();
            } else {
                this.addFileAction.setEnabled(false);
            }
            Object selectedElement = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            if (selectedElement instanceof Attachment) {
                Attachment att = (Attachment)selectedElement;
                this.openAction.setEnabled(att != null);
                this.saveCopyAction.setEnabled(att != null);
                this.deleteFileAction.setEnabled(att != null && this.deleteFileAction.checkRights() && this.isCnATreeElementEditable());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading notes", (Throwable)e);
        }
    }

    private boolean isCnATreeElementEditable() {
        return this.currentCnaElement != null && CnAElementHome.getInstance().isNewChildAllowed(this.currentCnaElement);
    }

    protected void startInitDataJob() {
        WorkspaceJob initDataJob = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask("", -1);
                        Activator.inheritVeriniceContextState();
                        FileView.this.loadFiles();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while loading data.", (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", "Error while loading data.", (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleInitJob(initDataJob);
    }

    public void loadFiles() {
        try {
            Integer id = null;
            if (this.isLinkingActive()) {
                if (this.getCurrentCnaElement() != null) {
                    id = this.getCurrentCnaElement().getDbId();
                } else {
                    return;
                }
            }
            LoadAttachments command = new LoadAttachments(id);
            command = (LoadAttachments)this.getCommandService().executeCommand((ICommand)command);
            this.attachmentList = command.getAttachmentList();
            if (this.attachmentList != null && !this.attachmentList.isEmpty()) {
                Display.getDefault().syncExec(() -> this.viewer.setInput(this.attachmentList));
                for (Attachment attachment : this.attachmentList) {
                    if (this.getCurrentCnaElement() != null) {
                        attachment.setCnAElementTitel(this.getCurrentCnaElement().getTitle());
                    }
                    attachment.addListener(this::loadFiles);
                }
            } else {
                this.viewer.setInput((Object)new PlaceHolder(Messages.FileView_0));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading attachment", (Throwable)e);
            ExceptionUtil.log(e, "Error while attachment notes");
        }
    }

    protected void editFile(Attachment attachment) {
        EditorFactory.getInstance().openEditor(attachment);
    }

    protected void deleteFile(Attachment attachment) {
        DeleteNote command = new DeleteNote((Addition)attachment);
        try {
            this.getCommandService().executeCommand((ICommand)command);
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while saving attachment", (Throwable)e);
            ExceptionUtil.log(e, Messages.FileView_13);
        }
        this.loadFiles();
    }

    @Override
    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void propertyChange(PropertyChangeEvent changeEvent) {
        int thumbnailWidthPadding = 4;
        if (changeEvent.getProperty().equals("thumbnail_size") && this.imageCellProvider != null && !changeEvent.getNewValue().equals(changeEvent.getOldValue())) {
            this.imageCellProvider.setThumbSize(Integer.valueOf(changeEvent.getNewValue().toString()));
            this.imageCellProvider.clearCache();
            if (this.getThumbnailSize() > 0) {
                this.imageColumn.getColumn().setWidth(this.getThumbnailSize() + 4);
            } else {
                this.imageColumn.getColumn().setWidth(0);
            }
            this.loadFiles();
        }
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.toggleLinkAction);
        manager.add((IAction)this.addFileAction);
        manager.add((IAction)this.deleteFileAction);
        manager.add((IAction)this.saveCopyAction);
        manager.add((IAction)this.openAction);
    }

    private void makeActions() {
        this.addFileAction = new RightsEnabledAction("addfile"){

            @Override
            public void doRun() {
                IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
                FileDialog fd = new FileDialog(FileView.this.getSite().getShell());
                fd.setText(Messages.FileView_14);
                String dir = prefStore.getString("default_folder_addfile");
                fd.setFilterPath(dir);
                String selected = fd.open();
                if (selected != null && selected.length() > 0) {
                    String path = FilenameUtils.getPath((String)selected);
                    prefStore.setValue("default_folder_addfile", path);
                    FileView.this.createAndOpenAttachment(selected);
                }
            }
        };
        this.addFileAction.setText(Messages.FileView_16);
        this.addFileAction.setToolTipText(Messages.FileView_17);
        this.addFileAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("note-new.png"));
        this.addFileAction.setEnabled(false);
        this.deleteFileAction = new RightsEnabledAction("deletefile"){

            @Override
            public void doRun() {
                int count = ((IStructuredSelection)FileView.this.viewer.getSelection()).size();
                boolean confirm = MessageDialog.openConfirm((Shell)FileView.this.getViewer().getControl().getShell(), (String)Messages.FileView_18, (String)NLS.bind((String)Messages.FileView_19, (Object)count));
                if (!confirm) {
                    return;
                }
                FileView.this.deleteAttachments();
                FileView.this.loadFiles();
            }
        };
        this.deleteFileAction.setText(Messages.FileView_23);
        this.deleteFileAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("delete.png"));
        this.deleteFileAction.setEnabled(false);
        this.saveCopyAction = new Action(){

            public void run() {
                Attachment attachment = (Attachment)((IStructuredSelection)FileView.this.viewer.getSelection()).getFirstElement();
                FileView.this.saveCopy(attachment);
            }
        };
        this.saveCopyAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("save.png"));
        this.saveCopyAction.setEnabled(false);
        this.openAction = new Action(){

            public void run() {
                FileView.this.openFile();
            }
        };
        this.openAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("view.png"));
        this.openAction.setEnabled(false);
        this.toggleLinkAction = new RightsEnabledAction("showallfiles", Messages.FileView_24, 2){

            @Override
            public void doRun() {
                FileView.this.isLinkingActive = !FileView.this.isLinkingActive;
                FileView.this.toggleLinkAction.setChecked(FileView.this.isLinkingActive());
                FileView.this.checkModelAndLoadFiles();
            }
        };
        this.toggleLinkAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("linked.gif"));
        this.toggleLinkAction.setChecked(this.isLinkingActive());
    }

    private void openFile() {
        Attachment attachment = (Attachment)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (attachment != null) {
            try {
                LoadAttachmentFile command = new LoadAttachmentFile(attachment.getDbId());
                command = (LoadAttachmentFile)this.getCommandService().executeCommand((ICommand)command);
                AttachmentFile attachmentFile = command.getAttachmentFile();
                String tempDir = System.getProperty("java.io.tmpdir");
                if (attachmentFile != null && tempDir != null) {
                    if (!tempDir.endsWith(String.valueOf(File.separatorChar))) {
                        tempDir = String.valueOf(tempDir) + File.separatorChar;
                    }
                    String fileName = attachment.getFileName();
                    fileName = Paths.get(fileName, new String[0]).getFileName().toString();
                    String path = String.valueOf(tempDir) + fileName;
                    try {
                        attachmentFile.writeFileData(path);
                        Program.launch((String)path);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error while loading attachment", (Throwable)e);
                        ExceptionUtil.log(e, Messages.FileView_27);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while loading attachment", (Throwable)e);
                ExceptionUtil.log(e, Messages.FileView_27);
            }
        }
    }

    protected void saveCopy(Attachment attachment) {
        FileDialog fd = new FileDialog(this.getSite().getShell(), 8192);
        fd.setText(Messages.FileView_30);
        fd.setFilterPath("~");
        fd.setFileName(attachment.getFileName());
        String selected = fd.open();
        if (selected != null) {
            try {
                LoadAttachmentFile command = new LoadAttachmentFile(attachment.getDbId());
                command = (LoadAttachmentFile)this.getCommandService().executeCommand((ICommand)command);
                AttachmentFile attachmentFile = command.getAttachmentFile();
                attachmentFile.writeFileData(selected);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("File saved: " + selected));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while saving file", (Throwable)e);
                ExceptionUtil.log(e, Messages.FileView_34);
            }
        }
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    public CnATreeElement getCurrentCnaElement() {
        return this.currentCnaElement;
    }

    public void setCurrentCnaElement(CnATreeElement currentCnaElement) {
        this.currentCnaElement = currentCnaElement;
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePostSelectionListener(this.postSelectionListener);
        this.getSite().getPage().removePartListener(this.linkWithEditorPartListener);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.attachmentList != null) {
            for (Attachment attachment : this.attachmentList) {
                attachment.removeAllListener();
            }
        }
    }

    public static String getImageForMimeType(String mimeType) {
        return mimeImageMap.get(mimeType);
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void editorActivated(IEditorPart editor) {
        if (!this.isLinkingActive() || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this) || editor == null) {
            return;
        }
        CnATreeElement element = BSIElementEditorInput.extractElement(editor);
        if (element == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Element in editor :" + element.getUuid()));
            LOG.debug((Object)"Loading attached files of element now...");
        }
        this.elementSelected(element);
    }

    private boolean isLinkingActive() {
        return this.isLinkingActive;
    }

    private void setNewInput(CnATreeElement elmt) {
        this.setViewTitle(String.valueOf(Messages.FileView_7) + " " + elmt.getTitle());
    }

    private void setViewTitle(String title) {
        this.setContentDescription(title);
    }

    private void createAndOpenAttachment(String selected) {
        File file = new File(selected);
        if (file.isDirectory()) {
            return;
        }
        long size = file.length();
        if (AttachmentFile.convertByteToMB((long)size) > (double)this.getMaxFileSizeInMB()) {
            String readableSize = AttachmentFile.formatByteToMB((long)size);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.FileView_10, (String)NLS.bind((String)Messages.FileView_11, (Object)readableSize, (Object)this.getMaxFileSizeInMB()));
            return;
        }
        Attachment attachment = new Attachment();
        attachment.setCnATreeElement(this.getCurrentCnaElement());
        attachment.setCnAElementTitel(this.getCurrentCnaElement().getTitle());
        attachment.setTitel(file.getName());
        attachment.setDate(Calendar.getInstance().getTime());
        attachment.setFilePath(selected);
        attachment.setFileSize(String.valueOf(size));
        attachment.addListener(this::loadFiles);
        EditorFactory.getInstance().openEditor(attachment);
    }

    private int getMaxFileSizeInMB() {
        if (this.fileSizeMax == null) {
            this.fileSizeMax = this.loadFileSizeMax();
        }
        return this.fileSizeMax;
    }

    private Integer loadFileSizeMax() {
        LoadFileSizeLimit loadFileSizeLimit = new LoadFileSizeLimit();
        try {
            loadFileSizeLimit = (LoadFileSizeLimit)this.getCommandService().executeCommand((ICommand)loadFileSizeLimit);
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while saving note", (Throwable)e);
        }
        return loadFileSizeLimit.getFileSizeMax();
    }

    private void deleteAttachments() {
        for (Attachment sel : (IStructuredSelection)this.viewer.getSelection()) {
            DeleteNote command = new DeleteNote((Addition)sel);
            try {
                this.getCommandService().executeCommand((ICommand)command);
            }
            catch (CommandException e) {
                LOG.error((Object)"Error while saving note", (Throwable)e);
                ExceptionUtil.log(e, Messages.FileView_22);
            }
        }
    }

    private void checkModelAndLoadFiles() {
        if (CnAElementFactory.isModelLoaded()) {
            this.loadFiles();
        } else if (this.modelLoadListener == null) {
            this.modelLoadListener = new DefaultModelLoadListener(){

                @Override
                public void loaded(BSIModel model) {
                    FileView.this.startInitDataJob();
                }
            };
            CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener);
        }
    }

    private static class AttachmentLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AttachmentLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof PlaceHolder) {
                return null;
            }
            Attachment attachment = (Attachment)element;
            if (columnIndex == 1) {
                String mimeType = attachment.getMimeType() != null ? attachment.getMimeType().toLowerCase() : "";
                String imageType = mimeImageMap.get(mimeType);
                if (imageType != null) {
                    return ImageCache.getInstance().getImage(mimeImageMap.get(mimeType));
                }
                return ImageCache.getInstance().getImage("question.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            block13: {
                try {
                    if (!(element instanceof PlaceHolder)) break block13;
                    if (columnIndex == 1) {
                        PlaceHolder ph = (PlaceHolder)element;
                        return ph.getTitle();
                    }
                    return "";
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while getting column text", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
            Attachment attachment = (Attachment)element;
            switch (columnIndex) {
                case 2: {
                    return attachment.getTitel();
                }
                case 3: {
                    return attachment.getMimeType();
                }
                case 4: {
                    return attachment.getText();
                }
                case 5: {
                    return attachment.getDate() != null ? dateFormat.format(attachment.getDate()) : null;
                }
                case 6: {
                    return attachment.getVersion();
                }
                case 7: {
                    if (attachment.getFileSize() != null) {
                        String size = attachment.getFileSize();
                        return AttachmentLabelProvider.humanReadableByteCount(Integer.parseInt(size), false);
                    }
                    return "0 KB";
                }
            }
            return null;
        }

        private static String humanReadableByteCount(long bytes, boolean si) {
            int unit;
            int n = unit = si ? 1000 : 1024;
            if (bytes < (long)unit) {
                return String.valueOf(bytes) + " B";
            }
            int exp = (int)(Math.log(bytes) / Math.log(unit));
            String pre = String.valueOf((si ? "kMGTPE" : "KMGTPE").charAt(exp - 1));
            return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
        }
    }

    private static class SortSelectionAdapter
    extends SelectionAdapter {
        private FileView fileView;
        private TableColumn column;
        private int index;

        public SortSelectionAdapter(FileView fileView, TableColumn column, int index) {
            this.fileView = fileView;
            this.column = column;
            this.index = index;
        }

        public void widgetSelected(SelectionEvent e) {
            this.fileView.tableSorter.setColumn(this.index);
            int dir = this.fileView.viewer.getTable().getSortDirection();
            dir = this.fileView.viewer.getTable().getSortColumn() == this.column ? (dir == 128 ? 1024 : 128) : 1024;
            this.fileView.viewer.getTable().setSortDirection(dir);
            this.fileView.viewer.getTable().setSortColumn(this.column);
            this.fileView.viewer.refresh();
        }
    }

    private static class TableComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DEFAULT_SORT_COLUMN = 0;
        private static final int DESCENDING = 1;
        private static final int ASCENDING = 0;
        private int direction = 0;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = this.direction == 0 ? 1 : 0;
            } else {
                this.propertyIndex = column;
                this.direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Attachment a1 = (Attachment)e1;
            Attachment a2 = (Attachment)e2;
            int rc = 0;
            rc = e1 == null && e2 != null ? 1 : (e2 == null && e1 != null ? -1 : this.compareNullSafe(a1, a2));
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }

        private int compareNullSafe(Attachment a1, Attachment a2) {
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    String mimeType1 = a1.getMimeType();
                    String mimeType2 = a2.getMimeType();
                    if (mimeType1 == null || mimeType2 == null) {
                        return 0;
                    }
                    String image1 = mimeImageMap.get(mimeType1);
                    String image2 = mimeImageMap.get(mimeType2);
                    if (image1 == null || image2 == null) break;
                    rc = image1.compareTo(image2);
                    break;
                }
                case 1: {
                    NumericStringComparator nsc = new NumericStringComparator();
                    rc = nsc.compare((Object)a1.getFileName().toLowerCase(), (Object)a2.getFileName().toLowerCase());
                    break;
                }
                case 2: {
                    String mimeType1 = a1.getMimeType();
                    String mimeType2 = a2.getMimeType();
                    if (mimeType1 == null || mimeType2 == null) {
                        return 0;
                    }
                    rc = mimeType1.compareTo(mimeType2);
                    break;
                }
                case 3: {
                    rc = a1.getText().compareTo(a2.getText());
                    break;
                }
                case 4: {
                    rc = a1.getDate().compareTo(a2.getDate());
                    break;
                }
                case 5: {
                    rc = a1.getVersion().compareTo(a2.getVersion());
                    break;
                }
                case 6: {
                    int a2Size;
                    int a1Size = a1.getFileSize() != null ? Integer.parseInt(a1.getFileSize()) : 0;
                    int n = a2Size = a2.getFileSize() != null ? Integer.parseInt(a2.getFileSize()) : 0;
                    rc = a2Size > a1Size ? 1 : (a1Size > a2Size ? -1 : 0);
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            return rc;
        }
    }
}

