/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.io.File;
import java.util.Calendar;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.views.FileView;
import sernet.verinice.model.bsi.Addition;
import sernet.verinice.model.bsi.Attachment;

public class FileDropTarget
extends DropTargetAdapter {
    private FileView view;

    public FileDropTarget(FileView view) {
        this.view = view;
        DropTarget target = new DropTarget(view.getViewer().getControl(), 3);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)this);
    }

    public void drop(DropTargetEvent event) {
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            String[] files = (String[])event.data;
            int i = 0;
            while (i < files.length) {
                String selected = files[i];
                if (selected != null && selected.length() > 0) {
                    File file = new File(selected);
                    if (file.isDirectory()) {
                        File[] dirFiles;
                        File[] fileArray = dirFiles = file.listFiles();
                        int n = dirFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File dirFile = fileArray[n2];
                            this.createFile(dirFile.getAbsolutePath());
                            ++n2;
                        }
                    }
                    this.createFile(selected);
                }
                ++i;
            }
        }
    }

    private void createFile(String selected) {
        File file = new File(selected);
        if (file.isDirectory()) {
            return;
        }
        Attachment attachment = new Attachment();
        attachment.setCnATreeElement(this.view.getCurrentCnaElement());
        attachment.setCnAElementTitel(this.view.getCurrentCnaElement().getTitle());
        attachment.setTitel(file.getName());
        attachment.setDate(Calendar.getInstance().getTime());
        attachment.setFilePath(selected);
        attachment.addListener(new Addition.INoteChangedListener(){

            public void noteChanged() {
                FileDropTarget.this.view.loadFiles();
            }
        });
        attachment.setFileSize(String.valueOf(file.length()));
        EditorFactory.getInstance().openEditor(attachment);
    }
}

