/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.views.DocumentContentProvider;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.PropertyType;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.DocumentLink;
import sernet.verinice.model.bsi.DocumentReference;
import sernet.verinice.rcp.PartListenerAdapter;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.service.commands.task.FindURLs;

public class DocumentView
extends RightsEnabledView {
    public static final String ID = "sernet.gs.ui.rcp.main.documentview";
    private TreeViewer viewer;
    private Action refreshAction;
    private IModelLoadListener loadListener = new DefaultModelLoadListener(){

        @Override
        public void closed(BSIModel model) {
            this.setInputAsync();
        }

        @Override
        public void loaded(BSIModel model) {
            this.setInputAsync();
        }

        private void setInputAsync() {
            Display.getDefault().asyncExec(() -> {
                if (DocumentView.this.viewer.getContentProvider() != null) {
                    DocumentView.this.setInput();
                }
            });
        }
    };

    @Override
    public String getRightID() {
        return "documentview";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    protected void setInput() {
        try {
            List types = HUITypeFactory.getInstance().getURLPropertyTypes();
            Set allIDs = types.stream().map(PropertyType::getId).collect(Collectors.toSet());
            FindURLs command = new FindURLs(allIDs);
            command = (FindURLs)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            this.viewer.setInput((Object)command.getUrls());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        int colum1Width = 200;
        int colum2Width = 100;
        int colum3Width = 100;
        this.viewer = new TreeViewer(parent, 65538);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setHeaderVisible(true);
        TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof DocumentLink) {
                    return ((DocumentLink)element).getName();
                }
                return "";
            }
        });
        column.getColumn().setText(Messages.DocumentView_2);
        TreeViewerColumn column2 = new TreeViewerColumn(this.viewer, 0);
        column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof DocumentLink) {
                    return ((DocumentLink)element).getHref();
                }
                return "";
            }
        });
        column2.getColumn().setText(Messages.DocumentView_4);
        TreeViewerColumn column3 = new TreeViewerColumn(this.viewer, 0);
        column3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof DocumentReference) {
                    DocumentReference docref = (DocumentReference)element;
                    return docref.getCnaTreeElement().getTitle();
                }
                return "";
            }
        });
        column3.getColumn().setText(Messages.DocumentView_6);
        this.viewer.setContentProvider((IContentProvider)new DocumentContentProvider(this.viewer));
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof DocumentLink && e2 instanceof DocumentLink) {
                    DocumentLink link1 = (DocumentLink)e1;
                    DocumentLink link2 = (DocumentLink)e2;
                    return link1.getName().compareTo(link2.getName());
                }
                if (e1 instanceof DocumentReference && e2 instanceof DocumentReference) {
                    DocumentReference ref1 = (DocumentReference)e1;
                    DocumentReference ref2 = (DocumentReference)e2;
                    return ref1.getCnaTreeElement().getTitle().compareTo(ref2.getCnaTreeElement().getTitle());
                }
                return 0;
            }
        });
        column.getColumn().setWidth(200);
        column2.getColumn().setWidth(100);
        column3.getColumn().setWidth(100);
        this.makeActions();
        this.addDoubleClickListener();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        CnAElementFactory.getInstance().addLoadListener(this.loadListener);
        this.fillLocalToolBar();
        this.addPartLister();
    }

    @Override
    public void setFocus() {
    }

    public void dispose() {
        CnAElementFactory.getInstance().removeLoadListener(this.loadListener);
        super.dispose();
    }

    private void makeActions() {
        this.refreshAction = new Action(Messages.DocumentView_7, 0){

            public void run() {
                DocumentView.this.setInput();
            }
        };
        this.refreshAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("arrow_refresh.png"));
    }

    private void addDoubleClickListener() {
        this.viewer.addDoubleClickListener(event -> {
            Object sel = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            if (sel instanceof DocumentReference) {
                DocumentReference ref = (DocumentReference)sel;
                EditorFactory.getInstance().openEditor(ref.getCnaTreeElement());
            } else if (sel instanceof DocumentLink) {
                DocumentLink link = (DocumentLink)sel;
                Program.launch((String)link.getHref());
            }
        });
    }

    private void addPartLister() {
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)new PartListenerAdapter(){

            @Override
            public void partVisible(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part == DocumentView.this && (!Activator.getDefault().isStandalone() || Activator.getDefault().getInternalServer().isRunning())) {
                    DocumentView.this.setInput();
                }
                super.partVisible(partRef);
            }

            @Override
            public void partClosed(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part == DocumentView.this) {
                    DocumentView.this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
                }
                super.partClosed(partRef);
            }
        });
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.refreshAction);
    }
}

