/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.URLUtil;
import sernet.verinice.model.bsi.DocumentLink;
import sernet.verinice.model.bsi.DocumentLinkRoot;
import sernet.verinice.model.bsi.DocumentReference;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.NullListener;

public class DocumentContentProvider
extends NullListener
implements ITreeContentProvider {
    private TreeViewer viewer;
    private static final int ADD = 0;
    private static final int UPDATE = 1;
    private static final int REMOVE = 2;
    private static final int REFRESH = 3;
    private static final String DOCUMENT_PROPERTY_SUFFIX_GERMAN = "_dokument";
    private static final String DOCUMENT_PROPERTY_SUFFIX_ENGLISH = "_document";

    public DocumentContentProvider(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DocumentLink) {
            DocumentLink doclink = (DocumentLink)parentElement;
            Set children = doclink.getChildren();
            return children.toArray(new DocumentReference[children.size()]);
        }
        if (parentElement instanceof DocumentLinkRoot) {
            DocumentLinkRoot root = (DocumentLinkRoot)parentElement;
            return root.getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof DocumentReference) {
            DocumentReference ref = (DocumentReference)element;
            return ref.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof DocumentLink) {
            DocumentLink doclink = (DocumentLink)element;
            return !doclink.getChildren().isEmpty();
        }
        return false;
    }

    public void dispose() {
        if (CnAElementFactory.getLoadedModel() != null) {
            CnAElementFactory.getLoadedModel().removeBSIModelListener((IBSIModelListener)this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (CnAElementFactory.getLoadedModel() != null) {
            CnAElementFactory.getLoadedModel().removeBSIModelListener((IBSIModelListener)this);
            CnAElementFactory.getLoadedModel().addBSIModelListener((IBSIModelListener)this);
        }
        this.modelRefresh(null);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void childAdded(CnATreeElement category, CnATreeElement child) {
        if (this.hasDocumentProperty(child)) {
            this.updateViewer(0, child, category);
            this.modelRefresh(null);
        }
    }

    private boolean hasDocumentProperty(CnATreeElement element) {
        Activator.inheritVeriniceContextState();
        String[] stringArray = HUITypeFactory.getInstance().getEntityType(element.getEntityType().getId()).getAllPropertyTypeIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (this.isDocumentProperty(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getDocumentPropertyId(CnATreeElement element) {
        String[] stringArray = HUITypeFactory.getInstance().getEntityType(element.getEntityType().getId()).getAllPropertyTypeIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (this.isDocumentProperty(id)) {
                return id;
            }
            ++n2;
        }
        return null;
    }

    private boolean isDocumentProperty(String id) {
        return id != null && (id.contains(DOCUMENT_PROPERTY_SUFFIX_ENGLISH) || id.contains(DOCUMENT_PROPERTY_SUFFIX_GERMAN));
    }

    public void childChanged(CnATreeElement child) {
        try {
            if (this.hasDocumentProperty(child)) {
                DocumentLinkRoot dlr = (DocumentLinkRoot)this.viewer.getInput();
                this.setThreadSetViewerInput(this.addInputElement(dlr, child));
                this.modelRefresh(null);
            }
        }
        catch (Exception t) {
            Logger.getLogger(DocumentContentProvider.class).error((Object)"Error in changing documentlinkroot children:", (Throwable)t);
        }
    }

    public void childRemoved(CnATreeElement category, CnATreeElement child) {
        this.modelRefresh(null);
    }

    public void modelRefresh() {
        this.modelRefresh(null);
    }

    public void modelRefresh(Object source) {
        if (Display.getCurrent() != null) {
            this.viewer.refresh();
        } else {
            Display.getDefault().asyncExec(() -> this.viewer.refresh());
        }
    }

    void updateViewer(int type, Object child, Object parent) {
        if (Display.getCurrent() != null) {
            this.doUpdateViewer(type, child, parent);
            return;
        }
        Display.getDefault().asyncExec(() -> this.doUpdateViewer(type, child, parent));
    }

    private void doUpdateViewer(int type, Object child, Object parent) {
        switch (type) {
            case 0: {
                this.viewer.add(child, parent);
                return;
            }
            case 1: {
                this.viewer.update(child, new String[]{this.getDocumentPropertyId((CnATreeElement)child)});
                this.viewer.refresh(true);
                this.viewer.refresh();
                return;
            }
            case 2: {
                this.viewer.remove(child);
                return;
            }
            case 3: {
                this.viewer.refresh();
                return;
            }
        }
    }

    private DocumentLink getDocumentLink(CnATreeElement elmt) {
        String rawURL = elmt.getEntity().getPropertyValue(this.getDocumentPropertyId(elmt));
        String name = URLUtil.getName((String)rawURL);
        String url = URLUtil.getHref((String)rawURL);
        if (!name.isEmpty() && !url.isEmpty()) {
            return new DocumentLink(name, url);
        }
        return null;
    }

    private DocumentLinkRoot addInputElement(DocumentLinkRoot root, CnATreeElement elmt) {
        DocumentLink link = this.getDocumentLink(elmt);
        if (link != null && !this.isLinkContainedInRoot(root, link)) {
            root.addChild(link);
        }
        return root;
    }

    private boolean isLinkContainedInRoot(DocumentLinkRoot root, DocumentLink link) {
        DocumentLink[] documentLinkArray = root.getChildren();
        int n = documentLinkArray.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentLink child = documentLinkArray[n2];
            if (child != null && child.equals(link)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setThreadSetViewerInput(DocumentLinkRoot dlr) {
        Display display = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        display.asyncExec(() -> this.viewer.setInput((Object)dlr));
    }
}

