/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.verinice.model.bp.ImplementationStatus;
import sernet.verinice.model.bp.elements.BpRequirement;
import sernet.verinice.model.bp.elements.Safeguard;
import sernet.verinice.model.bp.groups.ImportBpGroup;
import sernet.verinice.model.bpm.TodoViewItem;
import sernet.verinice.model.bsi.CnAPlaceholder;
import sernet.verinice.model.bsi.ImportBsiGroup;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.FinishedRiskAnalysis;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Control;
import sernet.verinice.model.iso27k.Group;
import sernet.verinice.model.iso27k.IControl;
import sernet.verinice.model.iso27k.ImportIsoGroup;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.service.iso27k.ControlMaturityService;

public final class CnAImageProvider {
    private static final Map<String, String> IMAGE_NAME_BY_STATE;
    private static final ControlMaturityService CONTROL_MATURITY_SERVICE;

    static {
        CONTROL_MATURITY_SERVICE = new ControlMaturityService();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("mnums_umsetzung_nein", "16-em-cross.png");
        m.put("mnums_umsetzung_ja", "16-em-check.png");
        m.put("mnums_umsetzung_teilweise", "16-clock.png");
        m.put("mnums_umsetzung_entbehrlich", "progress_rem.gif");
        m.put("bp_safeguard_implementation_status_no", "16-em-cross.png");
        m.put("bp_safeguard_implementation_status_yes", "16-em-check.png");
        m.put("bp_safeguard_implementation_status_partially", "16-clock.png");
        m.put("bp_safeguard_implementation_status_na", "progress_rem.gif");
        IMAGE_NAME_BY_STATE = Collections.unmodifiableMap(m);
    }

    public static Image getImage(TodoViewItem elmt) {
        return CnAImageProvider.getImageByImplementationState(elmt.getUmsetzung());
    }

    public static Image getImage(CnATreeElement cnATreeElement) {
        return CnAImageProvider.getImage(cnATreeElement, false);
    }

    public static Image getImage(CnATreeElement cnATreeElement, boolean useGenericIconForISAControl) {
        Image customIcon;
        String customIconPath = cnATreeElement.getIconPath();
        ImageCache imageCache = ImageCache.getInstance();
        if (customIconPath != null && (customIcon = imageCache.getCustomImage(customIconPath)) != null) {
            return customIcon;
        }
        return CnAImageProvider.getDefaultImage(cnATreeElement, useGenericIconForISAControl);
    }

    private static Image getDefaultImage(CnATreeElement element, boolean useGenericIconForISAControl) {
        ImageCache imageCache = ImageCache.getInstance();
        Image image = null;
        if (!(element instanceof SamtTopic) || !useGenericIconForISAControl) {
            image = CnAImageProvider.findImageByImplementationState(element);
        }
        if (image != null) {
            return image;
        }
        if (element instanceof FinishedRiskAnalysis) {
            return imageCache.getImage("16-message-warn.png");
        }
        if (element instanceof GefaehrdungsUmsetzung) {
            return imageCache.getImage("dialog-warning.png");
        }
        if (element instanceof ImportBpGroup || element instanceof ImportIsoGroup || element instanceof ImportBsiGroup) {
            return imageCache.getImage("import.gif");
        }
        if (element instanceof CnAPlaceholder) {
            return imageCache.getImage("tree_explorer.gif");
        }
        if (element instanceof Group) {
            String elementType = ((Group)element).getChildTypes()[0];
            return imageCache.getImageForTypeId(elementType);
        }
        return imageCache.getImageForTypeId(element.getTypeId());
    }

    private static Image findImageByImplementationState(CnATreeElement element) {
        if (element instanceof Safeguard) {
            Safeguard safeguard = (Safeguard)element;
            safeguard = (Safeguard)Retriever.checkRetrieveElement((CnATreeElement)safeguard);
            ImplementationStatus status = safeguard.getImplementationStatus();
            Image implementationStatusImage = CnAImageProvider.getImageByImplementationStatus(status);
            Image typeImage = ImageCache.getInstance().getImage("base-protection/safeguard.png");
            return CnAImageProvider.createImageWithOverlay(implementationStatusImage, typeImage);
        }
        if (element instanceof BpRequirement) {
            BpRequirement requirement = (BpRequirement)element;
            requirement = (BpRequirement)Retriever.checkRetrieveElement((CnATreeElement)requirement);
            ImplementationStatus status = requirement.getImplementationStatus();
            Image implementationStatusImage = CnAImageProvider.getImageByImplementationStatus(status);
            Image typeImage = ImageCache.getInstance().getImage("base-protection/bp_requirement.png");
            return CnAImageProvider.createImageWithOverlay(implementationStatusImage, typeImage);
        }
        if (element instanceof Control) {
            Control control = (Control)element;
            return ImageCache.getInstance().getControlImplementationImage(control.getImplementation());
        }
        if (element instanceof SamtTopic) {
            SamtTopic topic = (SamtTopic)element;
            return ImageCache.getInstance().getControlImplementationImage(CONTROL_MATURITY_SERVICE.getIsaState((IControl)topic));
        }
        if (element instanceof MassnahmenUmsetzung) {
            MassnahmenUmsetzung mn = (MassnahmenUmsetzung)element;
            mn = (MassnahmenUmsetzung)Retriever.checkRetrieveElement((CnATreeElement)mn);
            String state = mn.getUmsetzung();
            return CnAImageProvider.getImageByImplementationState(state);
        }
        return null;
    }

    private static Image getImageByImplementationStatus(ImplementationStatus status) {
        String imageName;
        if (status == null) {
            imageName = "exclamation.png";
        } else {
            switch (status) {
                case NO: {
                    imageName = "16-em-cross.png";
                    break;
                }
                case NOT_APPLICABLE: {
                    imageName = "progress_rem.gif";
                    break;
                }
                case PARTIALLY: {
                    imageName = "16-clock.png";
                    break;
                }
                case YES: {
                    imageName = "16-em-check.png";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled implementation status " + status);
                }
            }
        }
        return ImageCache.getInstance().getImage(imageName);
    }

    private static Image createImageWithOverlay(Image baseImage, Image overlayImage) {
        ImageWithOverlayDescriptor imageWithOverlayDescriptor = new ImageWithOverlayDescriptor(baseImage, overlayImage);
        return ImageCache.getInstance().getImage((ImageDescriptor)imageWithOverlayDescriptor);
    }

    private static Image getImageByImplementationState(String state) {
        String imageName = IMAGE_NAME_BY_STATE.get(state);
        if (imageName == null) {
            imageName = "exclamation.png";
        }
        return ImageCache.getInstance().getImage(imageName);
    }

    private CnAImageProvider() {
    }

    private static final class ImageWithOverlayDescriptor
    extends CompositeImageDescriptor {
        private final Image baseImage;
        private final Image overlayImage;

        private ImageWithOverlayDescriptor(Image baseImage, Image overlayImage) {
            this.baseImage = baseImage;
            this.overlayImage = overlayImage;
        }

        protected Point getSize() {
            return new Point(16, 16);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.baseImage.getImageData(), 0, 0);
            this.drawImage(this.overlayImage.getImageData().scaledTo(8, 8), 0, 0);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseImage == null ? 0 : this.baseImage.hashCode());
            result = 31 * result + (this.overlayImage == null ? 0 : this.overlayImage.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            ImageWithOverlayDescriptor other = (ImageWithOverlayDescriptor)((Object)obj);
            if (this.baseImage == null ? other.baseImage != null : !this.baseImage.equals((Object)other.baseImage)) {
                return false;
            }
            return !(this.overlayImage == null ? other.overlayImage != null : !this.overlayImage.equals((Object)other.overlayImage));
        }
    }
}

