/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.Messages;
import sernet.gs.ui.rcp.main.actions.GSMBasicSecurityCheckAction;
import sernet.gs.ui.rcp.main.actions.ShowAccessControlEditAction;
import sernet.gs.ui.rcp.main.actions.ShowBulkEditAccountsAction;
import sernet.gs.ui.rcp.main.actions.ShowBulkEditAction;
import sernet.gs.ui.rcp.main.actions.ShowKonsolidatorAction;
import sernet.gs.ui.rcp.main.bsi.actions.BausteinZuordnungAction;
import sernet.gs.ui.rcp.main.bsi.actions.GSMBausteinZuordnungAction;
import sernet.gs.ui.rcp.main.bsi.actions.NaturalizeAction;
import sernet.gs.ui.rcp.main.bsi.dnd.BSIModelViewDragListener;
import sernet.gs.ui.rcp.main.bsi.dnd.BSIModelViewDropListener;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BausteinUmsetzungTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IBSIStrukturElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IGSModelElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ISO27kElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.SearchViewElementTransfer;
import sernet.gs.ui.rcp.main.bsi.editors.AttachmentEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.filter.BSIModelElementFilter;
import sernet.gs.ui.rcp.main.bsi.filter.LebenszyklusPropertyFilter;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenSiegelFilter;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenUmsetzungFilter;
import sernet.gs.ui.rcp.main.bsi.filter.ObjektLebenszyklusPropertyFilter;
import sernet.gs.ui.rcp.main.bsi.filter.TagFilter;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizard;
import sernet.gs.ui.rcp.main.bsi.views.BSIModelViewLabelProvider;
import sernet.gs.ui.rcp.main.bsi.views.CnAElementByTitelComparator;
import sernet.gs.ui.rcp.main.bsi.views.OpenCataloguesJob;
import sernet.gs.ui.rcp.main.bsi.views.actions.BSIModelViewFilterAction;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.iso27k.rcp.ILinkedWithEditorView;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.LinkWithEditorPartListener;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.NullModel;
import sernet.verinice.model.bsi.risikoanalyse.FinishedRiskAnalysis;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.ds.IDatenschutzElement;
import sernet.verinice.rcp.IAttachedToPerspective;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.rcp.tree.TreeContentProvider;
import sernet.verinice.rcp.tree.TreeUpdateListener;
import sernet.verinice.service.commands.crud.LoadCnAElementByType;
import sernet.verinice.service.tree.ElementManager;

public class BsiModelView
extends RightsEnabledView
implements IAttachedToPerspective,
ILinkedWithEditorView {
    private static final Logger LOG = Logger.getLogger(BsiModelView.class);
    public static final String ID = "sernet.gs.ui.rcp.main.views.bsimodelview";
    private DrillDownAdapter drillDownAdapter;
    private TreeViewer viewer;
    private BSIModelViewFilterAction filterAction;
    private ElementManager elementManager;
    private Action expandAllAction;
    private Action collapseAction;
    private Action linkWithEditorAction;
    private ShowBulkEditAction bulkEditAction;
    private ShowBulkEditAccountsAction bulkEditAccountsAction;
    private ShowAccessControlEditAction accessControlEditAction;
    private NaturalizeAction naturalizeAction;
    private Action selectEqualsAction;
    private ShowKonsolidatorAction konsolidatorAction;
    private GSMBasicSecurityCheckAction gsmbasicsecuritycheckAction;
    private BausteinZuordnungAction bausteinZuordnungAction;
    private GSMBausteinZuordnungAction gsmbausteinZuordnungAction;
    private IModelLoadListener modelLoadListener;
    private TreeUpdateListener bsiModelListener;
    private boolean linkingActive = false;
    private IPartListener2 linkWithEditorPartListener = new LinkWithEditorPartListener(this);

    public BsiModelView() {
        this.elementManager = new ElementManager();
    }

    public void dispose() {
        CnAElementFactory.getLoadedModel().removeBSIModelListener((IBSIModelListener)this.bsiModelListener);
        CnAElementFactory.getInstance().removeLoadListener(this.modelLoadListener);
        this.getSite().getPage().removePartListener(this.linkWithEditorPartListener);
        super.dispose();
    }

    private void refreshModelAsync(BSIModel model) {
        Display.getDefault().asyncExec(() -> {
            try {
                if (!this.viewer.getControl().isDisposed()) {
                    this.viewer.setInput((Object)model);
                    this.viewer.refresh();
                }
            }
            catch (Exception e) {
                ExceptionUtil.log(e, sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_18);
            }
        });
    }

    @Override
    public String getRightID() {
        return "bsimodelview";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    private void addBSIFilter() {
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IDatenschutzElement);
            }
        });
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        try {
            this.initView(parent);
            this.startInitDataJob();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating organization view", (Throwable)e);
            ExceptionUtil.log(e, sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_7);
        }
        BsiModelView.loadItBaselineProtectionCatalogs();
    }

    private void initView(Composite parent) {
        IWorkbench workbench = this.getSite().getWorkbenchWindow().getWorkbench();
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        TreeContentProvider contentProvider = new TreeContentProvider(this.elementManager);
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new BSIModelViewLabelProvider(), (ILabelDecorator)workbench.getDecoratorManager()));
        this.viewer.setComparator((ViewerComparator)new CnAElementByTitelComparator());
        this.toggleLinking(Activator.getDefault().getPreferenceStore().getBoolean("link_to_editor"));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.createPullDownMenu();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.hookDNDListeners();
        this.addBSIFilter();
        this.fillLocalToolBar();
        this.getSite().getPage().addPartListener(this.linkWithEditorPartListener);
        this.refreshModelAsync((BSIModel)new NullModel());
    }

    protected void startInitDataJob() {
        WorkspaceJob initDataJob = new WorkspaceJob(sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_5){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask(sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_5, -1);
                        BsiModelView.this.initData();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while loading data.", (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_9, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleInitJob(initDataJob);
    }

    private void initData() {
        if (CnAElementFactory.isModelLoaded()) {
            BSIModel loadedModel = CnAElementFactory.getLoadedModel();
            if (this.bsiModelListener == null) {
                this.bsiModelListener = new TreeUpdateListener(this.viewer, this.elementManager);
                loadedModel.addBSIModelListener((IBSIModelListener)this.bsiModelListener);
            }
            this.refreshModelAsync(loadedModel);
        } else if (this.modelLoadListener == null) {
            this.modelLoadListener = new DefaultModelLoadListener(){

                @Override
                public void loaded(BSIModel model) {
                    BsiModelView.this.startInitDataJob();
                }
            };
            CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener);
        }
    }

    private static void loadItBaselineProtectionCatalogs() {
        OpenCataloguesJob job = new OpenCataloguesJob(sernet.gs.ui.rcp.main.bsi.views.Messages.BSIMassnahmenView_0);
        JobScheduler.scheduleInitJob(job);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("content"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("special"));
        manager.add((IAction)this.bulkEditAction);
        manager.add((IAction)this.bulkEditAccountsAction);
        manager.add((IAction)this.accessControlEditAction);
        manager.add((IAction)this.naturalizeAction);
        manager.add((IAction)this.selectEqualsAction);
        this.selectEqualsAction.setEnabled(this.bausteinSelected());
        manager.add((IAction)this.konsolidatorAction);
        manager.add((IAction)this.gsmbasicsecuritycheckAction);
        manager.add((IAction)this.bausteinZuordnungAction);
        manager.add((IAction)this.gsmbausteinZuordnungAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAction);
    }

    private boolean bausteinSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        return sel.size() == 1 && sel.getFirstElement() instanceof BausteinUmsetzung;
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.filterAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IAction)this.linkWithEditorAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillContextMenu);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDNDListeners() {
        Transfer[] dropTypes = new Transfer[]{IGSModelElementTransfer.getInstance(), BausteinUmsetzungTransfer.getInstance(), IBSIStrukturElementTransfer.getInstance(), SearchViewElementTransfer.getInstance(), ISO27kElementTransfer.getInstance()};
        Transfer[] dragTypes = new Transfer[]{IBSIStrukturElementTransfer.getInstance(), BausteinUmsetzungTransfer.getInstance()};
        int operations = 3;
        this.viewer.addDropSupport(operations, dropTypes, (DropTargetListener)new BSIModelViewDropListener(this.viewer));
        this.viewer.addDragSupport(operations, dragTypes, (DragSourceListener)new BSIModelViewDragListener(this.viewer));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(event -> {
            ISelection selection = event.getViewer().getSelection();
            if (!selection.isEmpty()) {
                Object sel = ((IStructuredSelection)selection).getFirstElement();
                if (sel instanceof FinishedRiskAnalysis) {
                    FinishedRiskAnalysis analysis = (FinishedRiskAnalysis)sel;
                    if (CnAElementHome.getInstance().isWriteAllowed((CnATreeElement)analysis)) {
                        RiskAnalysisWizard wizard = new RiskAnalysisWizard(analysis.getParent(), analysis);
                        wizard.init(PlatformUI.getWorkbench(), null);
                        WizardDialog wizDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                        wizDialog.setPageSize(wizard.getWidth(), wizard.getHeight());
                        wizDialog.open();
                    } else {
                        MessageDialog.openError((Shell)this.viewer.getTree().getShell(), (String)sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_RA_0, (String)sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_RA_1);
                    }
                } else {
                    EditorFactory.getInstance().updateAndOpenObject(sel);
                }
            }
        });
    }

    private void makeActions() {
        int newSelDefaultSize = 10;
        this.selectEqualsAction = new Action(){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)BsiModelView.this.viewer.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof BausteinUmsetzung) {
                    BausteinUmsetzung sourceBst = (BausteinUmsetzung)o;
                    ArrayList<BausteinUmsetzung> newsel = new ArrayList<BausteinUmsetzung>(10);
                    newsel.add(sourceBst);
                    try {
                        LoadCnAElementByType command = new LoadCnAElementByType(BausteinUmsetzung.class);
                        command = (LoadCnAElementByType)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        List bausteine = command.getElements();
                        for (BausteinUmsetzung bst : bausteine) {
                            if (!bst.getKapitel().equals(sourceBst.getKapitel())) continue;
                            newsel.add(bst);
                        }
                    }
                    catch (CommandException e) {
                        ExceptionUtil.log(e, "");
                    }
                    BsiModelView.this.viewer.setSelection((ISelection)new StructuredSelection(newsel));
                }
            }
        };
        this.selectEqualsAction.setText(sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_11);
        this.bulkEditAction = new ShowBulkEditAction(this.getViewSite(), sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_13);
        this.bulkEditAccountsAction = new ShowBulkEditAccountsAction(this.getViewSite(), Messages.ContextMenuAccountBulkEditor);
        this.accessControlEditAction = new ShowAccessControlEditAction(this.getViewSite(), sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_14);
        this.naturalizeAction = new NaturalizeAction(this.getViewSite());
        this.konsolidatorAction = new ShowKonsolidatorAction(this.getViewSite(), sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_15);
        this.gsmbasicsecuritycheckAction = new GSMBasicSecurityCheckAction(this.getViewSite().getWorkbenchWindow(), sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_19);
        this.bausteinZuordnungAction = new BausteinZuordnungAction(this.getViewSite().getWorkbenchWindow());
        this.gsmbausteinZuordnungAction = new GSMBausteinZuordnungAction(this.getViewSite().getWorkbenchWindow());
        BSIModelElementFilter modelElementFilter = new BSIModelElementFilter((StructuredViewer)this.viewer);
        this.filterAction = new BSIModelViewFilterAction(sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_3, new MassnahmenUmsetzungFilter((StructuredViewer)this.viewer), new MassnahmenSiegelFilter((StructuredViewer)this.viewer), new LebenszyklusPropertyFilter((StructuredViewer)this.viewer), new ObjektLebenszyklusPropertyFilter((StructuredViewer)this.viewer), modelElementFilter, new TagFilter((StructuredViewer)this.viewer));
        this.expandAllAction = new Action(){

            public void run() {
                BsiModelView.this.expandAll();
            }
        };
        this.expandAllAction.setText(sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_16);
        this.expandAllAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("expandall.gif"));
        this.collapseAction = new Action(){

            public void run() {
                BsiModelView.this.viewer.collapseAll();
            }
        };
        this.collapseAction.setText(sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_17);
        this.collapseAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("collapseall.gif"));
        this.linkWithEditorAction = new Action(sernet.gs.ui.rcp.main.bsi.views.Messages.BsiModelView_6, 2){

            public void run() {
                BsiModelView.this.toggleLinking(this.isChecked());
            }
        };
        this.linkWithEditorAction.setChecked(this.isLinkingActive());
        this.linkWithEditorAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("linked.gif"));
    }

    protected void buildBausteinUmsetzung(BausteinUmsetzung sourceBst) {
        int newSelDefaultSize = 10;
        ArrayList<BausteinUmsetzung> newsel = new ArrayList<BausteinUmsetzung>(10);
        newsel.add(sourceBst);
        try {
            LoadCnAElementByType command = new LoadCnAElementByType(BausteinUmsetzung.class);
            command = (LoadCnAElementByType)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            List bausteine = command.getElements();
            for (BausteinUmsetzung bst : bausteine) {
                if (!bst.getKapitel().equals(sourceBst.getKapitel())) continue;
                newsel.add(bst);
            }
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, "");
        }
        this.viewer.setSelection((ISelection)new StructuredSelection(newsel));
    }

    private void expandAll() {
        this.viewer.expandAll();
    }

    @Override
    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createPullDownMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.filterAction);
        menuManager.add((IAction)this.expandAllAction);
        menuManager.add((IAction)this.collapseAction);
        menuManager.add((IContributionItem)new Separator());
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    @Override
    public String getPerspectiveId() {
        return "sernet.gs.ui.rcp.main.perspective";
    }

    @Override
    public void editorActivated(IEditorPart editor) {
        if (!this.isLinkingActive() || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        CnATreeElement element = BSIElementEditorInput.extractElement(editor);
        if (element == null) {
            element = BsiModelView.getElementFromAttachment(editor);
        }
        if (element != null && (element instanceof IBSIStrukturElement || element instanceof MassnahmenUmsetzung || element instanceof BausteinUmsetzung)) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        }
    }

    protected void toggleLinking(boolean checked) {
        this.linkingActive = checked;
        if (checked) {
            Optional.ofNullable(this.getSite().getPage().getActiveEditor()).ifPresent(this::editorActivated);
        }
    }

    protected boolean isLinkingActive() {
        return this.linkingActive;
    }

    private static CnATreeElement getElementFromAttachment(IEditorPart editor) {
        return AttachmentEditorInput.extractCnaTreeElement(editor);
    }
}

