/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import sernet.gs.service.GSServiceException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.CnAWorkspace;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.StatusLine;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorMultiPage;
import sernet.gs.ui.rcp.main.bsi.views.HtmlWriter;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.bsi.views.RelationView;
import sernet.gs.ui.rcp.main.bsi.views.SerializeBrowserLoadingListener;
import sernet.gs.ui.rcp.main.bsi.views.listeners.DisableContextMenuListener;
import sernet.gs.ui.rcp.main.bsi.views.listeners.WhiteListLocationListener;
import sernet.verinice.iso27k.rcp.ILinkedWithEditorView;
import sernet.verinice.iso27k.rcp.ISMView;
import sernet.verinice.iso27k.rcp.LinkWithEditorPartListener;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.IControl;
import sernet.verinice.rcp.RightsEnabledView;

public class BrowserView
extends RightsEnabledView
implements ILinkedWithEditorView {
    private static final Logger LOG = Logger.getLogger(BrowserView.class);
    public static final String ID = "sernet.gs.ui.rcp.main.bsi.views.browserview";
    private Browser browser;
    private ISelectionListener selectionListener;
    private IPartListener2 linkWithEditorPartListener = new LinkWithEditorPartListener(this);
    private boolean linkingActive = true;
    private SerializeBrowserLoadingListener serializeListener;
    private CnATreeElement selectedInISMView;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        GridLayout gl = new GridLayout(1, false);
        parent.setLayout((Layout)gl);
        try {
            this.browser = new Browser(parent, 0);
            this.browser.setLayoutData((Object)new GridData(1808));
            this.browser.setJavascriptEnabled(false);
            this.browser.addMenuDetectListener((MenuDetectListener)new DisableContextMenuListener());
            this.browser.addLocationListener((LocationListener)new WhiteListLocationListener(Arrays.asList("about:blank", BrowserView.defaultImage())));
            this.serializeListener = new SerializeBrowserLoadingListener(this.browser);
            this.browser.addProgressListener((ProgressListener)this.serializeListener);
            this.browser.setUrl(BrowserView.defaultImage());
            Action linkWithEditorAction = new Action(Messages.BrowserView_0, 2){

                public void run() {
                    BrowserView.this.toggleLinking(this.isChecked());
                }
            };
            this.toggleLinking(Activator.getDefault().getPreferenceStore().getBoolean("link_to_editor"));
            linkWithEditorAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("linked.gif"));
            this.getViewSite().getActionBars().getToolBarManager().add((IAction)linkWithEditorAction);
            linkWithEditorAction.setChecked(this.isLinkingActive());
            this.hookPageSelection();
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.BrowserView_3);
        }
    }

    protected void toggleLinking(boolean checked) {
        this.linkingActive = checked;
        if (checked) {
            Optional.ofNullable(this.getSite().getPage().getActiveEditor()).ifPresent(this::editorActivated);
        }
    }

    protected boolean isLinkingActive() {
        return this.linkingActive;
    }

    @Override
    public String getRightID() {
        return "bsibrowser";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    private static String defaultImage() {
        return CnAWorkspace.getInstance().getWorkdir().toPath().resolve("html").resolve("about.html").toUri().toString();
    }

    private void hookPageSelection() {
        this.selectionListener = this::pageSelectionChanged;
        this.getSite().getPage().addPostSelectionListener(this.selectionListener);
        this.getSite().getPage().addPartListener(this.linkWithEditorPartListener);
    }

    protected void pageSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this && selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (part instanceof ISMView) {
                this.setSelectedInISMView(element);
            } else if (part instanceof RelationView) {
                if (element instanceof CnALink) {
                    element = this.determineLinkedElement((CnALink)element);
                }
            } else if (part instanceof BSIElementEditorMultiPage && element instanceof CnALink && this.isLinkingActive()) {
                element = this.determineLinkedElement((CnALink)element);
            }
            if (element != null) {
                this.elementSelected(element);
            }
        }
    }

    private void setSelectedInISMView(Object element) {
        if (element instanceof CnATreeElement) {
            this.selectedInISMView = (CnATreeElement)element;
        }
    }

    private Object determineLinkedElement(CnALink link) {
        CnATreeElement dependant = link.getDependant();
        CnATreeElement dependency = link.getDependency();
        if (dependant instanceof IControl && !dependant.equals(this.selectedInISMView)) {
            return dependant;
        }
        if (dependency instanceof IControl && !dependency.equals(this.selectedInISMView) || dependant.equals(dependency)) {
            return dependency;
        }
        return null;
    }

    protected void elementSelected(Object element) {
        String html = null;
        try {
            StatusLine.setErrorMessage("");
            html = HtmlWriter.getHtml(element);
        }
        catch (GSServiceException e) {
            StatusLine.setErrorMessage(String.valueOf(Messages.BrowserView_4) + Messages.BrowserView_5);
            LOG.error((Object)(String.valueOf(Messages.BrowserView_4) + Messages.BrowserView_5), (Throwable)e);
        }
        if (!StringUtils.isEmpty((String)html)) {
            this.setText(html);
        } else {
            this.browser.setUrl(BrowserView.defaultImage());
        }
    }

    @Override
    public void setFocus() {
        this.browser.setFocus();
    }

    public void setText(String text) {
        if (text != null) {
            this.serializeListener.setText(text);
        }
    }

    public void dispose() {
        this.getSite().getPage().removePostSelectionListener(this.selectionListener);
        this.getSite().getPage().removePartListener(this.linkWithEditorPartListener);
        super.dispose();
    }

    @Override
    public void editorActivated(IEditorPart activeEditor) {
        CnATreeElement element;
        this.selectedInISMView = element = BSIElementEditorInput.extractElement(activeEditor);
        if (!this.isLinkingActive() || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        if (element == null) {
            return;
        }
        this.elementSelected(element);
    }
}

