/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.Massnahme;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.dnd.BSIMassnahmenViewDragListener;
import sernet.gs.ui.rcp.main.bsi.dnd.CopyBSIMassnahmenViewAction;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IGSModelElementTransfer;
import sernet.gs.ui.rcp.main.bsi.filter.GefaehrdungenFilter;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenSiegelFilter;
import sernet.gs.ui.rcp.main.bsi.views.BSIKatalogInvisibleRoot;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.bsi.views.OpenCataloguesJob;
import sernet.gs.ui.rcp.main.bsi.views.actions.MassnahmenViewFilterAction;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.rcp.IAttachedToPerspective;
import sernet.verinice.rcp.RightsEnabledView;

public class BSIMassnahmenView
extends RightsEnabledView
implements IAttachedToPerspective {
    public static final String ID = "sernet.gs.ui.rcp.main.views.bsimassnahmenview";
    private TreeViewer viewer;
    private MassnahmenViewFilterAction filterAction;
    private MassnahmenSiegelFilter siegelFilter;
    private CopyBSIMassnahmenViewAction copyAction;
    private GefaehrdungenFilter gefaehrdungenFilter;
    private Action expandAllAction;
    private Action collapseAction;
    private IModelLoadListener modelLoadListener;
    private BSIKatalogInvisibleRoot.ISelectionListener catalogChangeListener;

    @Override
    public String getRightID() {
        return "bsimassnahmen";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.viewer = new TreeViewer(parent, 2818);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setComparator((ViewerComparator)new KapitelComparator());
        this.startInitDataJob();
        this.viewer.setInput((Object)BSIKatalogInvisibleRoot.getInstance());
        this.catalogChangeListener = this::refresh;
        BSIKatalogInvisibleRoot.getInstance().addListener(this.catalogChangeListener);
        this.createActions();
        this.createFilters();
        this.createPullDownMenu();
        this.hookDNDListener();
        this.hookContextMenu();
        this.hookGlobalActions();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.fillLocalToolBar();
        this.refresh();
    }

    protected void startInitDataJob() {
        if (CnAElementFactory.getLoadedModel() != null) {
            OpenCataloguesJob job = new OpenCataloguesJob(Messages.BSIMassnahmenView_0);
            JobScheduler.scheduleInitJob(job);
        } else if (this.modelLoadListener == null) {
            this.modelLoadListener = new DefaultModelLoadListener(){

                @Override
                public void loaded(ISO27KModel model) {
                    BSIMassnahmenView.this.startInitDataJob();
                }
            };
            CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener);
        }
    }

    private void refresh() {
        Display.getDefault().asyncExec(() -> this.viewer.refresh());
    }

    private void hookGlobalActions() {
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
    }

    private void createActions() {
        this.copyAction = new CopyBSIMassnahmenViewAction(this, Messages.BSIMassnahmenView_4);
        this.expandAllAction = new Action(){

            public void run() {
                BSIMassnahmenView.this.viewer.expandAll();
            }
        };
        this.expandAllAction.setText(Messages.BSIMassnahmenView_5);
        this.expandAllAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("expandall.gif"));
        this.collapseAction = new Action(){

            public void run() {
                BSIMassnahmenView.this.viewer.collapseAll();
            }
        };
        this.collapseAction.setText(Messages.BSIMassnahmenView_6);
        this.collapseAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("collapseall.gif"));
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("content"));
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IAction)this.filterAction);
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyAction);
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.filterAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillContextMenu);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDNDListener() {
        IGSModelElementTransfer igsmTransfer = IGSModelElementTransfer.getInstance();
        Transfer[] types = new Transfer[]{igsmTransfer};
        int operations = 3;
        this.viewer.addDragSupport(operations, types, (DragSourceListener)new BSIMassnahmenViewDragListener(this.viewer));
    }

    @Override
    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createFilters() {
        this.siegelFilter = new MassnahmenSiegelFilter((StructuredViewer)this.viewer);
        this.gefaehrdungenFilter = new GefaehrdungenFilter((StructuredViewer)this.viewer);
    }

    private void createPullDownMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        this.filterAction = new MassnahmenViewFilterAction((StructuredViewer)this.viewer, Messages.BSIMassnahmenView_3, this.siegelFilter, this.gefaehrdungenFilter);
        menuManager.add((IAction)this.filterAction);
        menuManager.add((IAction)this.copyAction);
        menuManager.add((IAction)this.expandAllAction);
        menuManager.add((IAction)this.collapseAction);
    }

    public List<Baustein> getSelectedBausteine() {
        ArrayList<Baustein> result = new ArrayList<Baustein>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection) {
            if (!(o instanceof Baustein)) continue;
            result.add((Baustein)o);
        }
        return result;
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    @Override
    public String getPerspectiveId() {
        return "sernet.gs.ui.rcp.main.perspective";
    }

    public void dispose() {
        super.dispose();
        BSIKatalogInvisibleRoot.getInstance().removeListener(this.catalogChangeListener);
    }

    private static class KapitelComparator
    extends ViewerComparator {
        private KapitelComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Massnahme && e2 instanceof Massnahme) {
                int compareValue = Integer.valueOf(((Massnahme)e1).getKapitelValue()).compareTo(((Massnahme)e2).getKapitelValue());
                return compareValue;
            }
            if (e1 instanceof Gefaehrdung && e2 instanceof Gefaehrdung) {
                int compareValue = Integer.valueOf(((Gefaehrdung)e1).getKapitelValue()).compareTo(((Gefaehrdung)e2).getKapitelValue());
                return compareValue;
            }
            if (e1 instanceof Baustein && e2 instanceof Baustein) {
                int compareValue = Integer.valueOf(((Baustein)e1).getKapitelValue()).compareTo(((Baustein)e2).getKapitelValue());
                return compareValue;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    static class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        ViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parent) {
            int childrenListSize = 100;
            if (parent instanceof Baustein) {
                ArrayList children = new ArrayList(100);
                children.addAll(((Baustein)parent).getGefaehrdungen());
                children.addAll(((Baustein)parent).getMassnahmen());
                return children.toArray();
            }
            if (parent instanceof BSIKatalogInvisibleRoot) {
                return ((BSIKatalogInvisibleRoot)parent).getBausteine().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return null;
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof Baustein) {
                Baustein baustein = (Baustein)parent;
                return baustein.hasSafequardsOrThreats();
            }
            if (parent instanceof BSIKatalogInvisibleRoot) {
                return !((BSIKatalogInvisibleRoot)parent).getBausteine().isEmpty();
            }
            return false;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }
    }

    static class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public Image getImage(Object obj) {
            if (obj instanceof Baustein) {
                return ImageCache.getInstance().getImage("16-cube-blue.png");
            }
            if (obj instanceof Massnahme) {
                Massnahme mn = (Massnahme)obj;
                char stufe = mn.getSiegelstufe();
                switch (stufe) {
                    case 'A': {
                        return ImageCache.getInstance().getImage("stufe_a.png");
                    }
                    case 'B': {
                        return ImageCache.getInstance().getImage("stufe_b.png");
                    }
                    case 'C': {
                        return ImageCache.getInstance().getImage("stufe_c.png");
                    }
                    case 'Z': {
                        return ImageCache.getInstance().getImage("stufe_z.png");
                    }
                    case 'W': {
                        return ImageCache.getInstance().getImage("stufe_w.png");
                    }
                }
                return null;
            }
            if (obj instanceof Gefaehrdung) {
                return ImageCache.getInstance().getImage("dialog-warning.png");
            }
            return ImageCache.getInstance().getImage("generic_element.gif");
        }

        public String getText(Object obj) {
            if (obj instanceof Massnahme) {
                Massnahme mn = (Massnahme)obj;
                return String.valueOf(mn.getId()) + " " + mn.getTitel() + " [" + mn.getSiegelstufe() + "] (" + mn.getLZAsString(BSIKatalogInvisibleRoot.getInstance().getLanguage()) + ")";
            }
            if (obj instanceof Gefaehrdung) {
                Gefaehrdung gef = (Gefaehrdung)obj;
                return String.valueOf(gef.getId()) + " " + gef.getTitel() + " [" + gef.getKategorieAsString(BSIKatalogInvisibleRoot.getInstance().getLanguage()) + "]";
            }
            return obj.toString();
        }
    }
}

